package com.digiwin.athena.itsys.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * The persistent class for the standard_api database table.
 * 
 */
@Entity
@Table(name = "error_log")
public class ErrorMessage implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "trace_id")
	@JsonProperty("trace_id")
	private String traceId;

	@Column(name = "app_id")
	@JsonProperty("app_id")
	private String appId;

	@Column(name = "process_serial_number")
	@JsonProperty("process_serial_number")
	private String processSerialNumber;

	@Column(name = "process_activity_id")
	@JsonProperty("process_activity_id")
	private String processActivityId;

	@Column(name = "retry_url")
	@JsonProperty("retry_url")
	private String retryUrl;

	@Column(name = "token")
	@JsonProperty("token")
	private String token;

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	@Column(name = "process_activity_oid")
	@JsonProperty("process_activity_oid")
	private String processActivityOid;

	@Column(name = "tenant_id")
	@JsonProperty("tenant_id")
	private String tenantId;

	@Column(name = "exception_type")
	@JsonProperty("exception_type")
	private String exceptionType;

	@Column(name = "exception")
	@JsonProperty("exception")
	private String exception;

	@Column(name = "error_code")
	@JsonProperty("error_code")
	private String errorCode;

	@Column(name = "is_error")
	@JsonProperty("is_error")
	private boolean isError;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "last_update_time")
	private Calendar lastUpdateTime;

	@Column(name = "created_time")
	private Date createdTime;

	@Column(name = "idempotency")
	@JsonProperty("idempotency")
	private boolean idempotency;

	@Column(name = "task_uid")
	@JsonProperty("task_uid")
	private String taskUid;

	@Column(name = "action_id")
	@JsonProperty("action_id")
	private String actionId;

	@Column(name = "api_error_info")
	@JsonProperty("api_error_info")
	private String apiErrorInfo;

	@Column(name = "api_error_info_metadata")
	@JsonProperty("api_error_info_metadata")
	private String apiErrorInfoMetadata;

	public ErrorMessage () {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Calendar getBuildTime() {
		return this.buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getProcessSerialNumber() {
		return processSerialNumber;
	}

	public void setProcessSerialNumber(String processSerialNumber) {
		this.processSerialNumber = processSerialNumber;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public String getProcessActivityId() {
		return processActivityId;
	}

	public void setProcessActivityId(String processActivityId) {
		this.processActivityId = processActivityId;
	}

	public String getProcessActivityOid() {
		return processActivityOid;
	}

	public void setProcessActivityOid(String processActivityOid) {
		this.processActivityOid = processActivityOid;
	}

	public String getExceptionType() {
		return exceptionType;
	}

	public void setExceptionType(String exceptionType) {
		this.exceptionType = exceptionType;
	}

	public String getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getException() {
		return exception;
	}

	public void setException(String exception) {
		this.exception = exception;
	}

	public boolean isError() {
		return isError;
	}

	public void setIsError(boolean isError) {
		this.isError = isError;
	}

	public Calendar getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(Calendar lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	public Date getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(Date date) {
		this.createdTime = date;
	}

	public boolean isIdempotency() {
		return idempotency;
	}

	public void setIdempotency(boolean idempotency) {
		this.idempotency = idempotency;
	}

	public String getTaskUid() {
		return taskUid;
	}

	public void setTaskUid(String taskUid) {
		this.taskUid = taskUid;
	}

	public String getActionId() {
		return actionId;
	}

	public void setActionId(String actionId) {
		this.actionId = actionId;
	}

	public String getRetryUrl() {
		return retryUrl;
	}

	public void setRetryUrl(String retryUrl) {
		this.retryUrl = retryUrl;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getApiErrorInfo() {
		return apiErrorInfo;
	}

	public void setApiErrorInfo(String apiErrorInfo) {
		this.apiErrorInfo = apiErrorInfo;
	}

	public String getApiErrorInfoMetadata() {
		return apiErrorInfoMetadata;
	}

	public void setApiErrorInfoMetadata(String apiErrorInfoMetadata) {
		this.apiErrorInfoMetadata = apiErrorInfoMetadata;
	}

}