package com.digiwin.athena.itsys.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * The persistent class for the standard_api database table.
 * 
 */
@Entity
@Table(name = "error_summary")
public class ErrorSummary implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "code", unique = true)
	@JsonProperty("code")
	private String code;

	@Column(name = "cause_zh_tw")
	@JsonProperty("cause_zh_tw")
	private String causeZhTw;

	@Column(name = "cause_zh_cn")
	@JsonProperty("cause_zh_cn")
	private String causeZhCn;

	@Column(name = "cause_en_us")
	@JsonProperty("cause_en_us")
	private String causeEnUs;

	@Column(name = "app_id")
	@JsonProperty("app_id")
	private String appId;

	@Column(name = "shut_notification")
	@JsonProperty("shut_notification")
	private boolean shutNotification;

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCauseZhTw() {
		return causeZhTw;
	}

	public void setCauseZhTw(String causeZhTw) {
		this.causeZhTw = causeZhTw;
	}

	public String getCauseZhCn() {
		return causeZhCn;
	}

	public void setCauseZhCn(String causeZhCn) {
		this.causeZhCn = causeZhCn;
	}

	public String getCauseEnUs() {
		return causeEnUs;
	}

	public void setCauseEnUs(String causeEnUs) {
		this.causeEnUs = causeEnUs;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public boolean isShutNotification() {
		return shutNotification;
	}

	public void setShutNotification(boolean shutNotification) {
		this.shutNotification = shutNotification;
	}

}