package com.digiwin.athena.itsys.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * The persistent class for the standard_api database table.
 * 
 */
@Entity
@Table(name = "execution_log")
public class ExecutionLog implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "trace_id")
	@JsonProperty("trace_id")
	private String traceId;

	@Column(name = "app_id")
	@JsonProperty("app_id")
	private String appId;

	@Column(name = "created_time")
	private Date createdTime;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "tenant_id")
	@JsonProperty("tenant_id")
	private String tenantId;

	@Column(name = "state")
	@JsonProperty("state")
	private boolean state;

	@Column(name = "action_type")
	@JsonProperty("action_type")
	private String actionType;

	@Column(name = "process_data")
	@JsonProperty("process_data")
	private String processData;

	public ExecutionLog() {
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public Date getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public boolean isState() {
		return state;
	}

	public void setState(boolean state) {
		this.state = state;
	}

	public String getActionType() {
		return actionType;
	}

	public void setActionType(String actionType) {
		this.actionType = actionType;
	}

	public String getProcessData() {
		return processData;
	}

	public void setProcessData(String processData) {
		this.processData = processData;
	}

	public Calendar getBuildTime() {
		return buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

}