package com.digiwin.athena.itsys.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public class DataConvertUtil {
	private static ObjectMapper mapper = new ObjectMapper();
	
	/**
	 * 轉換用的POJO欄位 使用@JsonProperty(?)對應資料map的key名稱
	 * 如@JsonProperty("name")
	 * 日期轉換使用@JsonFormat(pattern = ?)
	 * 如@JsonFormat(pattern = "yyyy/MM/dd")
	 * 
	 * @param pJson 資料json
	 * @param pClass POJO class
	 * @return POJO實體
	 * @throws IOException 
	 * @throws JsonMappingException 
	 * @throws JsonParseException 
	 */
	public static <T> T convert(String pJson, Class<T> pClass) throws JsonParseException, JsonMappingException, IOException {
		T tInstance = mapper.readValue(pJson, pClass);
		return tInstance;
	}
	
	/**
	 * 轉換用的POJO欄位 使用@JsonProperty(?)對應資料map的key名稱
	 * 如@JsonProperty("name")
	 * 日期轉換使用@JsonFormat(pattern = ?)
	 * 如@JsonFormat(pattern = "yyyy/MM/dd")
	 * 
	 * @param pJson 資料json
	 * @param pClass POJO class
	 * @return POJO實體
	 * @throws IOException 
	 * @throws JsonMappingException 
	 * @throws JsonParseException 
	 */
	public static <T> T convert(JsonNode pJson, Class<T> pClass) throws JsonParseException, JsonMappingException, IOException {
		T tInstance = mapper.convertValue(pJson, pClass);
		return tInstance;
	}

	/**
	 * 轉換用的POJO欄位 使用@JsonProperty(?)對應資料map的key名稱
	 * 如@JsonProperty("name")
	 * 日期轉換使用@JsonFormat(pattern = ?)
	 * 如@JsonFormat(pattern = "yyyy/MM/dd")
	 * 
	 * @param pData 資料map
	 * @param pClass POJO class
	 * @return POJO實體
	 */
	public static <T> T convert(Map<String, Object> pData, Class<T> pClass) {
		T tInstance = mapper.convertValue(pData, pClass);
		return tInstance;
	}
	
	/**
	 * 轉換用的POJO欄位 使用@JsonProperty(?)對應資料map的key名稱
	 * 如@JsonProperty("name")
	 * 日期轉換使用@JsonFormat(pattern = ?)
	 * 如@JsonFormat(pattern = "yyyy/MM/dd")
	 * 
	 * @param pJson 資料Json
	 * @param pClass POJO class
	 * @return POJO實體
	 * @throws IOException 
	 * @throws JsonMappingException 
	 * @throws JsonParseException 
	 */
	public static <T> List<T> convertList(String pJson, Class<T> pClass) throws JsonParseException, JsonMappingException, IOException {
		JavaType tType = mapper.getTypeFactory().constructCollectionType(List.class, pClass);
		List<T> tInstanceList = mapper.readValue(pJson, tType);
		return tInstanceList;
	}
	
	/**
	 * 轉換用的POJO欄位 使用@JsonProperty(?)對應資料map的key名稱
	 * 如@JsonProperty("name")
	 * 日期轉換使用@JsonFormat(pattern = ?)
	 * 如@JsonFormat(pattern = "yyyy/MM/dd")
	 * 
	 * @param pJson 資料Json
	 * @param pClass POJO class
	 * @return POJO實體
	 * @throws IOException 
	 * @throws JsonMappingException 
	 * @throws JsonParseException 
	 */
	public static <T> List<T> convertList(JsonNode pJson, Class<T> pClass) throws JsonParseException, JsonMappingException, IOException {
		JavaType tType = mapper.getTypeFactory().constructCollectionType(List.class, pClass);
		List<T> tInstanceList = mapper.convertValue(pJson, tType);
		return tInstanceList;
	}

	/**
	 * 轉換用的POJO欄位 使用@JsonProperty(?)對應資料map的key名稱
	 * 如@JsonProperty("name")
	 * 日期轉換使用@JsonFormat(pattern = ?)
	 * 如@JsonFormat(pattern = "yyyy/MM/dd")
	 * 
	 * @param pDataList 資料List<Map>
	 * @param pClass POJO class
	 * @return POJO實體
	 */
	public static <T> List<T> convertList(List<Map<String, Object>> pDataList, Class<T> pClass) {
		List<T> tInstanceList = new ArrayList<T>();
		for (Map<String, Object> tData : pDataList) {
			tInstanceList.add(convert(tData, pClass));
		}
		return tInstanceList;
	}
	
}
