package com.digiwin.athena.itsys.util;

import org.apache.commons.lang3.StringUtils;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;

/**
 * LocaleUtils
 * 多語系操作类
 */
public class LocaleUtils {
    public static final Locale DEFAULT_LOCALE = new Locale("zh", "CN");

    public static Locale convert2Locale(String pLocaleStr){
        Locale tNeedfulLocale = null;
        if (pLocaleStr != null && !"".equals(pLocaleStr)) {
            String[] tLocaleCode = pLocaleStr.split("_");
            if (tLocaleCode.length == 1) {
                tNeedfulLocale = new Locale(tLocaleCode[0]);
            } else if (tLocaleCode.length == 2) {
                tNeedfulLocale = new Locale(tLocaleCode[0], tLocaleCode[1]);
            }
        }
        if (tNeedfulLocale == null) {
            tNeedfulLocale = DEFAULT_LOCALE;
        }
        return tNeedfulLocale;
    }

    /**
     * 通过上下文获取流程语言
     * @param variables 上下文变量
     * @return 语言，默认zh_CN
     */
    public static String getLocale(Map<String,Object> variables){
        if(Objects.nonNull(variables) && StringUtils.isNotBlank((String)variables.get("processLocale"))){
            return variables.get("processLocale").toString();
        }
        return DEFAULT_LOCALE.toString();
    }

}
