package com.digiwin.athena.itsys.util;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * FIXME I18nUtils LanguageUtils 与当前类的差异需要明确，是否可以合并成一个类，内聚功能
 * 取得多語系的工具
 */
public class ResourceBundleUtil {

    protected static final Log log = LogFactory.getLog(ResourceBundleUtil.class);

    private static final String EN_US = "en_US";

    private static final String ZH_TW = "zh_TW";

    private static final String ZH_CN = "zh_CN";

    /**
     * 取得多語系
     */
    public static String getString(String key, Locale locale) {
        ResourceBundle tResourceBundle = ResourceBundle.getBundle("itsys", locale);
        log.info("测试多语言，tResourceBundle=" + JSONObject.toJSONString(tResourceBundle));
        return tResourceBundle.getString(key);
    }

    /**
     * 获取多语言
     *
     * @param key    code
     * @param locale 语言
     * @return 多语言文案
     */
    public static String getString(String key, String locale) {
        if (StringUtils.isBlank(key)) {
            return "";
        }
        Locale tLocale = LocaleUtils.convert2Locale(locale);
        log.info("测试多语言,tLocale:" + tLocale);
        return getString(key, tLocale);
    }

    /**
     * 获取所有多语言的json字符串
     *
     * @param key key
     * @return
     */
    public static String getJsonString(String key) {
        JSONObject result = new JSONObject(4);
        result.put(EN_US, getString(key, EN_US));
        result.put(ZH_CN, getString(key, ZH_CN));
        result.put(ZH_TW, getString(key, ZH_TW));
        return result.toJSONString();
    }
}