/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.service.DWEAIResult;
import com.digiwin.athena.itsys.exception.BaseException;
import com.digiwin.athena.itsys.validator.JsonSchemaValidator;
import com.digiwin.athena.itsys.validator.ValidatorResult;
import com.digiwin.http.client.DWHttpClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractApiProcessor {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected DWHttpClient dwHttpClient;
    final JsonSchemaValidator jsonSchemaValidator = new JsonSchemaValidator();
    ObjectMapper mapper = new ObjectMapper();
    protected String jsonSchemaFileName;

    public DWEAIResult execute(String pRequestMsg) throws Exception {
        ValidatorResult tValidatorResult = this.validate(pRequestMsg);
        return this.process(tValidatorResult);
    }

    private ValidatorResult validate(String pMsg) throws BaseException, Exception {
        return this.jsonSchemaValidator.validate(pMsg, this.jsonSchemaFileName);
    }

    protected abstract DWEAIResult process(ValidatorResult var1) throws BaseException, Exception;
}

