/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.api.service.processor.AbstractConsumeProcessor;
import com.digiwin.athena.itsys.dao.ActivityLogDao;
import com.digiwin.athena.itsys.dao.ErrorMessageDao;
import com.digiwin.athena.itsys.enums.ActivityLogConditionEnum;
import com.digiwin.athena.itsys.enums.ActivityLogJsonAttributeEnum;
import com.digiwin.athena.itsys.enums.AppTypeEnum;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.model.ActivityLog;
import com.digiwin.athena.itsys.model.ErrorMessage;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityLogConsumeProcessor
extends AbstractConsumeProcessor {
    @Autowired
    private ActivityLogDao activityLogDao;
    @Autowired
    private ErrorMessageDao errorMessageDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    ObjectMapper mapper = new ObjectMapper();

    public ActivityLogConsumeProcessor() {
        this.queueType = MessageQueueTypeEnum.ACTIVITY_LOG_QUEUE;
    }

    @Override
    protected void handleQueueMessage(String pMessage) throws Exception {
        JsonNode tMessageNode = this.mapper.readTree(pMessage);
        if (tMessageNode.get(ActivityLogJsonAttributeEnum.appId.toString()) != null && tMessageNode.get(ActivityLogJsonAttributeEnum.appId.toString()).asText().equals(AppTypeEnum.PTM.getType())) {
            HashMap<String, String> tActivityLogCondition = new HashMap<String, String>();
            tActivityLogCondition.put(ActivityLogConditionEnum.APP_ID.toString(), tMessageNode.get(ActivityLogJsonAttributeEnum.appId.toString()).asText());
            tActivityLogCondition.put(ActivityLogConditionEnum.TENANT_ID.toString(), tMessageNode.get(ActivityLogJsonAttributeEnum.tenantId.toString()).asText());
            tActivityLogCondition.put(ActivityLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(), tMessageNode.get(ActivityLogJsonAttributeEnum.processSerialNumber.toString()).asText());
            tActivityLogCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(), tMessageNode.get(ActivityLogJsonAttributeEnum.activityUID.toString()).asText());
            if (tMessageNode.get(ActivityLogJsonAttributeEnum.taskCardId.toString()) != null) {
                tActivityLogCondition.put(ActivityLogConditionEnum.TASK_CARD_ID.toString(), tMessageNode.get(ActivityLogJsonAttributeEnum.taskCardId.toString()).asText());
            }
            tActivityLogCondition.put(ActivityLogConditionEnum.TASK_UID.toString(), tMessageNode.get(ActivityLogJsonAttributeEnum.taskUid.toString()).asText());
            List<ActivityLog> tActivityLogs = this.activityLogDao.fetch(tActivityLogCondition);
            if (!tActivityLogs.isEmpty()) {
                this.updateActivityLog(tActivityLogs.get(0), tMessageNode);
            } else {
                this.saveActivityLog(tMessageNode);
            }
        } else if (tMessageNode.get(ActivityLogJsonAttributeEnum.appId.toString()).asText().equals(AppTypeEnum.ATMC.getType())) {
            this.saveActivityLog(tMessageNode);
        }
        this.updateFinishedActivityErrorLog(tMessageNode);
    }

    protected ActivityLog saveActivityLog(JsonNode pMessageNode) throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        ArrayNode arrayNode;
        ActivityLog tActivityLog = new ActivityLog();
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.operate.toString()) != null) {
            tActivityLog.setOperate(pMessageNode.get(ActivityLogJsonAttributeEnum.operate.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.sourceNo.toString()) != null) {
            tActivityLog.setSourceNo(pMessageNode.get(ActivityLogJsonAttributeEnum.sourceNo.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.agentPerformerId.toString()) != null) {
            tActivityLog.setAgentPerformerId(pMessageNode.get(ActivityLogJsonAttributeEnum.agentPerformerId.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.agentPerformerName.toString()) != null) {
            tActivityLog.setAgentPerformerName(pMessageNode.get(ActivityLogJsonAttributeEnum.agentPerformerName.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.performerType.toString()) != null) {
            tActivityLog.setPerformerType(pMessageNode.get(ActivityLogJsonAttributeEnum.performerType.toString()).asText());
        }
        try {
            if (pMessageNode.get(ActivityLogJsonAttributeEnum.operateTime.toString()) != null) {
                tActivityLog.setOperateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ActivityLogJsonAttributeEnum.operateTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.sourceIds.toString()) != null) {
            tActivityLog.setSourceNo(pMessageNode.get(ActivityLogJsonAttributeEnum.sourceIds.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.traceId.toString()) != null) {
            tActivityLog.setTraceId(pMessageNode.get(ActivityLogJsonAttributeEnum.traceId.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.appId.toString()) != null) {
            tActivityLog.setAppId(pMessageNode.get(ActivityLogJsonAttributeEnum.appId.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.processSerialNumber.toString()) != null) {
            tActivityLog.setProcessSerialNumber(pMessageNode.get(ActivityLogJsonAttributeEnum.processSerialNumber.toString()).asText());
        }
        try {
            if (pMessageNode.get(ActivityLogJsonAttributeEnum.createdTime.toString()) != null) {
                tActivityLog.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ActivityLogJsonAttributeEnum.createdTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (pMessageNode.get(ActivityLogJsonAttributeEnum.operateTime.toString()) != null) {
                tActivityLog.setOperateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ActivityLogJsonAttributeEnum.operateTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (pMessageNode.get(ActivityLogJsonAttributeEnum.completedTime.toString()) != null) {
                tActivityLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ActivityLogJsonAttributeEnum.completedTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.tenantId.toString()) != null) {
            tActivityLog.setTenantId(pMessageNode.get(ActivityLogJsonAttributeEnum.tenantId.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.state.toString()) != null) {
            tActivityLog.setState(pMessageNode.get(ActivityLogJsonAttributeEnum.state.toString()).asInt());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.subState.toString()) != null) {
            tActivityLog.setSubState(pMessageNode.get(ActivityLogJsonAttributeEnum.subState.toString()).asInt());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.activityUID.toString()) != null) {
            tActivityLog.setActivityUid(pMessageNode.get(ActivityLogJsonAttributeEnum.activityUID.toString()).asText());
        }
        try {
            if (pMessageNode.get(ActivityLogJsonAttributeEnum.performerId.toString()) != null) {
                if (pMessageNode.get(ActivityLogJsonAttributeEnum.appId.toString()).asText().equals("ptm")) {
                    tActivityLog.setPerformerId(pMessageNode.get(ActivityLogJsonAttributeEnum.performerId.toString()).asText());
                } else {
                    arrayNode = (ArrayNode)this.mapper.readTree(pMessageNode.get(ActivityLogJsonAttributeEnum.performerId.toString()).toString());
                    if (arrayNode.size() != 0) {
                        tActivityLog.setPerformerId(arrayNode.get(0).asText());
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (pMessageNode.get(ActivityLogJsonAttributeEnum.performerName.toString()) != null) {
                if (pMessageNode.get(ActivityLogJsonAttributeEnum.appId.toString()).asText().equals("ptm")) {
                    tActivityLog.setPerformerName(pMessageNode.get(ActivityLogJsonAttributeEnum.performerName.toString()).asText());
                } else {
                    arrayNode = (ArrayNode)this.mapper.readTree(pMessageNode.get(ActivityLogJsonAttributeEnum.performerName.toString()).toString());
                    if (arrayNode.size() != 0) {
                        tActivityLog.setPerformerName(arrayNode.get(0).asText());
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.activityCode.toString()) != null) {
            tActivityLog.setActivityCode(pMessageNode.get(ActivityLogJsonAttributeEnum.activityCode.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.activityType.toString()) != null) {
            tActivityLog.setActivityType(pMessageNode.get(ActivityLogJsonAttributeEnum.activityType.toString()).asText());
        }
        try {
            if (pMessageNode.get(ActivityLogJsonAttributeEnum.activityName.toString()) != null) {
                JsonNode jsonNode = this.mapper.readTree(pMessageNode.get(ActivityLogJsonAttributeEnum.activityName.toString()).asText());
                tActivityLog.setActivityNameZhTw(jsonNode.get("zh_TW").asText());
                tActivityLog.setActivityNameZhCn(jsonNode.get("zh_CN").asText());
                tActivityLog.setActivityNameEnUs(jsonNode.get("en_US").asText());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.taskUid.toString()) != null) {
            tActivityLog.setTaskUid(pMessageNode.get(ActivityLogJsonAttributeEnum.taskUid.toString()).asText());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.taskCardId.toString()) != null) {
            tActivityLog.setTaskCardId(pMessageNode.get(ActivityLogJsonAttributeEnum.taskCardId.toString()).asText());
        }
        tActivityLog.setBuildTime(Calendar.getInstance());
        return this.activityLogDao.save(tActivityLog);
    }

    protected void updateActivityLog(ActivityLog pActivityLog, JsonNode pMessageNode) throws ParseException {
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.state.toString()) != null) {
            pActivityLog.setState(pMessageNode.get(ActivityLogJsonAttributeEnum.state.toString()).asInt());
        }
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.subState.toString()) != null) {
            pActivityLog.setSubState(pMessageNode.get(ActivityLogJsonAttributeEnum.subState.toString()).asInt());
        }
        try {
            if (pMessageNode.get(ActivityLogJsonAttributeEnum.completedTime.toString()) != null) {
                pActivityLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ActivityLogJsonAttributeEnum.completedTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        pActivityLog.setLastUpdateTime(Calendar.getInstance());
        this.activityLogDao.saveOrupdate(pActivityLog);
    }

    protected void updateFinishedActivityErrorLog(JsonNode pMessageNode) throws ParseException {
        if (pMessageNode.get(ActivityLogJsonAttributeEnum.state.toString()) != null && pMessageNode.get(ActivityLogJsonAttributeEnum.state.toString()).asInt() == 3) {
            String serialNumber = pMessageNode.get(ActivityLogJsonAttributeEnum.processSerialNumber.toString()) != null ? pMessageNode.get(ActivityLogJsonAttributeEnum.processSerialNumber.toString()).asText() : null;
            String activityOid = pMessageNode.get(ActivityLogJsonAttributeEnum.processActivityOID.toString()) != null ? pMessageNode.get(ActivityLogJsonAttributeEnum.processActivityOID.toString()).asText() : null;
            List<ErrorMessage> tErrorMessages = null;
            if (serialNumber != null && activityOid != null) {
                tErrorMessages = this.errorMessageDao.getErrorBySerialNumberAndActivityOid(serialNumber, activityOid);
            }
            if (tErrorMessages != null && !tErrorMessages.isEmpty()) {
                for (ErrorMessage tErrorMessage : tErrorMessages) {
                    tErrorMessage.setIsError(false);
                    this.errorMessageDao.saveOrupdate(tErrorMessage);
                }
            }
        }
    }
}

