/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.api.service.processor.AbstractConsumeProcessor;
import com.digiwin.athena.itsys.dao.ErrorMessageDao;
import com.digiwin.athena.itsys.dao.ErrorNotificationUserDao;
import com.digiwin.athena.itsys.dao.ErrorSummaryDao;
import com.digiwin.athena.itsys.enums.AppTypeEnum;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.model.ErrorMessage;
import com.digiwin.athena.itsys.model.ErrorNotificationUser;
import com.digiwin.athena.itsys.model.ErrorSummary;
import com.digiwin.athena.itsys.util.ResourceBundleUtil;
import com.digiwin.athena.itsys.util.StringUtil;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErrorMessageConsumeProcessor
extends AbstractConsumeProcessor {
    @Autowired
    private ErrorMessageDao errorMessageDao;
    @Autowired
    private ErrorSummaryDao errorSummaryDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    @Autowired
    ErrorNotificationUserDao errorNotificationUserDao;
    private String GET_LICENSEKEY_BY_TENANTID_PATH = "/restful/service/knowledgegraph/app/licenseKey";
    private String IAM_IDENTITY_LOGIN_PATH = "/api/iam/v2/identity/login";
    private String IAM_USERINROLE_PATH = "/api/iam/v2/association/userinrole";
    private String EMC_SEND_MAIL_PATH = "/api/emc/v1/message/sendEmail";
    private String IAM_USERINFO_PATH = "/api/iam/v2/tenant/user/info";
    private String USERMETADATA_USER_GET = "/api/iam/v2/usermetadata/user/get";
    private String GET_METADATA_PATH = "/restful/service/knowledgegraph/action/metadata";
    private String GET_MDC_METADATA_PATH = "/restful/standard/mdc/ApiMetadata/Get";
    private static String UNDEFINED_ERROR_CODE = "P.Itsys.500.9999";
    private ObjectMapper mapper = new ObjectMapper();
    private static String TASKENGINE_IGNORE_TASKCODE = DWApplicationConfigUtils.getProperty((String)"taskengine.ignore.taskCode");
    private static String TASKENGINE_IGNORE_PROJECTCODE = DWApplicationConfigUtils.getProperty((String)"taskengine.ignore.projectCode");
    @Autowired
    private RabbitTemplate template;

    public ErrorMessageConsumeProcessor() {
        this.queueType = MessageQueueTypeEnum.ERROR_MESSAGE_QUEUE;
    }

    @Override
    public void handleQueueMessage(String pMessage) throws Exception {
        JsonNode tMessageNode = this.mapper.readTree(pMessage);
        if (tMessageNode.get("isError").asBoolean()) {
            this.saveData(tMessageNode);
            this.template.convertAndSend("alarm.platform.exchange", "alarm.platform.error.route", (Object)pMessage);
        } else {
            this.updateErrorStatus(tMessageNode);
        }
    }

    protected boolean isIgnoreSend(JsonNode tMessageNode) {
        try {
            String appId = tMessageNode.get("appId").asText();
            if ("taskengine".equals(appId)) {
                String taskCode = tMessageNode.get("custom").get("taskCode").asText();
                String projectCode = tMessageNode.get("custom").get("projectCode").asText();
                String tenantId = tMessageNode.get("tenantId").asText();
                JSONArray taskCodeNode = JSONArray.parseArray((String)TASKENGINE_IGNORE_TASKCODE);
                for (JSONObject obj : taskCodeNode) {
                    if (!this.checkIgnoreTenantId(taskCode, obj.getString("taskCodeName"), tenantId, obj.getString("tenantId"))) continue;
                    this.log.info((Object)"\u547d\u4e2d\u4efb\u52a1\u7f16\u53f7\u5ffd\u7565\u53d1\u9001\u544a\u8b66");
                    return true;
                }
                JSONArray projectCodeNode = JSONArray.parseArray((String)TASKENGINE_IGNORE_PROJECTCODE);
                for (JSONObject obj : projectCodeNode) {
                    if (!this.checkIgnoreTenantId(projectCode, obj.getString("projectCodeName"), tenantId, obj.getString("tenantId"))) continue;
                    this.log.info((Object)"\u547d\u4e2d\u9879\u76ee\u7f16\u53f7\u5ffd\u7565\u53d1\u9001\u544a\u8b66");
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"get isIgnoreSend flag is error", (Throwable)e);
        }
        return false;
    }

    protected boolean checkIgnoreTenantId(String codeName, String comCodeName, String tId, String tenantId) {
        return StringUtil.isNotEmpty(comCodeName) && comCodeName.equals(codeName) && (StringUtil.isEmpty(tenantId) || tId.equals(tenantId));
    }

    protected void saveData(JsonNode pMessageNode) throws Exception {
        String exceptionEntity;
        ErrorMessage errorMessage = new ErrorMessage();
        if (pMessageNode.get("traceId") != null) {
            errorMessage.setTraceId(pMessageNode.get("traceId").asText());
        }
        errorMessage.setAppId(pMessageNode.get("appId").asText());
        if (pMessageNode.get("processSerialNumber") != null) {
            errorMessage.setProcessSerialNumber(pMessageNode.get("processSerialNumber").asText());
        }
        if (pMessageNode.get("processActivityId") != null) {
            errorMessage.setProcessActivityId(pMessageNode.get("processActivityId").asText());
        }
        if (pMessageNode.get("processActivityOID") != null) {
            errorMessage.setProcessActivityOid(pMessageNode.get("processActivityOID").asText());
        }
        try {
            if (pMessageNode.get("apiErrorInfo") != null) {
                String apiName;
                String tMetadata;
                JsonNode tMetadataJsonNode;
                errorMessage.setApiErrorInfo(pMessageNode.get("apiErrorInfo").toString());
                JsonNode jsonNode = this.mapper.readTree(pMessageNode.get("apiErrorInfo").toString());
                if (jsonNode.get("name") != null && (tMetadataJsonNode = this.mapper.readTree(tMetadata = this.getMdcMetadata(apiName = jsonNode.get("name").asText()))).get("execution").get("code") != null && tMetadataJsonNode.get("execution").get("code").asText().matches("000")) {
                    ArrayNode stdDataFieldNode = (ArrayNode)tMetadataJsonNode.get("data").get("data_metadata").get("response_success").get("body").get("field");
                    for (JsonNode node : stdDataFieldNode) {
                        if (!node.get("data_name").asText().equals("parameter")) continue;
                        ArrayNode parameterAryNode = (ArrayNode)node.get("field");
                        for (JsonNode paramNode : parameterAryNode) {
                            if (!paramNode.get("data_name").asText().equals("error_info")) continue;
                            errorMessage.setApiErrorInfoMetadata(paramNode.get("field").toString());
                        }
                    }
                }
            }
        }
        catch (DWHttpFailedException e) {
            exceptionEntity = (String)e.getEntity(String.class);
            this.log.error((Object)("exceptionEntity = " + exceptionEntity), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (pMessageNode.get("token") != null) {
            errorMessage.setToken(pMessageNode.get("token").asText());
        }
        if (pMessageNode.get("retryUrl") != null) {
            errorMessage.setRetryUrl(pMessageNode.get("retryUrl").toString());
        }
        if (pMessageNode.get("actionId") != null) {
            errorMessage.setActionId(pMessageNode.get("actionId").asText());
            if (pMessageNode.get("actionId").asText().length() != 0) {
                try {
                    String token = this.getToken(pMessageNode.get("tenantId").asText());
                    String idempotency = this.getIdempotency(token, pMessageNode.get("actionId").asText());
                    errorMessage.setIdempotency(Boolean.valueOf(idempotency));
                }
                catch (DWHttpFailedException e) {
                    exceptionEntity = (String)e.getEntity(String.class);
                    this.log.error((Object)("exceptionEntity = " + exceptionEntity), (Throwable)e);
                }
            }
        }
        if (pMessageNode.get("taskUid") != null) {
            errorMessage.setTaskUid(pMessageNode.get("taskUid").asText());
        }
        errorMessage.setBuildTime(Calendar.getInstance());
        errorMessage.setLastUpdateTime(Calendar.getInstance());
        errorMessage.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get("createdTime").asText()));
        errorMessage.setTenantId(pMessageNode.get("tenantId").asText());
        errorMessage.setException(pMessageNode.get("exception").asText());
        if (pMessageNode.get("exceptionType") != null) {
            errorMessage.setExceptionType(pMessageNode.get("exceptionType").asText());
        }
        if (pMessageNode.get("errorCode") != null) {
            errorMessage.setErrorCode(pMessageNode.get("errorCode").asText());
        }
        errorMessage.setIsError(pMessageNode.get("isError").asBoolean());
        this.errorMessageDao.save(errorMessage);
        try {
            if (!StringUtil.isEmptyOrSpace(pMessageNode.get("appId")) && (pMessageNode.get("appId").asText().equals(AppTypeEnum.BPMCLOUD.getType()) || pMessageNode.get("appId").asText().equals(AppTypeEnum.TASKENGINE.getType()) || pMessageNode.get("appId").asText().equals(AppTypeEnum.ATMC.getType())) && this.isErrorNotify(pMessageNode) && !this.isIgnoreSend(pMessageNode)) {
                this.sendErrorNotificationEmail(pMessageNode);
            }
        }
        catch (DWHttpFailedException e) {
            exceptionEntity = (String)e.getEntity(String.class);
            this.log.error((Object)("exceptionEntity = " + exceptionEntity), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void updateErrorStatus(JsonNode pMessageNode) {
        List<ErrorMessage> tErrorMessageList = this.errorMessageDao.getByBusinessLogicKey(pMessageNode);
        if (tErrorMessageList.size() != 0 && tErrorMessageList.get(0).isError()) {
            Iterator<ErrorMessage> iterator = tErrorMessageList.iterator();
            while (iterator.hasNext()) {
                ErrorMessage message;
                ErrorMessage tTargetError = message = iterator.next();
                tTargetError.setIsError(false);
                tTargetError.setLastUpdateTime(Calendar.getInstance());
                this.errorMessageDao.saveOrupdate(tTargetError);
            }
        }
    }

    private void sendErrorNotificationEmail(JsonNode pMessageNode) throws Exception {
        List<ErrorNotificationUser> notificationUsers = this.errorNotificationUserDao.getErrorNotificationUsersBytenantId(pMessageNode.get("tenantId").asText());
        if (notificationUsers.size() != 0) {
            String token = this.getToken(pMessageNode.get("tenantId").asText());
            ArrayList<String> userIdList = new ArrayList<String>();
            for (ErrorNotificationUser user : notificationUsers) {
                userIdList.add(user.getUserId());
            }
            Map<String, String> pUserIdEmailAddressMap = this.getUserIdEmailAddressMap(token, userIdList);
            ArrayNode emailArrayNode = this.mapper.createArrayNode();
            HashMap<String, String> emailToUserId = new HashMap<String, String>();
            for (String userId : pUserIdEmailAddressMap.keySet()) {
                String emailAddress = pUserIdEmailAddressMap.get(userId);
                emailArrayNode.add(emailAddress);
                emailToUserId.put(emailAddress, userId);
            }
            if (emailArrayNode.size() != 0) {
                for (JsonNode tEmailAddress : emailArrayNode) {
                    ArrayNode sendOneEmailAtATime = this.mapper.createArrayNode();
                    sendOneEmailAtATime.add(tEmailAddress);
                    String tEmcUrl = DWApplicationConfigUtils.getProperty((String)"emc.url");
                    URI tEmcTargetUri = DWURIBuilder.create((String)(tEmcUrl + this.EMC_SEND_MAIL_PATH)).build();
                    HttpPost tPost = new HttpPost(tEmcTargetUri);
                    String tenantName = this.getTenantName(pMessageNode.get("tenantId").asText());
                    String userLang = this.getUserLangMetadataAllTenant(token, (String)emailToUserId.get(tEmailAddress.asText()));
                    StringBuilder stringBuilder1 = new StringBuilder();
                    this.log.info((Object)("\u6d4b\u8bd5\u591a\u8bed\u8a00\uff0cuserLang:{}=" + userLang));
                    this.log.info((Object)("\u6d4b\u8bd5\u591a\u8bed\u8a00\uff0cerror.email.message1:{}=" + ResourceBundleUtil.getString("error.email.message1", userLang)));
                    this.log.info((Object)("\u6d4b\u8bd5\u591a\u8bed\u8a00\uff0cerror.email.message3:{}=" + ResourceBundleUtil.getString("error.email.message3", userLang)));
                    stringBuilder1.append(ResourceBundleUtil.getString("error.email.message1", userLang) + pMessageNode.get("tenantId").asText() + "-" + tenantName + ResourceBundleUtil.getString("error.email.message2", userLang) + pMessageNode.get("createdTime").asText() + ResourceBundleUtil.getString("error.email.message3", userLang));
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append(ResourceBundleUtil.getString("error.email.message4", userLang) + this.getErrorDescription(pMessageNode, userLang));
                    ObjectNode objectNode = this.mapper.createObjectNode();
                    objectNode.put("content", stringBuilder1.toString() + "\r\r\n" + stringBuilder2.toString());
                    objectNode.put("msgType", "text");
                    objectNode.put("title", ResourceBundleUtil.getString("error.email.message5", userLang));
                    objectNode.set("userIds", (JsonNode)sendOneEmailAtATime);
                    StringEntity entity = new StringEntity(objectNode.toString(), "UTF-8");
                    entity.setContentEncoding("UTF-8");
                    tPost.setEntity((HttpEntity)entity);
                    tPost.addHeader("Content-Type", "application/json;charset=UTF-8");
                    tPost.setHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
                    String result = (String)this.dwHttpClient.execute((HttpUriRequest)tPost, String.class, new DWRequestOption(false));
                    this.log.info((Object)("\u7570\u5e38\u901a\u77e5\u90f5\u4ef6\uff0c\u767c\u9001\u4fe1\u7bb1 = " + sendOneEmailAtATime.toString()));
                    this.log.info((Object)("\u7570\u5e38\u901a\u77e5\u90f5\u4ef6\uff0c\u7d50\u679c = " + result));
                }
            } else {
                this.log.info((Object)"\u7570\u5e38\u901a\u77e5\u90f5\u4ef6\uff0c\u672a\u627e\u5230\u901a\u77e5\u4eba\u4fe1\u7bb1\u8cc7\u8a0a");
            }
        } else {
            this.log.info((Object)"\u7570\u5e38\u901a\u77e5\u90f5\u4ef6\uff0c\u6c92\u6709\u901a\u77e5\u4eba\u6545\u4e0d\u767c\u9001");
        }
    }

    private Map<String, String> getUserInRole(String pToken) throws Exception {
        String tIamUrl = DWApplicationConfigUtils.getProperty((String)"iam.url");
        HashMap<String, String> tReturnedMap = new HashMap<String, String>();
        URI tIamTargetUri = DWURIBuilder.create((String)(tIamUrl + this.IAM_USERINROLE_PATH)).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        HashMap<String, String> tGetIamRequest = new HashMap<String, String>();
        tGetIamRequest.put("roleId", "superadmin");
        tPost.setHeader("digi-middleware-auth-user", pToken);
        tPost.setEntity((HttpEntity)new DWJsonEntity(tGetIamRequest));
        List tGetIamResponse = (List)this.dwHttpClient.execute((HttpUriRequest)tPost, ArrayList.class, new DWRequestOption(false));
        for (Map map : tGetIamResponse) {
            if (map.get("email") == null) continue;
            tReturnedMap.put((String)map.get("id"), (String)map.get("email"));
        }
        this.log.info((Object)("\u7570\u5e38\u901a\u77e5\u90f5\u4ef6 \u53d6\u5f97\u89d2\u8272\u4e0b\u7684\u6240\u6709\u7528\u6237\u6e05\u5355 = " + ((Object)tReturnedMap).toString()));
        return tReturnedMap;
    }

    private Map<String, String> getUserIdEmailAddressMap(String pToken, List<String> pUserIdList) throws Exception {
        String tIamUrl = DWApplicationConfigUtils.getProperty((String)"iam.url");
        HashMap<String, String> tUserIdEmailAddressMapping = new HashMap<String, String>();
        URI tIamTargetUri = DWURIBuilder.create((String)(tIamUrl + this.IAM_USERINFO_PATH)).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        HashMap<String, List<String>> userIdMap = new HashMap<String, List<String>>();
        userIdMap.put("userIds", pUserIdList);
        tPost.setHeader("digi-middleware-auth-user", pToken);
        tPost.setHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        tPost.setEntity((HttpEntity)new DWJsonEntity(userIdMap));
        Map tGetIamResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tPost, HashMap.class, new DWRequestOption(false));
        List iamReturnedUserInfo = (List)tGetIamResponse.get("data");
        for (String userId : pUserIdList) {
            for (Map userInfoMap : iamReturnedUserInfo) {
                if (!userId.equals(userInfoMap.get("userId"))) continue;
                tUserIdEmailAddressMapping.put(userId, (String)userInfoMap.get("email"));
            }
        }
        this.log.info((Object)("\u7570\u5e38\u901a\u77e5\u90f5\u4ef6\uff0c\u53d6\u5f97\u901a\u77e5\u4eba\u7684\u4fe1\u7bb1 = " + ((Object)tUserIdEmailAddressMapping).toString()));
        return tUserIdEmailAddressMapping;
    }

    private String getToken(String pTenant) throws Exception {
        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty((String)"knowledgemaps.url");
        URI tKnowledgemapsTargetUri = DWURIBuilder.create((String)(tKnowledgemapsUrl + this.GET_LICENSEKEY_BY_TENANTID_PATH + "?tenantId=" + pTenant)).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        Map tGetLicenseKeyResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, Map.class);
        String tSecretKey = ErrorMessageConsumeProcessor.decodeAES((String)tGetLicenseKeyResponse.get("response"));
        String tIamUrl = DWApplicationConfigUtils.getProperty((String)"iam.url");
        URI tIamTargetUri = DWURIBuilder.create((String)(tIamUrl + this.IAM_IDENTITY_LOGIN_PATH)).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        HashMap<String, String> tGetIamRequest = new HashMap<String, String>();
        tGetIamRequest.put("secretKey", tSecretKey);
        tGetIamRequest.put("identityType", "secretKey");
        tPost.setHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        tPost.setEntity((HttpEntity)new DWJsonEntity(tGetIamRequest));
        Map tGetIamResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tPost, Map.class, new DWRequestOption(false));
        this.log.info((Object)("\u53d6\u5f97\u79df\u6236" + pTenant + " token = " + (String)tGetIamResponse.get("token")));
        return (String)tGetIamResponse.get("token");
    }

    private String getTenantName(String pTenant) throws Exception {
        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty((String)"knowledgemaps.url");
        URI tKnowledgemapsTargetUri = DWURIBuilder.create((String)(tKnowledgemapsUrl + this.GET_LICENSEKEY_BY_TENANTID_PATH + "?tenantId=" + pTenant)).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        Map tGetLicenseKeyResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, Map.class);
        String tSecretKey = ErrorMessageConsumeProcessor.decodeAES((String)tGetLicenseKeyResponse.get("response"));
        String tIamUrl = DWApplicationConfigUtils.getProperty((String)"iam.url");
        URI tIamTargetUri = DWURIBuilder.create((String)(tIamUrl + this.IAM_IDENTITY_LOGIN_PATH)).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        HashMap<String, String> tGetIamRequest = new HashMap<String, String>();
        tGetIamRequest.put("secretKey", tSecretKey);
        tGetIamRequest.put("identityType", "secretKey");
        tPost.setEntity((HttpEntity)new DWJsonEntity(tGetIamRequest));
        tPost.setHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        Map tGetIamResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tPost, Map.class, new DWRequestOption(false));
        this.log.info((Object)("\u53d6\u5f97\u79df\u6236\u540d\u7a31(tenantName)" + pTenant + " tenantName = " + (String)tGetIamResponse.get("tenantName")));
        return (String)tGetIamResponse.get("tenantName");
    }

    private String getMdcMetadata(String pApiName) throws Exception {
        String tMdcUrl = DWApplicationConfigUtils.getProperty((String)"mdc.url");
        URI tTargetUri = DWURIBuilder.create((String)(tMdcUrl + this.GET_MDC_METADATA_PATH)).build();
        HttpPost tPost = new HttpPost(tTargetUri);
        tPost.setHeader("Content-Type", "application/json");
        HashMap<String, String> tGetIamRequest = new HashMap<String, String>();
        tGetIamRequest.put("api_name", pApiName);
        tPost.setEntity((HttpEntity)new DWJsonEntity(tGetIamRequest));
        String tMdcResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tPost, String.class);
        this.log.info((Object)("\u53d6\u5f97" + pApiName + "\u5143\u6578\u64da\uff1a" + tMdcResponse));
        return tMdcResponse;
    }

    private String getIdempotency(String pToken, String pActionId) throws Exception {
        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty((String)"knowledgemaps.url");
        URI tKnowledgemapsTargetUri = DWURIBuilder.create((String)(tKnowledgemapsUrl + this.GET_METADATA_PATH + "?actionId=esp_" + pActionId)).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        tHttpGet.setHeader("token", pToken);
        Map tGetMetaDataResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, Map.class);
        Map responseData = (Map)tGetMetaDataResponse.get("response");
        this.log.info((Object)("\u53d6\u5f97\u51aa\u7b49\u6027\uff0cactionId = " + pActionId + " idempotency = " + (String)responseData.get("idempotency")));
        return (String)responseData.get("idempotency");
    }

    private static String decodeAES(String secretFile) throws Exception {
        byte[] result = new byte[]{};
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        SecretKeySpec key1 = new SecretKeySpec(Hex.decodeHex((String)secretKey), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, key1);
        result = cipher.doFinal(Hex.decodeHex((String)secretFile));
        return new String(result);
    }

    private String getErrorDescription(JsonNode pMessageNode, String pLocale) {
        String description = "";
        if (pMessageNode.get("errorCode") != null) {
            List<ErrorSummary> errorSummaries = this.errorSummaryDao.getErrorSummaryByCode(pMessageNode.get("errorCode").asText());
            if (errorSummaries != null && errorSummaries.size() != 0) {
                ErrorSummary tErrorSummary = errorSummaries.get(0);
                switch (pLocale) {
                    case "zh_TW": {
                        description = tErrorSummary.getCauseZhTw();
                        break;
                    }
                    case "zh_CN": {
                        description = tErrorSummary.getCauseZhCn();
                        break;
                    }
                    case "en_US": {
                        description = tErrorSummary.getCauseEnUs();
                        break;
                    }
                    default: {
                        description = tErrorSummary.getCauseZhCn();
                        break;
                    }
                }
            } else {
                errorSummaries = this.errorSummaryDao.getErrorSummaryByCode(UNDEFINED_ERROR_CODE);
                ErrorSummary tErrorSummary = errorSummaries.get(0);
                switch (pLocale) {
                    case "zh_TW": {
                        description = tErrorSummary.getCauseZhTw();
                        break;
                    }
                    case "zh_CN": {
                        description = tErrorSummary.getCauseZhCn();
                        break;
                    }
                    case "en_US": {
                        description = tErrorSummary.getCauseEnUs();
                        break;
                    }
                    default: {
                        description = tErrorSummary.getCauseZhCn();
                    }
                }
            }
        } else {
            description = pMessageNode.get("exception").asText();
        }
        return description;
    }

    private boolean isErrorNotify(JsonNode pMessageNode) {
        ErrorSummary tErrorSummary;
        List<ErrorSummary> errorSummaries;
        boolean flag = false;
        if (pMessageNode.get("errorCode") != null && (errorSummaries = this.errorSummaryDao.getErrorSummaryByCode(pMessageNode.get("errorCode").asText())) != null && errorSummaries.size() != 0 && !(tErrorSummary = errorSummaries.get(0)).isShutNotification()) {
            flag = true;
        }
        return flag;
    }

    private String getUserLangMetadataAllTenant(String pToken, String userId) throws Exception {
        String tIamUrl = DWApplicationConfigUtils.getProperty((String)"iam.url");
        HashMap tUserIdEmailAddressMapping = new HashMap();
        URI tIamTargetUri = DWURIBuilder.create((String)(tIamUrl + this.USERMETADATA_USER_GET)).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("catalogId", "basic");
        params.put("key", "dapAcceptLanguage");
        params.put("userId", userId);
        params.put("tenantSid", 0);
        tPost.setHeader("digi-middleware-auth-user", pToken);
        tPost.setHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        tPost.setEntity((HttpEntity)new DWJsonEntity(params));
        Map tGetIamResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tPost, HashMap.class, new DWRequestOption(false));
        Map iamReturnedUserInfo = (Map)tGetIamResponse.get("data");
        String lang = "zh_CN";
        if (MapUtils.isNotEmpty((Map)iamReturnedUserInfo) && StringUtil.isNotEmpty(iamReturnedUserInfo.get("value"))) {
            lang = (String)iamReturnedUserInfo.get("value");
        }
        return lang;
    }
}

