/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.ErrorNotificationUserDao;
import com.digiwin.athena.itsys.dao.NotificationUserChangeLogDao;
import com.digiwin.athena.itsys.enums.ErrorNotificationEnum;
import com.digiwin.athena.itsys.model.ErrorNotificationUser;
import com.digiwin.athena.itsys.model.NotificationUserChangeLog;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErrorNotificationProcessor {
    @Autowired
    ErrorNotificationUserDao errorNotificationUserDao;
    @Autowired
    NotificationUserChangeLogDao notificationUserChangeLogDao;
    ObjectMapper mapper = new ObjectMapper();
    protected final Log log = LogFactory.getLog(this.getClass());

    public Map<String, Object> setUserSend(String tenantId, String userSend, String toggle) throws JsonParseException, JsonMappingException, IOException {
        NotificationUserChangeLog notificationUserChangeLog = new NotificationUserChangeLog();
        ArrayNode userSendArrayNode = this.mapper.createArrayNode();
        userSendArrayNode = (ArrayNode)this.mapper.readTree(userSend);
        ArrayList<String> userList = new ArrayList<String>();
        for (JsonNode userIdNode : userSendArrayNode) {
            userList.add(userIdNode.asText().trim());
        }
        if (toggle.equals(ErrorNotificationEnum.ON.getCode())) {
            for (String userId : userList) {
                if (!this.errorNotificationUserDao.getErrorNotificationUserByUserandTenantId(userId, tenantId).isEmpty()) continue;
                ErrorNotificationUser user = new ErrorNotificationUser();
                user.setUserId(userId);
                user.setTenantId(tenantId);
                user.setBuildTime(Calendar.getInstance());
                this.errorNotificationUserDao.save(user);
                notificationUserChangeLog.setTenantId(tenantId);
                notificationUserChangeLog.setUserId(userId);
                notificationUserChangeLog.setBuildTime(Calendar.getInstance());
                notificationUserChangeLog.setOperation(ErrorNotificationEnum.ON.getCode());
                this.notificationUserChangeLogDao.save(notificationUserChangeLog);
            }
        } else if (toggle.equals(ErrorNotificationEnum.OFF.getCode())) {
            for (String userId : userList) {
                List<ErrorNotificationUser> notificationUsers = this.errorNotificationUserDao.getErrorNotificationUserByUserandTenantId(userId, tenantId);
                if (notificationUsers.isEmpty()) continue;
                this.errorNotificationUserDao.remove(notificationUsers.get(0).getId());
                notificationUserChangeLog.setTenantId(tenantId);
                notificationUserChangeLog.setUserId(userId);
                notificationUserChangeLog.setBuildTime(Calendar.getInstance());
                notificationUserChangeLog.setOperation(ErrorNotificationEnum.OFF.getCode());
                this.notificationUserChangeLogDao.save(notificationUserChangeLog);
            }
        }
        HashMap<String, Object> tReturn = new HashMap<String, Object>();
        tReturn.put("result", "success");
        return tReturn;
    }

    public Map<String, Object> checkUserSendInfo(String tenantId, String userId) throws JsonParseException, JsonMappingException, IOException {
        ObjectNode outerNode = this.mapper.createObjectNode();
        List<ErrorNotificationUser> users = this.errorNotificationUserDao.getErrorNotificationUserByUserandTenantId(userId, tenantId);
        if (users.isEmpty()) {
            outerNode.put(ErrorNotificationEnum.TOGGLE.getCode(), ErrorNotificationEnum.OFF.getCode());
        } else {
            outerNode.put(ErrorNotificationEnum.TOGGLE.getCode(), ErrorNotificationEnum.ON.getCode());
        }
        HashMap<String, Object> tReturn = new HashMap<String, Object>();
        tReturn.put("result", outerNode.toString());
        return tReturn;
    }
}

