/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.itsys.dao.ActivityLogDao;
import com.digiwin.athena.itsys.dao.ErrorMessageDao;
import com.digiwin.athena.itsys.dao.ErrorSummaryDao;
import com.digiwin.athena.itsys.dao.MonitorLogDao;
import com.digiwin.athena.itsys.dao.ProcessLogDao;
import com.digiwin.athena.itsys.dao.ProjectLogDao;
import com.digiwin.athena.itsys.dao.TaskLogDao;
import com.digiwin.athena.itsys.enums.ActivityLogConditionEnum;
import com.digiwin.athena.itsys.enums.ExecutionViewSearchEnum;
import com.digiwin.athena.itsys.enums.LocaleEnum;
import com.digiwin.athena.itsys.enums.LogAttributeEnum;
import com.digiwin.athena.itsys.enums.MappingTypeEnum;
import com.digiwin.athena.itsys.enums.ProjectLogConditionEnum;
import com.digiwin.athena.itsys.enums.TaskLogConditionEnum;
import com.digiwin.athena.itsys.model.ActivityLog;
import com.digiwin.athena.itsys.model.ErrorMessage;
import com.digiwin.athena.itsys.model.ErrorSummary;
import com.digiwin.athena.itsys.model.MonitorLog;
import com.digiwin.athena.itsys.model.ProjectLog;
import com.digiwin.athena.itsys.model.TaskLog;
import com.digiwin.athena.itsys.service.JsonManipulateService;
import com.digiwin.athena.itsys.service.LogManipulateService;
import com.digiwin.athena.itsys.util.StringUtil;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutionViewProcessor {
    @Autowired
    private ErrorMessageDao errorMessageDao;
    @Autowired
    private ProcessLogDao processLogDao;
    @Autowired
    private ProjectLogDao projectLogDao;
    @Autowired
    private ActivityLogDao activityLogDao;
    @Autowired
    private TaskLogDao taskLogDao;
    @Autowired
    private MonitorLogDao monitorLogDao;
    @Autowired
    private ErrorSummaryDao errorSummaryDao;
    @Autowired
    private LogManipulateService logManipulateService;
    @Autowired
    private JsonManipulateService jsonManipulateService;
    protected final Log log = LogFactory.getLog(this.getClass());
    ObjectMapper mapper = new ObjectMapper();
    private SimpleDateFormat formatToSecond = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd");
    private static String UNDEFINED_ERROR_CODE = "P.Itsys.500.9999";
    private static String TASKENGINE_URL = DWApplicationConfigUtils.getProperty((String)"taskengine.url");
    private static String RETRY_ERROR_CODE = DWApplicationConfigUtils.getProperty((String)"retry.error.code");

    public Map<String, Object> execute(String tenantId, String sourceId, String queryStartDate, String queryEndDate, String condition, String ruleCode, String createdTime, String processSerialNumber) throws JsonParseException, JsonMappingException, IOException, ParseException, DWHttpFailedException, URISyntaxException {
        HashMap outerNode = new HashMap();
        List<Map<String, Object>> sourceIdInfoArynode = new ArrayList<Map<String, Object>>();
        if (StringUtil.isEmptyOrSpace(sourceId = sourceId.trim()) && StringUtil.isEmptyOrSpace(ruleCode) && StringUtil.isEmptyOrSpace(processSerialNumber)) {
            return this.fullSearch(tenantId, queryStartDate, queryEndDate, condition);
        }
        sourceIdInfoArynode = this.sourceNoSearch(sourceIdInfoArynode, tenantId, queryStartDate, queryEndDate, condition, sourceId, ruleCode, createdTime, processSerialNumber);
        HashMap<String, Object> tReturn = new HashMap<String, Object>();
        tReturn.put("list", sourceIdInfoArynode);
        return tReturn;
    }

    private Map<String, Object> fullSearch(String pTenantId, String pQueryStartDate, String pQueryEndDate, String pCondition) throws ParseException, DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException {
        HashMap outerNode = new HashMap();
        List<Map<String, Object>> sourceIdInfoArynode = new ArrayList<Map<String, Object>>();
        if (StringUtil.isEmptyOrSpace(pCondition)) {
            pCondition = ExecutionViewSearchEnum.STUCK.getType();
        }
        if (pCondition.equals(ExecutionViewSearchEnum.STUCK.getType())) {
            sourceIdInfoArynode = this.generateStuckResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate, pCondition);
        } else if (pCondition.equals(ExecutionViewSearchEnum.SUCCESS.getType())) {
            sourceIdInfoArynode = this.generateStuckResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate, pCondition);
            sourceIdInfoArynode = this.generateSuccessResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate, pCondition);
        } else if (pCondition.equals(ExecutionViewSearchEnum.TOTAL.getType())) {
            sourceIdInfoArynode = this.generateStuckResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate, pCondition);
            sourceIdInfoArynode = this.generateSuccessResult(sourceIdInfoArynode, pTenantId, pQueryStartDate, pQueryEndDate, pCondition);
        }
        sourceIdInfoArynode = this.jsonManipulateService.sortJsonArrayByAttribute(sourceIdInfoArynode, LogAttributeEnum.CREATED_TIME.getAttribute(), true);
        HashMap<String, Object> tReturn = new HashMap<String, Object>();
        tReturn.put("list", sourceIdInfoArynode);
        return tReturn;
    }

    private void setExceptionContentAndSolution(Map<String, Object> pTargetNode, ErrorMessage pErrorMessage, String pLocale) {
        ErrorSummary tErrorSummary;
        List<ErrorSummary> errorSummaries = this.errorSummaryDao.getErrorSummaryByCode(pErrorMessage.getErrorCode());
        if (errorSummaries != null && errorSummaries.size() != 0) {
            tErrorSummary = errorSummaries.get(0);
            switch (pLocale) {
                case "zh_TW": {
                    pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhTw());
                    break;
                }
                case "zh_CN": {
                    pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
                    break;
                }
                case "en_US": {
                    pTargetNode.put("exceptionSummary", tErrorSummary.getCauseEnUs());
                    break;
                }
                default: {
                    pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
                    break;
                }
            }
        } else {
            errorSummaries = this.errorSummaryDao.getErrorSummaryByCode(UNDEFINED_ERROR_CODE);
            tErrorSummary = errorSummaries.get(0);
            switch (pLocale) {
                case "zh_TW": {
                    pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhTw());
                    break;
                }
                case "zh_CN": {
                    pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
                    break;
                }
                case "en_US": {
                    pTargetNode.put("exceptionSummary", tErrorSummary.getCauseEnUs());
                    break;
                }
                default: {
                    pTargetNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
                }
            }
        }
        if (pErrorMessage.getApiErrorInfo() != null) {
            pTargetNode.put("hasErrorInfo", Boolean.TRUE);
            pTargetNode.put("apiErrorInfo", pErrorMessage.getApiErrorInfo());
            pTargetNode.put("apiErrorInfoMetadata", pErrorMessage.getApiErrorInfoMetadata());
            pTargetNode.put("healthState", "normal");
        } else {
            JsonNode jsonNode;
            pTargetNode.put("hasErrorInfo", Boolean.FALSE);
            if (StringUtil.isEmptyOrSpace(pErrorMessage.getRetryUrl())) {
                pTargetNode.put("solution", ExecutionViewSearchEnum.CONTACT_CUSTOMER_SERVICE.getType());
            } else if (!StringUtil.isEmptyOrSpace(pErrorMessage.getActionId())) {
                if (pErrorMessage.isIdempotency()) {
                    pTargetNode.put("solution", ExecutionViewSearchEnum.REEXECUTE.getType());
                    try {
                        jsonNode = this.mapper.readTree(pErrorMessage.getRetryUrl());
                        pTargetNode.put("reExecuteUrl", TASKENGINE_URL + jsonNode.get("url").asText());
                        pTargetNode.put("requestBody", jsonNode.get("requestBody").toString());
                        pTargetNode.put("requestToken", pErrorMessage.getToken());
                    }
                    catch (Exception e) {
                        this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    pTargetNode.put("solution", ExecutionViewSearchEnum.CONTACT_CUSTOMER_SERVICE.getType());
                }
            } else {
                try {
                    if (RETRY_ERROR_CODE.contains(tErrorSummary.getCode())) {
                        jsonNode = this.mapper.readTree(pErrorMessage.getRetryUrl());
                        if (jsonNode.get("url").asText().equals("/v1/projects/re-invoke-project")) {
                            pTargetNode.put("solution", ExecutionViewSearchEnum.RE_PUBLISH_PROJECT.getType());
                        } else if (jsonNode.get("url").asText().equals("/v1/tasks/activity/restart")) {
                            pTargetNode.put("solution", ExecutionViewSearchEnum.RESTART.getType());
                        } else {
                            pTargetNode.put("solution", ExecutionViewSearchEnum.CONTACT_CUSTOMER_SERVICE.getType());
                        }
                        pTargetNode.put("reExecuteUrl", TASKENGINE_URL + "/restful/standard/taskengine" + jsonNode.get("url").asText());
                        pTargetNode.put("requestBody", jsonNode.get("requestBody").toString());
                        pTargetNode.put("requestToken", pErrorMessage.getToken());
                    } else {
                        pTargetNode.put("solution", ExecutionViewSearchEnum.CONTACT_CUSTOMER_SERVICE.getType());
                    }
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            pTargetNode.put("processSerialNumber", pErrorMessage.getProcessSerialNumber());
            pTargetNode.put("processActivityId", pErrorMessage.getProcessActivityId());
            pTargetNode.put("processActivityOid", pErrorMessage.getProcessActivityOid());
        }
    }

    private void setAppNameByLocale(Map<String, Object> pTargetNode, Object pLog, String pLocale) {
        if (pLog == null) {
            pTargetNode.put("appName", "");
        } else if (pLog instanceof MonitorLog) {
            switch (pLocale) {
                case "zh_TW": {
                    pTargetNode.put("appName", ((MonitorLog)pLog).getAppNameZhTw());
                    break;
                }
                case "zh_CN": {
                    pTargetNode.put("appName", ((MonitorLog)pLog).getAppNameZhCn());
                    break;
                }
                case "en_US": {
                    pTargetNode.put("appName", ((MonitorLog)pLog).getAppNameEnUs());
                    break;
                }
                default: {
                    pTargetNode.put("appName", ((MonitorLog)pLog).getAppNameZhCn());
                    break;
                }
            }
        } else if (pLog instanceof ProjectLog) {
            switch (pLocale) {
                case "zh_TW": {
                    pTargetNode.put("appName", ((ProjectLog)pLog).getAppNameZhTw());
                    break;
                }
                case "zh_CN": {
                    pTargetNode.put("appName", ((ProjectLog)pLog).getAppNameZhCn());
                    break;
                }
                case "en_US": {
                    pTargetNode.put("appName", ((ProjectLog)pLog).getAppNameEnUs());
                    break;
                }
                default: {
                    pTargetNode.put("appName", ((ProjectLog)pLog).getAppNameZhCn());
                }
            }
        }
    }

    private void setProjectNameByLocale(Map<String, Object> pTargetNode, ProjectLog pProjectLog, String pLocale) {
        if (pProjectLog == null) {
            pTargetNode.put("projectName", "");
        } else {
            switch (pLocale) {
                case "zh_TW": {
                    pTargetNode.put("projectName", pProjectLog.getProjectNameZhTw());
                    break;
                }
                case "zh_CN": {
                    pTargetNode.put("projectName", pProjectLog.getProjectNameZhCn());
                    break;
                }
                case "en_US": {
                    pTargetNode.put("projectName", pProjectLog.getProjectNameEnUs());
                    break;
                }
                default: {
                    pTargetNode.put("projectName", pProjectLog.getProjectNameZhCn());
                }
            }
        }
    }

    private void setTaskNameByLocale(Map<String, Object> pTargetNode, TaskLog pTaskLog, String pLocale) {
        if (pTaskLog == null) {
            pTargetNode.put("taskName", "");
        } else {
            switch (pLocale) {
                case "zh_TW": {
                    pTargetNode.put("taskName", pTaskLog.getTaskNameZhTw());
                    break;
                }
                case "zh_CN": {
                    pTargetNode.put("taskName", pTaskLog.getTaskNameZhCn());
                    break;
                }
                case "en_US": {
                    pTargetNode.put("taskName", pTaskLog.getTaskNameEnUs());
                    break;
                }
                default: {
                    pTargetNode.put("taskName", pTaskLog.getTaskNameZhCn());
                }
            }
        }
    }

    private List<Map<String, Object>> generateStuckResult(List<Map<String, Object>> pSourceIdInfoArynode, String pTenantId, String pQueryStartDate, String pQueryEndDate, String pCondition) throws ParseException {
        ErrorMessage errorMessage;
        Iterator<Object> tRemoveApiErrorMessages;
        String tLocale = (String)DWServiceContext.getContext().getRequestHeader().get(LocaleEnum.LOCALE.getType());
        if (StringUtil.isEmptyOrSpace(tLocale)) {
            tLocale = "";
        }
        this.log.info((Object)("\u57f7\u884c\u8996\u89d2\u524d\u7aef\u67e5\u8a62\u8a9e\u7cfb\uff1a" + tLocale));
        ArrayList<String> serialNumbers = new ArrayList<String>();
        ArrayList<String> traceIds = new ArrayList<String>();
        Map<Object, Object> errorMessageMapByTraceId = new HashMap();
        Map<Object, Object> errorMessageMapBySerialNumber = new HashMap();
        HashMap<String, List<ProjectLog>> projectLogMapBySerialNumber = new HashMap();
        HashMap<String, List<MonitorLog>> monitorLogMapByTraceId = new HashMap();
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        if (!StringUtil.isEmptyOrSpace(pTenantId)) {
            conditionMap.put("tenant_id", pTenantId);
            conditionMap.put(ProjectLogConditionEnum.TENANT_ID.toString(), pTenantId);
        }
        if (!StringUtil.isEmptyOrSpace(pQueryStartDate) && !StringUtil.isEmptyOrSpace(pQueryEndDate)) {
            conditionMap.put("query_start_date", pQueryStartDate);
            conditionMap.put("query_end_date", pQueryEndDate);
        }
        conditionMap.put("condition", "stuck");
        conditionMap.put("is_error", String.valueOf(Boolean.TRUE));
        Object errorMessages = this.errorMessageDao.fetch(conditionMap);
        if (errorMessages != null && pCondition.equals(ExecutionViewSearchEnum.STUCK.getType())) {
            tRemoveApiErrorMessages = new ArrayList();
            Iterator<ErrorMessage> iterator = errorMessages.iterator();
            while (iterator.hasNext()) {
                errorMessage = iterator.next();
                if ("P.ATDM.560.0001".equals(errorMessage.getErrorCode())) continue;
                tRemoveApiErrorMessages.add(errorMessage);
            }
            errorMessages = tRemoveApiErrorMessages;
        } else if (errorMessages != null && pCondition.equals(ExecutionViewSearchEnum.SUCCESS.getType())) {
            tRemoveApiErrorMessages = new ArrayList();
            Iterator<ErrorMessage> iterator = errorMessages.iterator();
            while (iterator.hasNext()) {
                errorMessage = iterator.next();
                if (!"P.ATDM.560.0001".equals(errorMessage.getErrorCode())) continue;
                tRemoveApiErrorMessages.add(errorMessage);
            }
            errorMessages = tRemoveApiErrorMessages;
        }
        errorMessageMapBySerialNumber = this.logManipulateService.mapErrorMessageByType((List<ErrorMessage>)errorMessages, MappingTypeEnum.SERIAL_NUMBER.getType());
        for (String string : errorMessageMapBySerialNumber.keySet()) {
            serialNumbers.add(string);
        }
        List<ProjectLog> projectLogs = this.projectLogDao.getProjectLogsBySerialNumbers(serialNumbers, pTenantId);
        projectLogMapBySerialNumber = this.logManipulateService.mapProjectLogByType(projectLogs, MappingTypeEnum.SERIAL_NUMBER.getType());
        this.logManipulateService.sortLatestProjectLog(projectLogMapBySerialNumber);
        errorMessageMapByTraceId = this.logManipulateService.mapErrorMessageByType((List<ErrorMessage>)errorMessages, MappingTypeEnum.TRACE_ID.getType());
        for (String string : errorMessageMapByTraceId.keySet()) {
            traceIds.add(string);
        }
        List<MonitorLog> monitorLogs = this.monitorLogDao.getMonitorLogsByTraceIds(traceIds, pTenantId);
        monitorLogMapByTraceId = this.logManipulateService.mapMonitorLogByType(monitorLogs, MappingTypeEnum.TRACE_ID.getType());
        this.logManipulateService.sortLatestMonitorLog(monitorLogMapByTraceId);
        List<TaskLog> tAllTaskLogs = this.taskLogDao.getTaskLogsBySerialNumbers(serialNumbers);
        List<ActivityLog> list = this.activityLogDao.getActivityLogsBySerialNumbers(serialNumbers);
        for (String string : errorMessageMapBySerialNumber.keySet()) {
            boolean monitorLogExist = false;
            for (String traceId : monitorLogMapByTraceId.keySet()) {
                MonitorLog monitorLog = (MonitorLog)((List)monitorLogMapByTraceId.get(traceId)).get(0);
                if (!monitorLog.getTraceId().equals(((ErrorMessage)((List)errorMessageMapBySerialNumber.get(string)).get(0)).getTraceId())) continue;
                monitorLogExist = true;
                if (!(projectLogMapBySerialNumber.get(string) == null || ((List)projectLogMapBySerialNumber.get(string)).isEmpty() || ((ProjectLog)((List)projectLogMapBySerialNumber.get(string)).get(0)).getState() != 1 && ((ProjectLog)((List)projectLogMapBySerialNumber.get(string)).get(0)).getState() != 2)) {
                    for (ErrorMessage errorMessage2 : (List)errorMessageMapBySerialNumber.get(string)) {
                        ProjectLog projectLog = (ProjectLog)((List)projectLogMapBySerialNumber.get(string)).get(0);
                        HashMap<String, Object> projectLogNode = new HashMap<String, Object>();
                        projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(projectLog.getCreatedTime().getTime()));
                        projectLogNode.put("healthState", "abnormal");
                        this.setAppNameByLocale(projectLogNode, monitorLog, tLocale);
                        this.setProjectNameByLocale(projectLogNode, projectLog, tLocale);
                        projectLogNode.put("projectId", projectLog.getProjectId());
                        projectLogNode.put("projectCardId", projectLog.getProjectCardId());
                        projectLogNode.put("activityType", "auto");
                        if (projectLog.getState() == 1 || projectLog.getState() == 2) {
                            projectLogNode.put("taskState", "continued");
                        } else if (projectLog.getState() == 3) {
                            projectLogNode.put("taskState", "finished");
                        }
                        projectLogNode.put("source_no", projectLog.getSourceIds());
                        projectLogNode.put("traceId", monitorLog.getTraceId());
                        projectLogNode.put("appCode", monitorLog.getAppCode());
                        projectLogNode.put("ruleCode", monitorLog.getRuleCode());
                        projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(errorMessage2.getCreatedTime().getTime()));
                        if (!StringUtil.isEmptyOrSpace(errorMessage2.getTaskUid())) {
                            HashMap<String, String> tTaskCondition = new HashMap<String, String>();
                            tTaskCondition.put(TaskLogConditionEnum.TASK_UID.toString(), errorMessage2.getTaskUid());
                            List<TaskLog> taskLogs = this.logManipulateService.getTargetTaskLogs(tAllTaskLogs, tTaskCondition);
                            TaskLog taskLog = null;
                            if (taskLogs != null && !taskLogs.isEmpty()) {
                                taskLog = this.logManipulateService.getLatestTaskLog(taskLogs);
                            }
                            if (taskLog != null) {
                                HashMap<String, String> tActivityCondition = new HashMap<String, String>();
                                tActivityCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "ptm");
                                tActivityCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(), errorMessage2.getProcessActivityOid());
                                tActivityCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");
                                List<ActivityLog> activitiLogs = this.logManipulateService.getTargetActivityLogs(list, tActivityCondition);
                                ActivityLog activityLog = null;
                                if (activitiLogs != null && !activitiLogs.isEmpty()) {
                                    activityLog = activitiLogs.get(0);
                                }
                                HashMap<String, Object> taskLogNode = new HashMap<String, Object>();
                                taskLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(errorMessage2.getCreatedTime().getTime()));
                                if (activityLog != null) {
                                    taskLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(activityLog.getCreatedTime().getTime()));
                                } else {
                                    taskLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(taskLog.getCreatedTime().getTime()));
                                }
                                taskLogNode.put("healthState", "abnormal");
                                this.setAppNameByLocale(taskLogNode, monitorLog, tLocale);
                                taskLogNode.put("appCode", monitorLog.getAppCode());
                                taskLogNode.put("projectCardId", projectLog.getProjectCardId());
                                taskLogNode.put("ruleCode", monitorLog.getRuleCode());
                                this.setProjectNameByLocale(taskLogNode, projectLog, tLocale);
                                this.setTaskNameByLocale(taskLogNode, taskLog, tLocale);
                                if (taskLog.getState() == 1 || taskLog.getState() == 2) {
                                    this.setTaskNameByLocale(projectLogNode, taskLog, tLocale);
                                }
                                if (activityLog != null) {
                                    taskLogNode.put("activityType", activityLog.getActivityType());
                                } else {
                                    taskLogNode.put("activityType", "");
                                }
                                if (activityLog != null) {
                                    if (activityLog.getState() == 1 || activityLog.getState() == 2) {
                                        taskLogNode.put("taskState", "continued");
                                    } else if (activityLog.getState() == 3) {
                                        taskLogNode.put("taskState", "finished");
                                    }
                                } else if (taskLog.getState() == 1 || taskLog.getState() == 2) {
                                    taskLogNode.put("taskState", "continued");
                                } else if (taskLog.getState() == 3) {
                                    taskLogNode.put("taskState", "finished");
                                }
                                if (activityLog != null) {
                                    taskLogNode.put("taskCardId", activityLog.getTaskCardId());
                                } else {
                                    taskLogNode.put("taskCardId", "");
                                }
                                if (activityLog != null) {
                                    taskLogNode.put("source_no", activityLog.getSourceNo());
                                } else {
                                    taskLogNode.put("source_no", taskLog.getSourceIds());
                                }
                                taskLogNode.put("taskId", taskLog.getTaskId());
                                taskLogNode.put("processSerialNumber", errorMessage2.getProcessSerialNumber());
                                if (activityLog != null) {
                                    HashMap<String, String> tActivityAtmcCondition = new HashMap<String, String>();
                                    ActivityLog activityAtmcLog = null;
                                    tActivityAtmcCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "atmc");
                                    tActivityAtmcCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(), activityLog.getActivityUid());
                                    tActivityAtmcCondition.put(ActivityLogConditionEnum.TASK_CARD_ID.toString(), activityLog.getTaskCardId());
                                    tActivityAtmcCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");
                                    List<ActivityLog> activityAtmcLogs = this.logManipulateService.getTargetActivityLogs(list, tActivityAtmcCondition);
                                    if (activityAtmcLogs != null && activityAtmcLogs.size() != 0) {
                                        activityAtmcLog = activityAtmcLogs.get(0);
                                    }
                                    if (activityAtmcLog != null) {
                                        taskLogNode.put("performerId", activityAtmcLog.getPerformerId());
                                        taskLogNode.put("agentPerformerId", activityAtmcLog.getAgentPerformerId());
                                        taskLogNode.put("agentPerformerName", activityAtmcLog.getAgentPerformerName());
                                        taskLogNode.put("performerType", activityAtmcLog.getPerformerType());
                                    } else {
                                        taskLogNode.put("performerId", activityLog.getPerformerId());
                                    }
                                    if (activityAtmcLog != null) {
                                        taskLogNode.put("performerName", activityAtmcLog.getPerformerName());
                                    } else {
                                        taskLogNode.put("performerName", activityLog.getPerformerName());
                                    }
                                    if (activityAtmcLog != null) {
                                        taskLogNode.put("operate", activityAtmcLog.getOperate());
                                    }
                                    if (activityAtmcLog != null && activityAtmcLog.getOperateTime() != null) {
                                        taskLogNode.put("operateTime", this.formatToSecond.format(activityAtmcLog.getOperateTime().getTime()));
                                    }
                                }
                                this.setExceptionContentAndSolution(taskLogNode, errorMessage2, tLocale);
                                pSourceIdInfoArynode.add(taskLogNode);
                                continue;
                            }
                            pSourceIdInfoArynode.add(projectLogNode);
                            this.setExceptionContentAndSolution(projectLogNode, errorMessage2, tLocale);
                            continue;
                        }
                        pSourceIdInfoArynode.add(projectLogNode);
                        this.setExceptionContentAndSolution(projectLogNode, errorMessage2, tLocale);
                    }
                    continue;
                }
                for (ErrorMessage errorMessage2 : (List)errorMessageMapBySerialNumber.get(string)) {
                    HashMap<String, Object> projectLogNode = new HashMap<String, Object>();
                    projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(errorMessage2.getCreatedTime().getTime()));
                    projectLogNode.put("healthState", "abnormal");
                    this.setAppNameByLocale(projectLogNode, monitorLog, tLocale);
                    projectLogNode.put("source_no", monitorLog.getSourceId());
                    projectLogNode.put("traceId", monitorLog.getTraceId());
                    projectLogNode.put("appCode", monitorLog.getAppCode());
                    projectLogNode.put("ruleCode", monitorLog.getRuleCode());
                    projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(errorMessage2.getCreatedTime().getTime()));
                    pSourceIdInfoArynode.add(projectLogNode);
                    this.setExceptionContentAndSolution(projectLogNode, errorMessage2, tLocale);
                }
            }
            if (monitorLogExist) continue;
            if (projectLogMapBySerialNumber.get(string) != null && !((List)projectLogMapBySerialNumber.get(string)).isEmpty()) {
                if (((ProjectLog)((List)projectLogMapBySerialNumber.get(string)).get(0)).getState() != 1 && ((ProjectLog)((List)projectLogMapBySerialNumber.get(string)).get(0)).getState() != 2) continue;
                for (ErrorMessage errorMessage3 : (List)errorMessageMapBySerialNumber.get(string)) {
                    ProjectLog projectLog = (ProjectLog)((List)projectLogMapBySerialNumber.get(string)).get(0);
                    HashMap<String, Object> projectLogNode = new HashMap<String, Object>();
                    projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(projectLog.getCreatedTime().getTime()));
                    projectLogNode.put("healthState", "abnormal");
                    this.setAppNameByLocale(projectLogNode, projectLog, tLocale);
                    this.setProjectNameByLocale(projectLogNode, projectLog, tLocale);
                    projectLogNode.put("projectId", projectLog.getProjectId());
                    projectLogNode.put("projectCardId", projectLog.getProjectCardId());
                    projectLogNode.put("activityType", "auto");
                    if (projectLog.getState() == 1 || projectLog.getState() == 2) {
                        projectLogNode.put("taskState", "continued");
                    } else if (projectLog.getState() == 3) {
                        projectLogNode.put("taskState", "finished");
                    }
                    projectLogNode.put("source_no", projectLog.getSourceIds());
                    projectLogNode.put("traceId", projectLog.getTraceId());
                    projectLogNode.put("appCode", projectLog.getAppCode());
                    projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(errorMessage3.getCreatedTime().getTime()));
                    if (!StringUtil.isEmptyOrSpace(errorMessage3.getTaskUid())) {
                        HashMap<String, String> tTaskCondition = new HashMap<String, String>();
                        tTaskCondition.put(TaskLogConditionEnum.TASK_UID.toString(), errorMessage3.getTaskUid());
                        List<TaskLog> taskLogs = this.logManipulateService.getTargetTaskLogs(tAllTaskLogs, tTaskCondition);
                        TaskLog taskLog = null;
                        if (taskLogs != null && !taskLogs.isEmpty()) {
                            taskLog = this.logManipulateService.getLatestTaskLog(taskLogs);
                        }
                        if (taskLog != null) {
                            HashMap<String, String> tActivityCondition = new HashMap<String, String>();
                            tActivityCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "ptm");
                            tActivityCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(), errorMessage3.getProcessActivityOid());
                            tActivityCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");
                            List<ActivityLog> activitiLogs = this.logManipulateService.getTargetActivityLogs(list, tActivityCondition);
                            ActivityLog activityLog = null;
                            if (activitiLogs != null && !activitiLogs.isEmpty()) {
                                activityLog = activitiLogs.get(0);
                            }
                            HashMap<String, Object> taskLogNode = new HashMap<String, Object>();
                            taskLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(errorMessage3.getCreatedTime().getTime()));
                            if (activityLog != null) {
                                taskLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(activityLog.getCreatedTime().getTime()));
                            } else {
                                taskLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(taskLog.getCreatedTime().getTime()));
                            }
                            taskLogNode.put("healthState", "abnormal");
                            this.setAppNameByLocale(taskLogNode, projectLog, tLocale);
                            taskLogNode.put("projectCardId", projectLog.getProjectCardId());
                            taskLogNode.put("appCode", projectLog.getAppCode());
                            this.setProjectNameByLocale(taskLogNode, projectLog, tLocale);
                            this.setTaskNameByLocale(taskLogNode, taskLog, tLocale);
                            if (taskLog.getState() == 1 || taskLog.getState() == 2) {
                                this.setTaskNameByLocale(projectLogNode, taskLog, tLocale);
                            }
                            if (activityLog != null) {
                                taskLogNode.put("activityType", activityLog.getActivityType());
                            } else {
                                taskLogNode.put("activityType", "");
                            }
                            if (activityLog != null) {
                                if (activityLog.getState() == 1 || activityLog.getState() == 2) {
                                    taskLogNode.put("taskState", "continued");
                                } else if (activityLog.getState() == 3) {
                                    taskLogNode.put("taskState", "finished");
                                }
                            } else if (taskLog.getState() == 1 || taskLog.getState() == 2) {
                                taskLogNode.put("taskState", "continued");
                            } else if (taskLog.getState() == 3) {
                                taskLogNode.put("taskState", "finished");
                            }
                            if (activityLog != null) {
                                taskLogNode.put("taskCardId", activityLog.getTaskCardId());
                            } else {
                                taskLogNode.put("taskCardId", "");
                            }
                            if (activityLog != null) {
                                taskLogNode.put("source_no", activityLog.getSourceNo());
                            } else {
                                taskLogNode.put("source_no", taskLog.getSourceIds());
                            }
                            taskLogNode.put("taskId", taskLog.getTaskId());
                            taskLogNode.put("processSerialNumber", errorMessage3.getProcessSerialNumber());
                            if (activityLog != null) {
                                HashMap<String, String> tActivityAtmcCondition = new HashMap<String, String>();
                                ActivityLog activityAtmcLog = null;
                                tActivityAtmcCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "atmc");
                                tActivityAtmcCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(), activityLog.getActivityUid());
                                tActivityAtmcCondition.put(ActivityLogConditionEnum.TASK_CARD_ID.toString(), activityLog.getTaskCardId());
                                tActivityAtmcCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");
                                List<ActivityLog> activityAtmcLogs = this.logManipulateService.getTargetActivityLogs(list, tActivityAtmcCondition);
                                if (activityAtmcLogs != null && activityAtmcLogs.size() != 0) {
                                    activityAtmcLog = activityAtmcLogs.get(0);
                                }
                                if (activityAtmcLog != null) {
                                    taskLogNode.put("performerId", activityAtmcLog.getPerformerId());
                                    taskLogNode.put("agentPerformerId", activityAtmcLog.getAgentPerformerId());
                                    taskLogNode.put("agentPerformerName", activityAtmcLog.getAgentPerformerName());
                                    taskLogNode.put("performerType", activityAtmcLog.getPerformerType());
                                } else {
                                    taskLogNode.put("performerId", activityLog.getPerformerId());
                                }
                                if (activityAtmcLog != null) {
                                    taskLogNode.put("performerName", activityAtmcLog.getPerformerName());
                                } else {
                                    taskLogNode.put("performerName", activityLog.getPerformerName());
                                }
                                if (activityAtmcLog != null) {
                                    taskLogNode.put("operate", activityAtmcLog.getOperate());
                                }
                                if (activityAtmcLog != null && activityAtmcLog.getOperateTime() != null) {
                                    taskLogNode.put("operateTime", this.formatToSecond.format(activityAtmcLog.getOperateTime().getTime()));
                                }
                            }
                            this.setExceptionContentAndSolution(taskLogNode, errorMessage3, tLocale);
                            pSourceIdInfoArynode.add(taskLogNode);
                            continue;
                        }
                        pSourceIdInfoArynode.add(projectLogNode);
                        this.setExceptionContentAndSolution(projectLogNode, errorMessage3, tLocale);
                        continue;
                    }
                    pSourceIdInfoArynode.add(projectLogNode);
                    this.setExceptionContentAndSolution(projectLogNode, errorMessage3, tLocale);
                }
                continue;
            }
            for (ErrorMessage errorMessage3 : (List)errorMessageMapBySerialNumber.get(string)) {
                HashMap<String, Object> projectLogNode = new HashMap<String, Object>();
                pSourceIdInfoArynode.add(projectLogNode);
                projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(errorMessage3.getCreatedTime().getTime()));
                projectLogNode.put("healthState", "abnormal");
                projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(errorMessage3.getCreatedTime().getTime()));
                this.setExceptionContentAndSolution(projectLogNode, errorMessage3, tLocale);
            }
        }
        return pSourceIdInfoArynode;
    }

    private List<Map<String, Object>> generateSuccessResult(List<Map<String, Object>> pSourceIdInfoArynode, String pTenantId, String pQueryStartDate, String pQueryEndDate, String pCondition) throws ParseException {
        String tLocale = (String)DWServiceContext.getContext().getRequestHeader().get(LocaleEnum.LOCALE.getType());
        if (StringUtil.isEmptyOrSpace(tLocale)) {
            tLocale = "";
        }
        this.log.info((Object)("\u57f7\u884c\u8996\u89d2\u524d\u7aef\u67e5\u8a62\u8a9e\u7cfb\uff1a" + tLocale));
        ArrayList<String> serialNumbers = new ArrayList<String>();
        ArrayList<String> serialNumbersWithError = new ArrayList<String>();
        ArrayList<String> traceIds = new ArrayList<String>();
        HashMap errorMessageMapByTraceId = new HashMap();
        HashMap errorMessageMapBySerialNumber = new HashMap();
        HashMap processLogMapByTraceId = new HashMap();
        HashMap processLogMapBySerialNumber = new HashMap();
        HashMap<String, List<ProjectLog>> projectLogMapBySerialNumber = new HashMap();
        HashMap projectLogMapByTraceId = new HashMap();
        Map<Object, Object> taskLogMapByTaskUid = new HashMap();
        HashMap<String, List<MonitorLog>> monitorLogMapByTraceId = new HashMap();
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        if (!StringUtil.isEmptyOrSpace(pTenantId)) {
            conditionMap.put("tenant_id", pTenantId);
            conditionMap.put(ProjectLogConditionEnum.TENANT_ID.toString(), pTenantId);
        }
        if (!StringUtil.isEmptyOrSpace(pQueryStartDate) && !StringUtil.isEmptyOrSpace(pQueryEndDate)) {
            conditionMap.put("query_start_date", pQueryStartDate);
            conditionMap.put("query_end_date", pQueryEndDate);
        }
        conditionMap.put("condition", pCondition);
        conditionMap.put("is_error", String.valueOf(Boolean.TRUE));
        conditionMap.put(ProjectLogConditionEnum.STATE.toString(), "1");
        List<ProjectLog> projectLogs = this.projectLogDao.fetch(conditionMap);
        projectLogMapBySerialNumber = this.logManipulateService.mapProjectLogByType(projectLogs, MappingTypeEnum.SERIAL_NUMBER.getType());
        this.logManipulateService.sortLatestProjectLog(projectLogMapBySerialNumber);
        for (String serialNumber : projectLogMapBySerialNumber.keySet()) {
            serialNumbers.add(serialNumber);
        }
        List<ErrorMessage> errorMessages = this.errorMessageDao.getErrorsBySerialNumbers(serialNumbers, pTenantId);
        block11: for (String serialNumber : projectLogMapBySerialNumber.keySet()) {
            for (ErrorMessage errorMessage : errorMessages) {
                if (!errorMessage.getProcessSerialNumber().equals(serialNumber)) continue;
                serialNumbersWithError.add(serialNumber);
                continue block11;
            }
        }
        for (String number : serialNumbersWithError) {
            projectLogMapBySerialNumber.remove(number);
        }
        for (String serialNumber : projectLogMapBySerialNumber.keySet()) {
            for (ProjectLog projectLog : (List)projectLogMapBySerialNumber.get(serialNumber)) {
                if (projectLogMapByTraceId.get(projectLog.getTraceId()) != null) {
                    ((List)projectLogMapByTraceId.get(projectLog.getTraceId())).add(projectLog);
                    continue;
                }
                ArrayList<ProjectLog> projectLogList = new ArrayList<ProjectLog>();
                projectLogList.add(projectLog);
                projectLogMapByTraceId.put(projectLog.getTraceId(), projectLogList);
            }
        }
        for (String traceId : projectLogMapByTraceId.keySet()) {
            traceIds.add(traceId);
        }
        List<MonitorLog> monitorLogs = this.monitorLogDao.getMonitorLogsByTraceIds(traceIds, pTenantId);
        monitorLogMapByTraceId = this.logManipulateService.mapMonitorLogByType(monitorLogs, MappingTypeEnum.TRACE_ID.getType());
        this.logManipulateService.sortLatestMonitorLog(monitorLogMapByTraceId);
        serialNumbers.removeAll(serialNumbersWithError);
        List<TaskLog> tAllTaskLogs = this.taskLogDao.getTaskLogsBySerialNumbers(serialNumbers);
        List<ActivityLog> tAllActivityLogs = this.activityLogDao.getActivityLogsBySerialNumbers(serialNumbers);
        for (String traceId : projectLogMapByTraceId.keySet()) {
            boolean monitorLogExist = false;
            if (monitorLogMapByTraceId.containsKey(traceId)) {
                monitorLogExist = true;
                MonitorLog monitorLog = (MonitorLog)((List)monitorLogMapByTraceId.get(traceId)).get(0);
                ArrayNode monitorLogEmptyRowDataAryNode = this.mapper.createArrayNode();
                HashMap<String, Object> monitorLogNode = new HashMap<String, Object>();
                monitorLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(monitorLog.getCreatedTime().getTime()));
                monitorLogNode.put("healthState", "normal");
                this.setAppNameByLocale(monitorLogNode, monitorLog, tLocale);
                switch (tLocale) {
                    case "zh_TW": {
                        monitorLogNode.put("projectName", "\u767c\u8d77\u5075\u6e2c");
                        break;
                    }
                    case "zh_CN": {
                        monitorLogNode.put("projectName", "\u53d1\u8d77\u4fa6\u6d4b");
                        break;
                    }
                    case "en_US": {
                        monitorLogNode.put("projectName", "Initiate detection");
                        break;
                    }
                    default: {
                        monitorLogNode.put("projectName", "\u53d1\u8d77\u4fa6\u6d4b");
                    }
                }
                monitorLogNode.put("activityType", "auto");
                monitorLogNode.put("taskState", "finished");
                monitorLogNode.put("source_no", monitorLog.getSourceId());
                monitorLogNode.put("traceId", monitorLog.getTraceId());
                monitorLogNode.put("appCode", monitorLog.getAppCode());
                monitorLogNode.put("ruleCode", monitorLog.getRuleCode());
                monitorLogNode.put("rowData", monitorLogEmptyRowDataAryNode);
                monitorLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(monitorLog.getCreatedTime()));
                pSourceIdInfoArynode.add(monitorLogNode);
                for (ProjectLog projectLog : (List)projectLogMapByTraceId.get(traceId)) {
                    HashMap<String, Object> projectLogNode = new HashMap<String, Object>();
                    projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(projectLog.getCreatedTime().getTime()));
                    projectLogNode.put("healthState", "normal");
                    this.setAppNameByLocale(projectLogNode, monitorLog, tLocale);
                    this.setProjectNameByLocale(projectLogNode, projectLog, tLocale);
                    projectLogNode.put("activityType", "auto");
                    if (projectLog.getState() == 1 || projectLog.getState() == 2) {
                        projectLogNode.put("taskState", "continued");
                    } else if (projectLog.getState() == 3) {
                        projectLogNode.put("taskState", "finished");
                    }
                    projectLogNode.put("source_no", projectLog.getSourceIds());
                    projectLogNode.put("traceId", monitorLog.getTraceId());
                    projectLogNode.put("appCode", monitorLog.getAppCode());
                    projectLogNode.put("ruleCode", monitorLog.getRuleCode());
                    projectLogNode.put("projectId", projectLog.getProjectId());
                    projectLogNode.put("projectCardId", projectLog.getProjectCardId());
                    projectLogNode.put("processSerialNumber", projectLog.getProcessSerialNumber());
                    projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(projectLog.getCreatedTime()));
                    HashMap<String, String> tTaskCondition = new HashMap<String, String>();
                    tTaskCondition.put(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(), projectLog.getProcessSerialNumber());
                    List<TaskLog> taskLogs = this.logManipulateService.getTargetTaskLogs(tAllTaskLogs, tTaskCondition);
                    if (taskLogs != null && !taskLogs.isEmpty()) {
                        taskLogMapByTaskUid = this.logManipulateService.mapTaskLogByType(taskLogs, MappingTypeEnum.TASK_UID.getType());
                    }
                    for (Object taskUid2 : taskLogMapByTaskUid.keySet()) {
                        HashMap<String, String> tActivityCondition = new HashMap<String, String>();
                        tActivityCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "ptm");
                        tActivityCondition.put(ActivityLogConditionEnum.TASK_UID.toString(), (String)taskUid2);
                        List<ActivityLog> activitiLogs = this.logManipulateService.getTargetActivityLogs(tAllActivityLogs, tActivityCondition);
                        if (activitiLogs != null && !activitiLogs.isEmpty()) {
                            for (ActivityLog activityLog : activitiLogs) {
                                HashMap<String, Object> taskOrActivityLogNode = new HashMap<String, Object>();
                                pSourceIdInfoArynode.add(taskOrActivityLogNode);
                                taskOrActivityLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(activityLog.getCreatedTime().getTime()));
                                taskOrActivityLogNode.put("projectCardId", projectLog.getProjectCardId());
                                taskOrActivityLogNode.put("healthState", "normal");
                                taskOrActivityLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(activityLog.getCreatedTime().getTime()));
                                this.setAppNameByLocale(taskOrActivityLogNode, monitorLog, tLocale);
                                this.setProjectNameByLocale(taskOrActivityLogNode, projectLog, tLocale);
                                List tTaskLogs = (List)taskLogMapByTaskUid.get(taskUid2);
                                TaskLog tTaskLog = null;
                                tTaskLog = this.logManipulateService.getLatestTaskLog(tTaskLogs);
                                HashMap<String, String> tActivityAtmcCondition = new HashMap<String, String>();
                                ActivityLog activityAtmcLog = null;
                                tActivityAtmcCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "atmc");
                                tActivityAtmcCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(), activityLog.getActivityUid());
                                tActivityAtmcCondition.put(ActivityLogConditionEnum.TASK_CARD_ID.toString(), activityLog.getTaskCardId());
                                tActivityAtmcCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");
                                List<ActivityLog> activityAtmcLogs = this.logManipulateService.getTargetActivityLogs(tAllActivityLogs, tActivityAtmcCondition);
                                if (activityAtmcLogs != null && activityAtmcLogs.size() != 0) {
                                    activityAtmcLog = activityAtmcLogs.get(0);
                                }
                                taskOrActivityLogNode.put("activityType", activityLog.getActivityType());
                                if (activityLog != null) {
                                    if (activityLog.getState() == 1 || activityLog.getState() == 2) {
                                        taskOrActivityLogNode.put("taskState", "continued");
                                    } else if (activityLog.getState() == 3) {
                                        taskOrActivityLogNode.put("taskState", "finished");
                                    }
                                }
                                if (activityAtmcLog != null) {
                                    taskOrActivityLogNode.put("source_no", activityAtmcLog.getSourceNo());
                                } else {
                                    taskOrActivityLogNode.put("source_no", activityLog.getSourceNo());
                                }
                                if (activityAtmcLog != null) {
                                    taskOrActivityLogNode.put("performerId", activityAtmcLog.getPerformerId());
                                    taskOrActivityLogNode.put("agentPerformerId", activityAtmcLog.getAgentPerformerId());
                                    taskOrActivityLogNode.put("agentPerformerName", activityAtmcLog.getAgentPerformerName());
                                    taskOrActivityLogNode.put("performerType", activityAtmcLog.getPerformerType());
                                } else {
                                    taskOrActivityLogNode.put("performerId", activityLog.getPerformerId());
                                }
                                if (activityAtmcLog != null) {
                                    taskOrActivityLogNode.put("performerName", activityAtmcLog.getPerformerName());
                                } else {
                                    taskOrActivityLogNode.put("performerName", activityLog.getPerformerName());
                                }
                                if (activityAtmcLog != null) {
                                    taskOrActivityLogNode.put("operate", activityAtmcLog.getOperate());
                                }
                                if (activityAtmcLog != null && activityAtmcLog.getOperateTime() != null) {
                                    taskOrActivityLogNode.put("operateTime", this.formatToSecond.format(activityAtmcLog.getOperateTime().getTime()));
                                }
                                if (activityAtmcLog != null) {
                                    taskOrActivityLogNode.put("taskCardId", activityAtmcLog.getTaskCardId());
                                } else {
                                    taskOrActivityLogNode.put("taskCardId", activityLog.getTaskCardId());
                                }
                                if (activityAtmcLog != null) {
                                    taskOrActivityLogNode.put("taskUid", activityAtmcLog.getTaskUid());
                                } else {
                                    taskOrActivityLogNode.put("taskUid", activityLog.getTaskUid());
                                }
                                taskOrActivityLogNode.put("processSerialNumber", activityLog.getProcessSerialNumber());
                                taskOrActivityLogNode.put("appCode", monitorLog.getAppCode());
                                taskOrActivityLogNode.put("ruleCode", monitorLog.getRuleCode());
                                if (tTaskLog == null) continue;
                                this.setTaskNameByLocale(taskOrActivityLogNode, tTaskLog, tLocale);
                                taskOrActivityLogNode.put("taskId", tTaskLog.getTaskId());
                                if (tTaskLog.getState() != 1 && tTaskLog.getState() != 2) continue;
                                this.setTaskNameByLocale(projectLogNode, tTaskLog, tLocale);
                                projectLogNode.put("activityType", activityLog.getActivityType());
                                projectLogNode.put("taskId", tTaskLog.getTaskId());
                                if (activityAtmcLog != null) {
                                    projectLogNode.put("taskCardId", activityAtmcLog.getTaskCardId());
                                } else {
                                    projectLogNode.put("taskCardId", activityLog.getTaskCardId());
                                }
                                if (activityAtmcLog != null) {
                                    projectLogNode.put("taskUid", activityAtmcLog.getTaskUid());
                                    continue;
                                }
                                projectLogNode.put("taskUid", activityLog.getTaskUid());
                            }
                            continue;
                        }
                        HashMap<String, Object> taskOrActivityLogNode = new HashMap<String, Object>();
                        pSourceIdInfoArynode.add(taskOrActivityLogNode);
                        List tTaskLogs = (List)taskLogMapByTaskUid.get(taskUid2);
                        TaskLog tTaskLog = null;
                        tTaskLog = this.logManipulateService.getLatestTaskLog(tTaskLogs);
                        if (tTaskLog == null) continue;
                        taskOrActivityLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(tTaskLog.getCreatedTime().getTime()));
                        taskOrActivityLogNode.put("projectCardId", projectLog.getProjectCardId());
                        taskOrActivityLogNode.put("healthState", "normal");
                        taskOrActivityLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(tTaskLog.getCreatedTime().getTime()));
                        this.setAppNameByLocale(taskOrActivityLogNode, monitorLog, tLocale);
                        this.setProjectNameByLocale(taskOrActivityLogNode, projectLog, tLocale);
                        taskOrActivityLogNode.put("activityType", "");
                        if (tTaskLog.getState() == 1 || tTaskLog.getState() == 2) {
                            taskOrActivityLogNode.put("taskState", "continued");
                        } else if (tTaskLog.getState() == 3) {
                            taskOrActivityLogNode.put("taskState", "finished");
                        }
                        taskOrActivityLogNode.put("source_no", tTaskLog.getSourceIds());
                        taskOrActivityLogNode.put("processSerialNumber", tTaskLog.getProcessSerialNumber());
                        taskOrActivityLogNode.put("appCode", monitorLog.getAppCode());
                        taskOrActivityLogNode.put("ruleCode", monitorLog.getRuleCode());
                        this.setTaskNameByLocale(taskOrActivityLogNode, tTaskLog, tLocale);
                        taskOrActivityLogNode.put("taskId", tTaskLog.getTaskId());
                        if (tTaskLog.getState() != 1 && tTaskLog.getState() != 2) continue;
                        this.setTaskNameByLocale(projectLogNode, tTaskLog, tLocale);
                        projectLogNode.put("activityType", "");
                        projectLogNode.put("taskId", tTaskLog.getTaskId());
                        projectLogNode.put("taskUid", tTaskLog.getTaskUid());
                    }
                    pSourceIdInfoArynode = this.jsonManipulateService.sortJsonArrayByAttribute(pSourceIdInfoArynode, LogAttributeEnum.CREATED_TIME.getAttribute(), true);
                }
            }
            if (monitorLogExist) continue;
            for (ProjectLog projectLog : (List)projectLogMapByTraceId.get(traceId)) {
                HashMap<String, Object> projectLogNode = new HashMap<String, Object>();
                projectLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(projectLog.getCreatedTime().getTime()));
                projectLogNode.put("healthState", "normal");
                this.setAppNameByLocale(projectLogNode, projectLog, tLocale);
                this.setProjectNameByLocale(projectLogNode, projectLog, tLocale);
                projectLogNode.put("activityType", "auto");
                if (projectLog.getState() == 1 || projectLog.getState() == 2) {
                    projectLogNode.put("taskState", "continued");
                } else if (projectLog.getState() == 3) {
                    projectLogNode.put("taskState", "finished");
                }
                projectLogNode.put("source_no", projectLog.getSourceIds());
                projectLogNode.put("traceId", projectLog.getTraceId());
                projectLogNode.put("appCode", projectLog.getAppCode());
                projectLogNode.put("projectId", projectLog.getProjectId());
                projectLogNode.put("projectCardId", projectLog.getProjectCardId());
                projectLogNode.put("processSerialNumber", projectLog.getProcessSerialNumber());
                projectLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(projectLog.getCreatedTime()));
                HashMap<String, String> tTaskCondition = new HashMap<String, String>();
                tTaskCondition.put(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(), projectLog.getProcessSerialNumber());
                List<TaskLog> taskLogs = this.logManipulateService.getTargetTaskLogs(tAllTaskLogs, tTaskCondition);
                if (taskLogs != null && !taskLogs.isEmpty()) {
                    taskLogMapByTaskUid = this.logManipulateService.mapTaskLogByType(taskLogs, MappingTypeEnum.TASK_UID.getType());
                }
                for (String taskUid : taskLogMapByTaskUid.keySet()) {
                    HashMap<String, String> tActivityCondition = new HashMap<String, String>();
                    tActivityCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "ptm");
                    tActivityCondition.put(ActivityLogConditionEnum.TASK_UID.toString(), taskUid);
                    List<ActivityLog> activitiLogs = this.logManipulateService.getTargetActivityLogs(tAllActivityLogs, tActivityCondition);
                    if (activitiLogs != null && !activitiLogs.isEmpty()) {
                        Object taskUid2;
                        taskUid2 = activitiLogs.iterator();
                        while (taskUid2.hasNext()) {
                            ActivityLog activityLog = taskUid2.next();
                            HashMap<String, Object> taskOrActivityLogNode = new HashMap<String, Object>();
                            pSourceIdInfoArynode.add(taskOrActivityLogNode);
                            taskOrActivityLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(activityLog.getCreatedTime().getTime()));
                            taskOrActivityLogNode.put("projectCardId", projectLog.getProjectCardId());
                            taskOrActivityLogNode.put("healthState", "normal");
                            taskOrActivityLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(activityLog.getCreatedTime().getTime()));
                            this.setAppNameByLocale(taskOrActivityLogNode, projectLog, tLocale);
                            this.setProjectNameByLocale(taskOrActivityLogNode, projectLog, tLocale);
                            List tTaskLogs = (List)taskLogMapByTaskUid.get(taskUid);
                            TaskLog tTaskLog = null;
                            tTaskLog = this.logManipulateService.getLatestTaskLog(tTaskLogs);
                            HashMap<String, String> tActivityAtmcCondition = new HashMap<String, String>();
                            ActivityLog activityAtmcLog = null;
                            tActivityAtmcCondition.put(ActivityLogConditionEnum.APP_ID.toString(), "atmc");
                            tActivityAtmcCondition.put(ActivityLogConditionEnum.ACTIVITY_UID.toString(), activityLog.getActivityUid());
                            tActivityAtmcCondition.put(ActivityLogConditionEnum.TASK_CARD_ID.toString(), activityLog.getTaskCardId());
                            tActivityAtmcCondition.put(ActivityLogConditionEnum.TOP_ONE_RECORD.toString(), "");
                            List<ActivityLog> activityAtmcLogs = this.logManipulateService.getTargetActivityLogs(tAllActivityLogs, tActivityAtmcCondition);
                            if (activityAtmcLogs != null && activityAtmcLogs.size() != 0) {
                                activityAtmcLog = activityAtmcLogs.get(0);
                            }
                            taskOrActivityLogNode.put("activityType", activityLog.getActivityType());
                            if (activityLog != null) {
                                if (activityLog.getState() == 1 || activityLog.getState() == 2) {
                                    taskOrActivityLogNode.put("taskState", "continued");
                                } else if (activityLog.getState() == 3) {
                                    taskOrActivityLogNode.put("taskState", "finished");
                                }
                            }
                            if (activityAtmcLog != null) {
                                taskOrActivityLogNode.put("source_no", activityAtmcLog.getSourceNo());
                            } else {
                                taskOrActivityLogNode.put("source_no", activityLog.getSourceNo());
                            }
                            if (activityAtmcLog != null) {
                                taskOrActivityLogNode.put("performerId", activityAtmcLog.getPerformerId());
                                taskOrActivityLogNode.put("agentPerformerId", activityAtmcLog.getAgentPerformerId());
                                taskOrActivityLogNode.put("agentPerformerName", activityAtmcLog.getAgentPerformerName());
                                taskOrActivityLogNode.put("performerType", activityAtmcLog.getPerformerType());
                            } else {
                                taskOrActivityLogNode.put("performerId", activityLog.getPerformerId());
                            }
                            if (activityAtmcLog != null) {
                                taskOrActivityLogNode.put("performerName", activityAtmcLog.getPerformerName());
                            } else {
                                taskOrActivityLogNode.put("performerName", activityLog.getPerformerName());
                            }
                            if (activityAtmcLog != null) {
                                taskOrActivityLogNode.put("operate", activityAtmcLog.getOperate());
                            }
                            if (activityAtmcLog != null && activityAtmcLog.getOperateTime() != null) {
                                taskOrActivityLogNode.put("operateTime", this.formatToSecond.format(activityAtmcLog.getOperateTime().getTime()));
                            }
                            if (activityAtmcLog != null) {
                                taskOrActivityLogNode.put("taskCardId", activityAtmcLog.getTaskCardId());
                            } else {
                                taskOrActivityLogNode.put("taskCardId", activityLog.getTaskCardId());
                            }
                            if (activityAtmcLog != null) {
                                taskOrActivityLogNode.put("taskUid", activityAtmcLog.getTaskUid());
                            } else {
                                taskOrActivityLogNode.put("taskUid", activityLog.getTaskUid());
                            }
                            taskOrActivityLogNode.put("processSerialNumber", activityLog.getProcessSerialNumber());
                            taskOrActivityLogNode.put("appCode", projectLog.getAppCode());
                            if (tTaskLog == null) continue;
                            this.setTaskNameByLocale(taskOrActivityLogNode, tTaskLog, tLocale);
                            taskOrActivityLogNode.put("taskId", tTaskLog.getTaskId());
                            if (tTaskLog.getState() != 1 && tTaskLog.getState() != 2) continue;
                            this.setTaskNameByLocale(projectLogNode, tTaskLog, tLocale);
                            projectLogNode.put("taskId", tTaskLog.getTaskId());
                            projectLogNode.put("activityType", activityLog.getActivityType());
                            if (activityAtmcLog != null) {
                                projectLogNode.put("taskCardId", activityAtmcLog.getTaskCardId());
                            } else {
                                projectLogNode.put("taskCardId", activityLog.getTaskCardId());
                            }
                            if (activityAtmcLog != null) {
                                projectLogNode.put("taskUid", activityAtmcLog.getTaskUid());
                                continue;
                            }
                            projectLogNode.put("taskUid", activityLog.getTaskUid());
                        }
                        continue;
                    }
                    HashMap<String, Object> taskOrActivityLogNode = new HashMap<String, Object>();
                    pSourceIdInfoArynode.add(taskOrActivityLogNode);
                    List tTaskLogs = (List)taskLogMapByTaskUid.get(taskUid);
                    TaskLog tTaskLog = null;
                    tTaskLog = this.logManipulateService.getLatestTaskLog(tTaskLogs);
                    if (tTaskLog == null) continue;
                    taskOrActivityLogNode.put(LogAttributeEnum.CREATED_TIME.getAttribute(), this.formatToSecond.format(tTaskLog.getCreatedTime().getTime()));
                    taskOrActivityLogNode.put("projectCardId", projectLog.getProjectCardId());
                    taskOrActivityLogNode.put("healthState", "normal");
                    taskOrActivityLogNode.put(LogAttributeEnum.ERROR_TIME.getAttribute(), this.formatToSecond.format(tTaskLog.getCreatedTime().getTime()));
                    this.setAppNameByLocale(taskOrActivityLogNode, projectLog, tLocale);
                    this.setProjectNameByLocale(taskOrActivityLogNode, projectLog, tLocale);
                    taskOrActivityLogNode.put("activityType", "");
                    if (tTaskLog.getState() == 1 || tTaskLog.getState() == 2) {
                        taskOrActivityLogNode.put("taskState", "continued");
                    } else if (tTaskLog.getState() == 3) {
                        taskOrActivityLogNode.put("taskState", "finished");
                    }
                    taskOrActivityLogNode.put("source_no", tTaskLog.getSourceIds());
                    taskOrActivityLogNode.put("processSerialNumber", tTaskLog.getProcessSerialNumber());
                    taskOrActivityLogNode.put("appCode", projectLog.getAppCode());
                    this.setTaskNameByLocale(taskOrActivityLogNode, tTaskLog, tLocale);
                    taskOrActivityLogNode.put("taskId", tTaskLog.getTaskId());
                    if (tTaskLog.getState() != 1 && tTaskLog.getState() != 2) continue;
                    this.setTaskNameByLocale(projectLogNode, tTaskLog, tLocale);
                    projectLogNode.put("taskId", tTaskLog.getTaskId());
                    projectLogNode.put("activityType", "");
                    projectLogNode.put("taskUid", tTaskLog.getTaskUid());
                }
                pSourceIdInfoArynode = this.jsonManipulateService.sortJsonArrayByAttribute(pSourceIdInfoArynode, LogAttributeEnum.CREATED_TIME.getAttribute(), true);
            }
        }
        return pSourceIdInfoArynode;
    }

    private List<Map<String, Object>> sourceNoSearch(List<Map<String, Object>> pSourceIdInfoArynode, String pTenantId, String pQueryStartDate, String pQueryEndDate, String pCondition, String pSourceId, String pRuleCode, String pCreatedTime, String pProcessSerialNumber) throws ParseException {
        ArrayList<Map<String, Object>> finalSourceIdInfoArayNode = new ArrayList<Map<String, Object>>();
        if (!StringUtil.isEmptyOrSpace(pProcessSerialNumber) && !StringUtil.isEmptyOrSpace(pCreatedTime)) {
            Date tCreateDate = this.formatToDate.parse(pCreatedTime);
            pSourceIdInfoArynode = this.generateStuckResult(pSourceIdInfoArynode, pTenantId, this.formatToDate.format(tCreateDate), this.formatToDate.format(Calendar.getInstance().getTime()), pCondition);
            pSourceIdInfoArynode = this.generateSuccessResult(pSourceIdInfoArynode, pTenantId, this.formatToDate.format(tCreateDate), this.formatToDate.format(Calendar.getInstance().getTime()), pCondition);
            for (Map<String, Object> node : pSourceIdInfoArynode) {
                if (node.get("processSerialNumber") == null || !pProcessSerialNumber.equals(node.get("processSerialNumber"))) continue;
                finalSourceIdInfoArayNode.add(node);
            }
        } else {
            Date tStartDate = this.formatToDate.parse(pQueryStartDate);
            Date tEndDate = this.formatToDate.parse(pQueryEndDate);
            if (pCondition.equals(ExecutionViewSearchEnum.STUCK.getType())) {
                pSourceIdInfoArynode = this.generateStuckResult(pSourceIdInfoArynode, pTenantId, this.formatToDate.format(tStartDate), this.formatToDate.format(tEndDate), pCondition);
            } else if (pCondition.equals(ExecutionViewSearchEnum.SUCCESS.getType())) {
                pSourceIdInfoArynode = this.generateSuccessResult(pSourceIdInfoArynode, pTenantId, this.formatToDate.format(tStartDate), this.formatToDate.format(tEndDate), pCondition);
            } else if (pCondition.equals(ExecutionViewSearchEnum.TOTAL.getType())) {
                pSourceIdInfoArynode = this.generateStuckResult(pSourceIdInfoArynode, pTenantId, this.formatToDate.format(tStartDate), this.formatToDate.format(tEndDate), pCondition);
                pSourceIdInfoArynode = this.generateSuccessResult(pSourceIdInfoArynode, pTenantId, this.formatToDate.format(tStartDate), this.formatToDate.format(tEndDate), pCondition);
            }
        }
        for (Map<String, Object> node : pSourceIdInfoArynode) {
            if (!StringUtil.isEmptyOrSpace(pSourceId) && !StringUtil.isEmptyOrSpace(pRuleCode)) {
                if (node.get("source_no") == null || String.valueOf(node.get("source_no")).indexOf(pSourceId) == -1 || node.get("ruleCode") == null || !pRuleCode.contains(String.valueOf(node.get("ruleCode")))) continue;
                finalSourceIdInfoArayNode.add(node);
                continue;
            }
            if (!StringUtil.isEmptyOrSpace(pSourceId)) {
                if (node.get("source_no") == null || String.valueOf(node.get("source_no")).indexOf(pSourceId) == -1) continue;
                finalSourceIdInfoArayNode.add(node);
                continue;
            }
            if (StringUtil.isEmptyOrSpace(pRuleCode) || node.get("ruleCode") == null || !pRuleCode.contains(String.valueOf(node.get("ruleCode")))) continue;
            finalSourceIdInfoArayNode.add(node);
        }
        return this.jsonManipulateService.sortJsonArrayByAttribute(finalSourceIdInfoArayNode, LogAttributeEnum.CREATED_TIME.getAttribute(), true);
    }
}

