/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.api.service.processor.AbstractConsumeProcessor;
import com.digiwin.athena.itsys.dao.MonitorLogDao;
import com.digiwin.athena.itsys.enums.ErrorSummaryEnum;
import com.digiwin.athena.itsys.enums.LocaleEnum;
import com.digiwin.athena.itsys.enums.LogAttributeEnum;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.model.MonitorLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorLogConsumeProcessor
extends AbstractConsumeProcessor {
    @Autowired
    private MonitorLogDao monitorLogDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    ObjectMapper mapper = new ObjectMapper();
    private String GET_APPCODE_BY_MONITOR_RULECODE_PATH = "/restful/service/knowledgegraph/app/appCodeByMonitorRuleCode";
    private String GET_SOURCEIDKEY_BY_MONITOR_RULECODE_PATH = "/restful/service/knowledgegraph/action/sourceIdKey";
    private String GET_LICENSEKEY_BY_TENANTID_PATH = "/restful/service/knowledgegraph/app/licenseKey";
    private String IAM_IDENTITY_LOGIN_PATH = "/api/iam/v2/identity/login";

    public MonitorLogConsumeProcessor() {
        this.queueType = MessageQueueTypeEnum.MONITOR_LOG_QUEUE;
    }

    @Override
    protected void handleQueueMessage(String pMessage) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode tMessageNode = mapper.readTree(pMessage);
        this.saveData(tMessageNode);
    }

    protected MonitorLog saveData(JsonNode pMessageNode) throws Exception {
        String exceptionEntity;
        MonitorLog monitorLog = new MonitorLog();
        if (pMessageNode.get("traceId") != null) {
            monitorLog.setTraceId(pMessageNode.get("traceId").asText());
        }
        monitorLog.setRuleCode(pMessageNode.get("ruleCode").asText());
        if (pMessageNode.get(LogAttributeEnum.DETECT_TIME.getAttribute()) != null) {
            monitorLog.setDetectTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(LogAttributeEnum.DETECT_TIME.getAttribute()).asText()));
        }
        if (pMessageNode.get("createdTime") != null) {
            monitorLog.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get("createdTime").asText()));
        }
        monitorLog.setTenantId(pMessageNode.get("tenantId").asText());
        if (pMessageNode.get("processEntities") != null && ((ArrayNode)pMessageNode.get("processEntities")).size() != 0) {
            monitorLog.setDetectData(pMessageNode.get("processEntities").toString());
        }
        monitorLog.setBuildTime(Calendar.getInstance());
        if (pMessageNode.get("state") != null) {
            monitorLog.setState(pMessageNode.get("state").asBoolean());
        }
        try {
            Map<String, String> tAppNameMap = this.getAppName(pMessageNode.get("ruleCode").asText(), pMessageNode.get("tenantId").asText());
            monitorLog.setAppNameZhCn(tAppNameMap.get(LocaleEnum.ZH_CN.getType()));
            monitorLog.setAppNameZhTw(tAppNameMap.get(LocaleEnum.ZH_TW.getType()));
            monitorLog.setAppNameEnUs(tAppNameMap.get(LocaleEnum.EN_US.getType()));
            monitorLog.setAppCode(tAppNameMap.get(ErrorSummaryEnum.APP_CODE.getCode()));
        }
        catch (DWHttpFailedException e) {
            exceptionEntity = (String)e.getEntity(String.class);
            this.log.error((Object)("exceptionEntity = " + exceptionEntity), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            this.log.error((Object)("\u53d6\u5f97\u61c9\u7528\u540d\u7a31(appName)\u5931\u6557, ruleCode = " + pMessageNode.get("ruleCode").asText() + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + pMessageNode.toString()));
        }
        try {
            if (pMessageNode.get("processEntities") != null && ((ArrayNode)pMessageNode.get("processEntities")).size() != 0) {
                monitorLog.setSourceIdKey(this.getSourceIdKey(pMessageNode.get("ruleCode").asText(), pMessageNode.get("tenantId").asText()));
                monitorLog.setSourceId(this.getSourceIds(pMessageNode));
            }
        }
        catch (DWHttpFailedException e) {
            exceptionEntity = (String)e.getEntity(String.class);
            this.log.error((Object)("exceptionEntity = " + exceptionEntity), (Throwable)e);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            this.log.error((Object)("\u53d6\u5f97\u6e90\u55ae\u64da(sourceId)\u5931\u6557, ruleCode = " + pMessageNode.get("ruleCode").asText() + "\uff0csourceIdKey = " + this.getSourceIdKey(pMessageNode.get("ruleCode").asText(), pMessageNode.get("tenantId").asText()) + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + pMessageNode.toString()));
        }
        if (pMessageNode.get("exception") != null) {
            monitorLog.setException(pMessageNode.get("exception").asText());
        }
        if (pMessageNode.get("exceptionType") != null) {
            monitorLog.setExceptionType(pMessageNode.get("exceptionType").asText());
        }
        if (pMessageNode.get("initial") != null) {
            monitorLog.setInitial(pMessageNode.get("initial").asBoolean());
        }
        if (pMessageNode.get("eocId") != null) {
            ObjectNode eocIdNode = (ObjectNode)pMessageNode.get("eocId");
            if (eocIdNode.get("eocCompanyId") != null) {
                monitorLog.setEocCompanyId(eocIdNode.get("eocCompanyId").asText());
            }
            if (eocIdNode.get("eocSiteId") != null) {
                monitorLog.setEocSiteId(eocIdNode.get("eocSiteId").asText());
            }
            if (eocIdNode.get("eocRegionId") != null) {
                monitorLog.setEocRegionId(eocIdNode.get("eocRegionId").asText());
            }
        }
        return this.monitorLogDao.save(monitorLog);
    }

    protected Map<String, Object> updateErrorState(String pMessage) {
        return null;
    }

    protected Map<String, String> getAppName(String pRuleCode, String pTenant) throws Exception {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty((String)"knowledgemaps.url");
        URI tKnowledgemapsTargetUri = DWURIBuilder.create((String)(tKnowledgemapsUrl + this.GET_APPCODE_BY_MONITOR_RULECODE_PATH + "?code=" + pRuleCode)).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        tHttpGet.setHeader("token", this.getToken(pTenant));
        Map tResponseAsMap = (Map)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, Map.class);
        ArrayList tResponseAry = (ArrayList)tResponseAsMap.get("response");
        Object obj = null;
        if (tResponseAry != null && tResponseAry.size() > 0) {
            obj = tResponseAry.get(0);
        }
        if (null == obj) {
            return returnMap;
        }
        String firstObjectInResponseAry = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        JsonNode firstObjectNode = this.mapper.readTree(firstObjectInResponseAry);
        String appCode = firstObjectNode.get(ErrorSummaryEnum.APP_CODE.getCode()).asText();
        returnMap.put(ErrorSummaryEnum.APP_CODE.getCode(), appCode);
        JsonNode langObjectNode = firstObjectNode.get(ErrorSummaryEnum.LANG.getCode());
        if (null == langObjectNode) {
            return returnMap;
        }
        JsonNode appNameObjectNode = langObjectNode.get(ErrorSummaryEnum.APP_NAME.getCode());
        if (null == appNameObjectNode) {
            return returnMap;
        }
        if (appNameObjectNode.get(LocaleEnum.ZH_CN.getType()) != null) {
            returnMap.put(LocaleEnum.ZH_CN.getType(), appNameObjectNode.get(LocaleEnum.ZH_CN.getType()).asText());
        }
        if (appNameObjectNode.get(LocaleEnum.ZH_TW.getType()) != null) {
            returnMap.put(LocaleEnum.ZH_TW.getType(), appNameObjectNode.get(LocaleEnum.ZH_TW.getType()).asText());
        }
        if (appNameObjectNode.get(LocaleEnum.EN_US.getType()) != null) {
            returnMap.put(LocaleEnum.EN_US.getType(), appNameObjectNode.get(LocaleEnum.EN_US.getType()).asText());
        }
        return returnMap;
    }

    protected String getSourceIds(JsonNode pMessageNode) throws Exception {
        ArrayList<String> tProcessEntitiesAry = new ArrayList<String>();
        String tSourceIdKey = this.getSourceIdKey(pMessageNode.get("ruleCode").asText(), pMessageNode.get("tenantId").asText());
        ArrayNode tProcessEntitiesAryNode = this.mapper.createArrayNode();
        tProcessEntitiesAryNode = (ArrayNode)pMessageNode.get("processEntities");
        for (JsonNode processEntity : tProcessEntitiesAryNode) {
            tProcessEntitiesAry.add(processEntity.findValue(tSourceIdKey).asText());
        }
        return ((Object)tProcessEntitiesAry).toString();
    }

    protected String getSourceIdKey(String pRuleCode, String pTenant) throws Exception {
        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty((String)"knowledgemaps.url");
        URI tKnowledgemapsTargetUri = DWURIBuilder.create((String)(tKnowledgemapsUrl + this.GET_SOURCEIDKEY_BY_MONITOR_RULECODE_PATH + "?ruleCode=" + pRuleCode)).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        tHttpGet.setHeader("token", this.getToken(pTenant));
        Map tGetAppCodeInfoResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, Map.class);
        String tAppNameJsonPath = (String)tGetAppCodeInfoResponse.get("response");
        return tAppNameJsonPath;
    }

    private String getToken(String pTenant) throws Exception {
        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty((String)"knowledgemaps.url");
        URI tKnowledgemapsTargetUri = DWURIBuilder.create((String)(tKnowledgemapsUrl + this.GET_LICENSEKEY_BY_TENANTID_PATH + "?tenantId=" + pTenant)).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        Map tGetLicenseKeyResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, Map.class);
        String tSecretKey = "";
        tSecretKey = MonitorLogConsumeProcessor.decodeAES((String)tGetLicenseKeyResponse.get("response"));
        String tIamUrl = DWApplicationConfigUtils.getProperty((String)"iam.url");
        URI tIamTargetUri = DWURIBuilder.create((String)(tIamUrl + this.IAM_IDENTITY_LOGIN_PATH)).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        tPost.setHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HashMap<String, String> tGetIamRequest = new HashMap<String, String>();
        tGetIamRequest.put("secretKey", tSecretKey);
        tGetIamRequest.put("identityType", "secretKey");
        tPost.setEntity((HttpEntity)new DWJsonEntity(tGetIamRequest));
        Map tGetIamResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tPost, Map.class, new DWRequestOption(false));
        this.log.info((Object)("\u5075\u6e2c\u6d88\u606f\u53d6\u5f97\u7528\u6236token, \u79df\u6236[" + pTenant + "], token = " + (String)tGetIamResponse.get("token")));
        return (String)tGetIamResponse.get("token");
    }

    private static String decodeAES(String secretFile) throws Exception {
        byte[] result = new byte[]{};
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        SecretKeySpec key1 = new SecretKeySpec(Hex.decodeHex((String)secretKey), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, key1);
        result = cipher.doFinal(Hex.decodeHex((String)secretFile));
        return new String(result);
    }
}

