/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.api.service.processor.AbstractConsumeProcessor;
import com.digiwin.athena.itsys.dao.ProjectLogDao;
import com.digiwin.athena.itsys.enums.ErrorSummaryEnum;
import com.digiwin.athena.itsys.enums.LocaleEnum;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.enums.ProjectLogConditionEnum;
import com.digiwin.athena.itsys.enums.ProjectLogJsonAttributeEnum;
import com.digiwin.athena.itsys.model.ProjectLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.internal.LinkedTreeMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectLogPtmConsumeProcessor
extends AbstractConsumeProcessor {
    @Autowired
    private ProjectLogDao projectLogDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    ObjectMapper mapper = new ObjectMapper();
    private String GET_APP_NAME_PATH = "/restful/service/knowledgegraph/app/AppCodeByTypeAndCode?type=task&";
    private String GET_LICENSEKEY_BY_TENANTID_PATH = "/restful/service/knowledgegraph/app/licenseKey";
    private String IAM_IDENTITY_LOGIN_PATH = "/api/iam/v2/identity/login";

    public ProjectLogPtmConsumeProcessor() {
        this.queueType = MessageQueueTypeEnum.PROJECT_LOG_PTM_QUEUE;
    }

    @Override
    protected void handleQueueMessage(String pMessage) throws Exception {
        JsonNode tMessageNode = this.mapper.readTree(pMessage);
        HashMap<String, String> tProjectLogCondition = new HashMap<String, String>();
        tProjectLogCondition.put(ProjectLogConditionEnum.APP_ID.toString(), tMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()).asText());
        tProjectLogCondition.put(ProjectLogConditionEnum.TENANT_ID.toString(), tMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()).asText());
        tProjectLogCondition.put(ProjectLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(), tMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()).asText());
        List<ProjectLog> tProjectLogs = this.projectLogDao.fetch(tProjectLogCondition);
        if (!tProjectLogs.isEmpty()) {
            this.updateProjectLog(tProjectLogs.get(0), tMessageNode);
        } else {
            this.saveProjectLog(tMessageNode);
        }
    }

    protected ProjectLog saveProjectLog(JsonNode pMessageNode) throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        ProjectLog tProjectLog = new ProjectLog();
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.traceId.toString()) != null) {
            tProjectLog.setTraceId(pMessageNode.get(ProjectLogJsonAttributeEnum.traceId.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()) != null) {
            tProjectLog.setAppId(pMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.sourceIds.toString()) != null) {
            tProjectLog.setSourceIds(pMessageNode.get(ProjectLogJsonAttributeEnum.sourceIds.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectId.toString()) != null) {
            tProjectLog.setProjectId(pMessageNode.get(ProjectLogJsonAttributeEnum.projectId.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectCardId.toString()) != null) {
            tProjectLog.setProjectCardId(pMessageNode.get(ProjectLogJsonAttributeEnum.projectCardId.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()) != null) {
            tProjectLog.setProcessSerialNumber(pMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()).asText());
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.createdTime.toString()) != null) {
                tProjectLog.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ProjectLogJsonAttributeEnum.createdTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()) != null) {
            tProjectLog.setTenantId(pMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()) != null) {
            tProjectLog.setState(pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()).asInt());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()) != null) {
            tProjectLog.setSubState(pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()).asInt());
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.personInCharge.toString()) != null) {
                tProjectLog.setPersonInCharge(pMessageNode.get(ProjectLogJsonAttributeEnum.personInCharge.toString()).asText());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.personInChargeName.toString()) != null) {
                tProjectLog.setPersonInChargeName(pMessageNode.get(ProjectLogJsonAttributeEnum.personInChargeName.toString()).asText());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()) != null) {
                JsonNode jsonNode = this.mapper.readTree(pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()).asText());
                tProjectLog.setProjectNameZhTw(jsonNode.get("zh_TW").asText());
                tProjectLog.setProjectNameZhCn(jsonNode.get("zh_CN").asText());
                tProjectLog.setProjectNameEnUs(jsonNode.get("en_US").asText());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectStartTime.toString()) != null) {
                tProjectLog.setProjectStartTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ProjectLogJsonAttributeEnum.projectStartTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectEndTime.toString()) != null) {
                tProjectLog.setProjectEndTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ProjectLogJsonAttributeEnum.projectEndTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectCode.toString()) != null) {
            tProjectLog.setProjectCode(pMessageNode.get(ProjectLogJsonAttributeEnum.projectCode.toString()).asText());
            try {
                Map<String, String> tAppNameMap = this.getAppName(pMessageNode.get("projectCode").asText(), pMessageNode.get("tenantId").asText());
                tProjectLog.setAppNameZhCn(tAppNameMap.get(LocaleEnum.ZH_CN.getType()));
                tProjectLog.setAppNameZhTw(tAppNameMap.get(LocaleEnum.ZH_TW.getType()));
                tProjectLog.setAppNameEnUs(tAppNameMap.get(LocaleEnum.EN_US.getType()));
                tProjectLog.setAppCode(tAppNameMap.get(ErrorSummaryEnum.APP_CODE.getCode()));
            }
            catch (DWHttpFailedException e) {
                String exceptionEntity = (String)e.getEntity(String.class);
                this.log.error((Object)("exceptionEntity = " + exceptionEntity), (Throwable)e);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                this.log.error((Object)("ptm\u9805\u76ee\u6d88\u606f\u53d6\u5f97\u61c9\u7528\u540d\u7a31(appName)\u5931\u6557, projectCode = " + pMessageNode.get("projectCode").asText() + "\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + pMessageNode.toString()));
            }
        }
        tProjectLog.setBuildTime(Calendar.getInstance());
        return this.projectLogDao.save(tProjectLog);
    }

    protected void updateProjectLog(ProjectLog pProjectLog, JsonNode pMessageNode) throws ParseException {
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()) != null) {
            pProjectLog.setState(pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()).asInt());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()) != null) {
            pProjectLog.setSubState(pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()).asInt());
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.completedTime.toString()) != null) {
                pProjectLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ProjectLogJsonAttributeEnum.completedTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        pProjectLog.setLastUpdateTime(Calendar.getInstance());
        this.projectLogDao.saveOrupdate(pProjectLog);
    }

    protected Map<String, String> getAppName(String pProjectCode, String pTenant) throws Exception {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty((String)"knowledgemaps.url");
        URI tKnowledgemapsTargetUri = DWURIBuilder.create((String)(tKnowledgemapsUrl + this.GET_APP_NAME_PATH + "code=" + pProjectCode)).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        tHttpGet.setHeader("token", this.getToken(pTenant));
        Map tResponseAsMap = (Map)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, Map.class);
        ArrayList tResponseAry = (ArrayList)tResponseAsMap.get("response");
        String firstObjectInResponseAry = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)((LinkedTreeMap)tResponseAry.get(0)));
        JsonNode firstObjectNode = this.mapper.readTree(firstObjectInResponseAry);
        String appCode = firstObjectNode.get(ErrorSummaryEnum.APP_CODE.getCode()).asText();
        returnMap.put(ErrorSummaryEnum.APP_CODE.getCode(), appCode);
        JsonNode langObjectNode = firstObjectNode.get(ErrorSummaryEnum.LANG.getCode());
        if (null == langObjectNode) {
            return returnMap;
        }
        JsonNode appNameObjectNode = langObjectNode.get(ErrorSummaryEnum.APP_NAME.getCode());
        if (null == appNameObjectNode) {
            return returnMap;
        }
        if (appNameObjectNode.get(LocaleEnum.ZH_CN.getType()) != null) {
            returnMap.put(LocaleEnum.ZH_CN.getType(), appNameObjectNode.get(LocaleEnum.ZH_CN.getType()).asText());
        }
        if (appNameObjectNode.get(LocaleEnum.ZH_TW.getType()) != null) {
            returnMap.put(LocaleEnum.ZH_TW.getType(), appNameObjectNode.get(LocaleEnum.ZH_TW.getType()).asText());
        }
        if (appNameObjectNode.get(LocaleEnum.EN_US.getType()) != null) {
            returnMap.put(LocaleEnum.EN_US.getType(), appNameObjectNode.get(LocaleEnum.EN_US.getType()).asText());
        }
        return returnMap;
    }

    private String getToken(String pTenant) throws Exception {
        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty((String)"knowledgemaps.url");
        URI tKnowledgemapsTargetUri = DWURIBuilder.create((String)(tKnowledgemapsUrl + this.GET_LICENSEKEY_BY_TENANTID_PATH + "?tenantId=" + pTenant)).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        Map tGetLicenseKeyResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, Map.class);
        String tSecretKey = "";
        tSecretKey = ProjectLogPtmConsumeProcessor.decodeAES((String)tGetLicenseKeyResponse.get("response"));
        String tIamUrl = DWApplicationConfigUtils.getProperty((String)"iam.url");
        URI tIamTargetUri = DWURIBuilder.create((String)(tIamUrl + this.IAM_IDENTITY_LOGIN_PATH)).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        tPost.setHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HashMap<String, String> tGetIamRequest = new HashMap<String, String>();
        tGetIamRequest.put("secretKey", tSecretKey);
        tGetIamRequest.put("identityType", "secretKey");
        tPost.setEntity((HttpEntity)new DWJsonEntity(tGetIamRequest));
        Map tGetIamResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tPost, Map.class, new DWRequestOption(false));
        this.log.info((Object)("ptm\u9805\u76ee\u6d88\u606f\u53d6\u5f97\u7528\u6236token, \u79df\u6236[" + pTenant + "], token = " + (String)tGetIamResponse.get("token")));
        return (String)tGetIamResponse.get("token");
    }

    private static String decodeAES(String secretFile) throws Exception {
        byte[] result = new byte[]{};
        String sKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        SecretKeySpec key1 = new SecretKeySpec(Hex.decodeHex((String)sKey), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, key1);
        result = cipher.doFinal(Hex.decodeHex((String)secretFile));
        return new String(result);
    }
}

