/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.api.service.processor.AbstractConsumeProcessor;
import com.digiwin.athena.itsys.dao.ProjectLogDao;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.enums.ProjectLogConditionEnum;
import com.digiwin.athena.itsys.enums.ProjectLogJsonAttributeEnum;
import com.digiwin.athena.itsys.model.ProjectLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectLogTaskengineConsumeProcessor
extends AbstractConsumeProcessor {
    @Autowired
    private ProjectLogDao projectLogDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    ObjectMapper mapper = new ObjectMapper();

    public ProjectLogTaskengineConsumeProcessor() {
        this.queueType = MessageQueueTypeEnum.PROJECT_LOG_TASKENGINE_QUEUE;
    }

    @Override
    protected void handleQueueMessage(String pMessage) throws Exception {
        JsonNode tMessageNode = this.mapper.readTree(pMessage);
        HashMap<String, String> tProjectLogCondition = new HashMap<String, String>();
        tProjectLogCondition.put(ProjectLogConditionEnum.APP_ID.toString(), tMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()).asText());
        tProjectLogCondition.put(ProjectLogConditionEnum.TENANT_ID.toString(), tMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()).asText());
        tProjectLogCondition.put(ProjectLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(), tMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()).asText());
        List<ProjectLog> tProjectLogs = this.projectLogDao.fetch(tProjectLogCondition);
        if (!tProjectLogs.isEmpty()) {
            this.updateProjectLog(tProjectLogs.get(0), tMessageNode);
        } else {
            this.saveProjectLog(tMessageNode);
        }
    }

    protected ProjectLog saveProjectLog(JsonNode pMessageNode) throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        ProjectLog tProjectLog = new ProjectLog();
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.traceId.toString()) != null) {
            tProjectLog.setTraceId(pMessageNode.get(ProjectLogJsonAttributeEnum.traceId.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.sourceIds.toString()) != null) {
            tProjectLog.setSourceIds(pMessageNode.get(ProjectLogJsonAttributeEnum.sourceIds.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()) != null) {
            tProjectLog.setAppId(pMessageNode.get(ProjectLogJsonAttributeEnum.appId.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()) != null) {
            tProjectLog.setProcessSerialNumber(pMessageNode.get(ProjectLogJsonAttributeEnum.processSerialNumber.toString()).asText());
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.createdTime.toString()) != null) {
                tProjectLog.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ProjectLogJsonAttributeEnum.createdTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()) != null) {
                JsonNode jsonNode = this.mapper.readTree(pMessageNode.get(ProjectLogJsonAttributeEnum.projectName.toString()).asText());
                tProjectLog.setProjectNameZhTw(jsonNode.get("zh_TW").asText());
                tProjectLog.setProjectNameZhCn(jsonNode.get("zh_CN").asText());
                tProjectLog.setProjectNameEnUs(jsonNode.get("en_US").asText());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.projectId.toString()) != null) {
            tProjectLog.setProjectId(pMessageNode.get(ProjectLogJsonAttributeEnum.projectId.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()) != null) {
            tProjectLog.setTenantId(pMessageNode.get(ProjectLogJsonAttributeEnum.tenantId.toString()).asText());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()) != null) {
            tProjectLog.setState(pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()).asInt());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()) != null) {
            tProjectLog.setSubState(pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()).asInt());
        }
        tProjectLog.setBuildTime(Calendar.getInstance());
        return this.projectLogDao.save(tProjectLog);
    }

    protected void updateProjectLog(ProjectLog pProjectLog, JsonNode pMessageNode) throws ParseException {
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()) != null) {
            pProjectLog.setState(pMessageNode.get(ProjectLogJsonAttributeEnum.state.toString()).asInt());
        }
        if (pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()) != null) {
            pProjectLog.setSubState(pMessageNode.get(ProjectLogJsonAttributeEnum.subState.toString()).asInt());
        }
        try {
            if (pMessageNode.get(ProjectLogJsonAttributeEnum.completedTime.toString()) != null) {
                pProjectLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(ProjectLogJsonAttributeEnum.completedTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        pProjectLog.setLastUpdateTime(Calendar.getInstance());
        this.projectLogDao.saveOrupdate(pProjectLog);
    }
}

