/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.api.service.processor.AbstractConsumeProcessor;
import com.digiwin.athena.itsys.dao.TaskLogDao;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.enums.TaskLogConditionEnum;
import com.digiwin.athena.itsys.enums.TaskLogJsonAttributeEnum;
import com.digiwin.athena.itsys.model.TaskLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskLogTaskengineConsumeProcessor
extends AbstractConsumeProcessor {
    @Autowired
    private TaskLogDao taskLogDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    ObjectMapper mapper = new ObjectMapper();

    public TaskLogTaskengineConsumeProcessor() {
        this.queueType = MessageQueueTypeEnum.TASK_LOG_TASKENGINE_QUEUE;
    }

    @Override
    protected void handleQueueMessage(String pMessage) throws Exception {
        List<TaskLog> tTaskLogs;
        JsonNode tMessageNode = this.mapper.readTree(pMessage);
        HashMap<String, String> tTaskLogCondition = new HashMap<String, String>();
        tTaskLogCondition.put(TaskLogConditionEnum.APP_ID.toString(), tMessageNode.get(TaskLogJsonAttributeEnum.appId.toString()).asText());
        tTaskLogCondition.put(TaskLogConditionEnum.TENANT_ID.toString(), tMessageNode.get(TaskLogJsonAttributeEnum.tenantId.toString()).asText());
        tTaskLogCondition.put(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(), tMessageNode.get(TaskLogJsonAttributeEnum.processSerialNumber.toString()).asText());
        if (tMessageNode.get(TaskLogJsonAttributeEnum.taskUid.toString()) != null) {
            tTaskLogCondition.put(TaskLogConditionEnum.TASK_UID.toString(), tMessageNode.get(TaskLogJsonAttributeEnum.taskUid.toString()).asText());
        }
        if (!(tTaskLogs = this.taskLogDao.fetch(tTaskLogCondition)).isEmpty()) {
            this.updateTaskLog(tTaskLogs.get(0), tMessageNode);
        } else {
            this.saveTaskLog(tMessageNode);
        }
    }

    protected TaskLog saveTaskLog(JsonNode pMessageNode) throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        TaskLog tTaskLog = new TaskLog();
        if (pMessageNode.get(TaskLogJsonAttributeEnum.traceId.toString()) != null) {
            tTaskLog.setTraceId(pMessageNode.get(TaskLogJsonAttributeEnum.traceId.toString()).asText());
        }
        if (pMessageNode.get(TaskLogJsonAttributeEnum.appId.toString()) != null) {
            tTaskLog.setAppId(pMessageNode.get(TaskLogJsonAttributeEnum.appId.toString()).asText());
        }
        if (pMessageNode.get(TaskLogJsonAttributeEnum.processSerialNumber.toString()) != null) {
            tTaskLog.setProcessSerialNumber(pMessageNode.get(TaskLogJsonAttributeEnum.processSerialNumber.toString()).asText());
        }
        if (pMessageNode.get(TaskLogJsonAttributeEnum.createdTime.toString()) != null) {
            tTaskLog.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(TaskLogJsonAttributeEnum.createdTime.toString()).asText()));
        }
        if (pMessageNode.get(TaskLogJsonAttributeEnum.completedTime.toString()) != null) {
            tTaskLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(TaskLogJsonAttributeEnum.completedTime.toString()).asText()));
        }
        if (pMessageNode.get(TaskLogJsonAttributeEnum.tenantId.toString()) != null) {
            tTaskLog.setTenantId(pMessageNode.get(TaskLogJsonAttributeEnum.tenantId.toString()).asText());
        }
        try {
            if (pMessageNode.get(TaskLogJsonAttributeEnum.taskName.toString()) != null) {
                JsonNode jsonNode = this.mapper.readTree(pMessageNode.get(TaskLogJsonAttributeEnum.taskName.toString()).asText());
                tTaskLog.setTaskNameZhTw(jsonNode.get("zh_TW").asText());
                tTaskLog.setTaskNameZhCn(jsonNode.get("zh_CN").asText());
                tTaskLog.setTaskNameEnUs(jsonNode.get("en_US").asText());
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (pMessageNode.get(TaskLogJsonAttributeEnum.taskId.toString()) != null) {
            tTaskLog.setTaskId(pMessageNode.get(TaskLogJsonAttributeEnum.taskId.toString()).asText());
        }
        if (pMessageNode.get(TaskLogJsonAttributeEnum.state.toString()) != null) {
            tTaskLog.setState(pMessageNode.get(TaskLogJsonAttributeEnum.state.toString()).asInt());
        }
        if (pMessageNode.get(TaskLogJsonAttributeEnum.taskUid.toString()) != null) {
            tTaskLog.setTaskUid(pMessageNode.get(TaskLogJsonAttributeEnum.taskUid.toString()).asText());
        }
        tTaskLog.setBuildTime(Calendar.getInstance());
        return this.taskLogDao.save(tTaskLog);
    }

    protected void updateTaskLog(TaskLog pTaskLog, JsonNode pMessageNode) throws ParseException {
        if (pMessageNode.get(TaskLogJsonAttributeEnum.state.toString()) != null) {
            pTaskLog.setState(pMessageNode.get(TaskLogJsonAttributeEnum.state.toString()).asInt());
        }
        try {
            if (pMessageNode.get(TaskLogJsonAttributeEnum.completedTime.toString()) != null) {
                pTaskLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get(TaskLogJsonAttributeEnum.completedTime.toString()).asText()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        pTaskLog.setLastUpdateTime(Calendar.getInstance());
        this.taskLogDao.saveOrupdate(pTaskLog);
    }
}

