/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.config;

import com.digiwin.app.common.DWApplicationConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableRabbit
public class RabbitConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitConfig.class);

    @Bean
    @Qualifier(value="itsysconnectionFactory")
    public ConnectionFactory itsysconnectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        connectionFactory.setHost(DWApplicationConfigUtils.getProperty((String)"mq.host"));
        connectionFactory.setPort(Integer.valueOf(DWApplicationConfigUtils.getProperty((String)"mq.amqp.ssl.port")).intValue());
        connectionFactory.setUsername(DWApplicationConfigUtils.getProperty((String)"mq.user"));
        connectionFactory.setPassword(DWApplicationConfigUtils.getProperty((String)"mq.password"));
        connectionFactory.setVirtualHost(DWApplicationConfigUtils.getProperty((String)"mq.vhost"));
        return connectionFactory;
    }

    @Bean(value={"itSysrabbitTemplate"})
    public RabbitTemplate itSysrabbitTemplate(@Qualifier(value="itsysconnectionFactory") ConnectionFactory rabbitConnectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(rabbitConnectionFactory);
        rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        return rabbitTemplate;
    }
}

