/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.ActivityLogDao;
import com.digiwin.athena.itsys.dao.impl.GenericDaoImpl;
import com.digiwin.athena.itsys.enums.ActivityLogConditionEnum;
import com.digiwin.athena.itsys.model.ActivityLog;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="itsysTransactionManager")
public class ActivityLogDaoImpl
extends GenericDaoImpl<ActivityLog, Long>
implements ActivityLogDao {
    SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd");

    public ActivityLogDaoImpl() {
        super(ActivityLog.class);
    }

    @Override
    public List<ActivityLog> fetch(Map<String, String> pConditions) {
        List tReturn = null;
        tReturn = (List)this.doHibernateQuery(pConditions);
        return tReturn;
    }

    public Object doHibernateQuery(final Map<String, String> pConditions) {
        return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ActivityLog>>(){

            public List<ActivityLog> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(ActivityLog.class);
                if (pConditions.containsKey(ActivityLogConditionEnum.TENANT_ID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"tenantId", pConditions.get(ActivityLogConditionEnum.TENANT_ID.toString())));
                }
                if (pConditions.containsKey(ActivityLogConditionEnum.APP_ID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"appId", pConditions.get(ActivityLogConditionEnum.APP_ID.toString())));
                }
                if (pConditions.containsKey(ActivityLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"processSerialNumber", pConditions.get(ActivityLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())));
                }
                if (pConditions.containsKey(ActivityLogConditionEnum.TASK_UID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"taskUid", pConditions.get(ActivityLogConditionEnum.TASK_UID.toString())));
                }
                if (pConditions.containsKey(ActivityLogConditionEnum.ACTIVITY_UID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"activityUid", pConditions.get(ActivityLogConditionEnum.ACTIVITY_UID.toString())));
                }
                if (pConditions.containsKey(ActivityLogConditionEnum.TASK_CARD_ID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"taskCardId", pConditions.get(ActivityLogConditionEnum.TASK_CARD_ID.toString())));
                }
                if (pConditions.containsKey(ActivityLogConditionEnum.TOP_ONE_RECORD.toString())) {
                    criteria.setMaxResults(1);
                }
                return criteria.list();
            }
        });
    }

    @Override
    public List<ActivityLog> getActivityLogsBySerialNumbers(final List<String> pSerialNumbers) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ActivityLog>>(){

            public List<ActivityLog> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(ActivityLog.class);
                criteria.add(Restrictions.in((String)"processSerialNumber", (Collection)pSerialNumbers));
                return criteria.list();
            }
        });
    }
}

