/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.ProjectLogDao;
import com.digiwin.athena.itsys.dao.impl.GenericDaoImpl;
import com.digiwin.athena.itsys.enums.AppTypeEnum;
import com.digiwin.athena.itsys.enums.ProjectLogConditionEnum;
import com.digiwin.athena.itsys.model.ProjectLog;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="itsysTransactionManager")
public class ProjectLogDaoImpl
extends GenericDaoImpl<ProjectLog, Long>
implements ProjectLogDao {
    SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd");

    public ProjectLogDaoImpl() {
        super(ProjectLog.class);
    }

    @Override
    public List<ProjectLog> fetch(Map<String, String> pConditions) {
        List tReturn = null;
        tReturn = (List)this.doHibernateQuery(pConditions);
        return tReturn;
    }

    public Object doHibernateQuery(final Map<String, String> pConditions) {
        return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ProjectLog>>(){

            public List<ProjectLog> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(ProjectLog.class);
                if (pConditions.containsKey("query_start_date")) {
                    try {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(ProjectLogDaoImpl.this.formatToDate.parse((String)pConditions.get("query_end_date")));
                        calendar.add(5, 1);
                        criteria.add(Restrictions.between((String)"createdTime", (Object)ProjectLogDaoImpl.this.formatToDate.parse((String)pConditions.get("query_start_date")), (Object)calendar.getTime()));
                    }
                    catch (ParseException e) {
                        ProjectLogDaoImpl.this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (pConditions.containsKey(ProjectLogConditionEnum.STATE.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"state", (Object)Integer.valueOf((String)pConditions.get(ProjectLogConditionEnum.STATE.toString()))));
                }
                if (pConditions.containsKey(ProjectLogConditionEnum.APP_ID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"appId", pConditions.get(ProjectLogConditionEnum.APP_ID.toString())));
                }
                if (pConditions.containsKey(ProjectLogConditionEnum.TENANT_ID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"tenantId", pConditions.get(ProjectLogConditionEnum.TENANT_ID.toString())));
                }
                if (pConditions.containsKey(ProjectLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"processSerialNumber", pConditions.get(ProjectLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())));
                }
                return criteria.list();
            }
        });
    }

    @Override
    public List<ProjectLog> getProjectLogsBySerialNumbers(final List<String> pSerialNumbers, final String pTenantId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ProjectLog>>(){

            public List<ProjectLog> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(ProjectLog.class);
                criteria.add((Criterion)Restrictions.eq((String)"tenantId", (Object)pTenantId));
                criteria.add(Restrictions.in((String)"processSerialNumber", (Collection)pSerialNumbers));
                return criteria.list();
            }
        });
    }

    @Override
    public List<ProjectLog> getErrorProject(final String tenantId, final Pair<Date, Date> dateRange, final String projectCode) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ProjectLog>>(){

            public List<ProjectLog> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("select distinct p.traceId as traceId,p.processSerialNumber as processSerialNumber from ProjectLog as p where  p.tenantId = :tenantId and p.appId = :appId and p.projectId = :projectId and p.state != :state  and exists(select 1 from ErrorMessage as e where e.traceId = p.traceId and e.processSerialNumber = p.processSerialNumber  and e.createdTime between :startDate and :endDate and e.isError = :isError)");
                Query tQuery = pSession.createQuery(tHqlSB.toString());
                tQuery.setResultTransformer(Transformers.aliasToBean(ProjectLog.class));
                tQuery.setParameter("tenantId", (Object)tenantId);
                tQuery.setParameter("appId", (Object)AppTypeEnum.TASKENGINE.getType());
                tQuery.setParameter("projectId", (Object)projectCode);
                tQuery.setParameter("state", (Object)3);
                tQuery.setParameter("startDate", dateRange.getLeft());
                tQuery.setParameter("endDate", dateRange.getRight());
                tQuery.setParameter("isError", (Object)true);
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public Long getSuccessProjectCnt(final String pTenantId) {
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Long>(){

            public Long doInHibernate(Session pSession) throws HibernateException {
                StringBuffer appendSql = new StringBuffer("");
                appendSql.append("select count(distinct process_serial_number) from project_log pl where tenant_id= :tenantId and state in (1,2) ");
                appendSql.append("and not exists (select id from error_log el where pl.process_serial_number = el.process_serial_number)");
                NativeQuery tQuery = pSession.createSQLQuery(appendSql.toString());
                tQuery.setParameter("tenantId", (Object)pTenantId);
                return ((BigInteger)tQuery.uniqueResult()).longValue();
            }
        });
    }

    @Override
    public List<ProjectLog> getProjectLogsByTraceId(final String pTraceId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ProjectLog>>(){

            public List<ProjectLog> doInHibernate(Session pSession) throws HibernateException {
                ArrayList<Integer> states = new ArrayList<Integer>();
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from ProjectLog where traceId=:trace_id and state in (:state)");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), ProjectLog.class);
                tQuery.setParameter("trace_id", (Object)pTraceId);
                states.add(1);
                states.add(2);
                tQuery.setParameterList("state", states);
                return tQuery.getResultList();
            }
        });
    }
}

