/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.TaskLogDao;
import com.digiwin.athena.itsys.dao.impl.GenericDaoImpl;
import com.digiwin.athena.itsys.enums.TaskLogConditionEnum;
import com.digiwin.athena.itsys.model.TaskLog;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="itsysTransactionManager")
public class TaskLogDaoImpl
extends GenericDaoImpl<TaskLog, Long>
implements TaskLogDao {
    SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd");

    public TaskLogDaoImpl() {
        super(TaskLog.class);
    }

    @Override
    public List<TaskLog> fetch(Map<String, String> pConditions) {
        List tReturn = null;
        tReturn = (List)this.doHibernateQuery(pConditions);
        return tReturn;
    }

    public Object doHibernateQuery(final Map<String, String> pConditions) {
        return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TaskLog>>(){

            public List<TaskLog> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(TaskLog.class);
                if (pConditions.containsKey(TaskLogConditionEnum.TENANT_ID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"tenantId", pConditions.get(TaskLogConditionEnum.TENANT_ID.toString())));
                }
                if (pConditions.containsKey(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"processSerialNumber", pConditions.get(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())));
                }
                if (pConditions.containsKey(TaskLogConditionEnum.APP_ID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"appId", pConditions.get(TaskLogConditionEnum.APP_ID.toString())));
                }
                if (pConditions.containsKey(TaskLogConditionEnum.TASK_UID.toString())) {
                    criteria.add((Criterion)Restrictions.eq((String)"taskUid", pConditions.get(TaskLogConditionEnum.TASK_UID.toString())));
                }
                return criteria.list();
            }
        });
    }

    @Override
    public List<TaskLog> getTaskLogsBySerialNumbers(final List<String> pSerialNumbers) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<TaskLog>>(){

            public List<TaskLog> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(TaskLog.class);
                criteria.add(Restrictions.in((String)"processSerialNumber", (Collection)pSerialNumbers));
                return criteria.list();
            }
        });
    }
}

