/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.queue.rabbitmq;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.impl.ForgivingExceptionHandler;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Consumer {
    private Log log = LogFactory.getLog(this.getClass());
    ConnectionFactory factory = new ConnectionFactory();
    Connection connection;
    Channel channel;

    public Consumer(MessageQueueTypeEnum queueType) {
        this.buildChannel(queueType);
    }

    public void buildChannel(MessageQueueTypeEnum queueType) {
        try {
            this.factory.setVirtualHost(DWApplicationConfigUtils.getProperty((String)"mq.vhost"));
            this.factory.setHost(DWApplicationConfigUtils.getProperty((String)"mq.host"));
            this.factory.setUsername(DWApplicationConfigUtils.getProperty((String)"mq.user"));
            this.factory.setPassword(DWApplicationConfigUtils.getProperty((String)"mq.password"));
            this.factory.setPort(Integer.valueOf(DWApplicationConfigUtils.getProperty((String)"mq.amqp.ssl.port")).intValue());
            this.factory.setExceptionHandler((ExceptionHandler)new ForgivingExceptionHandler());
            this.factory.setAutomaticRecoveryEnabled(true);
            this.factory.setTopologyRecoveryEnabled(true);
            this.factory.setRequestedHeartbeat(10);
            this.connection = this.factory.newConnection();
            this.channel = this.connection.createChannel();
            this.channel.basicQos(5);
            HashMap queueArguments = new HashMap();
            this.channel.queueDeclare(queueType.getQueueName(), true, false, false, queueArguments);
            this.channel.exchangeDeclare("it.sys.exchange", BuiltinExchangeType.DIRECT, true);
            this.channel.queueBind(queueType.getQueueName(), "it.sys.exchange", queueType.getBinding());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public ConnectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ConnectionFactory factory) {
        this.factory = factory;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

