/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.itsys.util.LocaleUtils;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceBundleUtil {
    protected static final Log log = LogFactory.getLog(ResourceBundleUtil.class);
    private static final String EN_US = "en_US";
    private static final String ZH_TW = "zh_TW";
    private static final String ZH_CN = "zh_CN";

    public static String getString(String key, Locale locale) {
        ResourceBundle tResourceBundle = ResourceBundle.getBundle("itsys", locale);
        log.info((Object)("\u6d4b\u8bd5\u591a\u8bed\u8a00\uff0ctResourceBundle=" + JSONObject.toJSONString((Object)tResourceBundle)));
        return tResourceBundle.getString(key);
    }

    public static String getString(String key, String locale) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return "";
        }
        Locale tLocale = LocaleUtils.convert2Locale(locale);
        log.info((Object)("\u6d4b\u8bd5\u591a\u8bed\u8a00,tLocale:" + tLocale));
        return ResourceBundleUtil.getString(key, tLocale);
    }

    public static String getJsonString(String key) {
        JSONObject result = new JSONObject(4);
        result.put(EN_US, (Object)ResourceBundleUtil.getString(key, EN_US));
        result.put(ZH_CN, (Object)ResourceBundleUtil.getString(key, ZH_CN));
        result.put(ZH_TW, (Object)ResourceBundleUtil.getString(key, ZH_TW));
        return result.toJSONString();
    }
}

