package com.digiwin.athena.itsys.api.service.impl;

import com.digiwin.athena.itsys.api.service.IProcessLogService;
import com.digiwin.athena.itsys.api.service.processor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;

public class ProcessLogService implements IProcessLogService {

	protected final Log log = LogFactory.getLog(getClass());

	@Autowired
	private ExecutionViewProcessor executionViewProcessor;

	@Autowired
	private LogCleanProcessor logCleanProcessor;

	@Autowired
	private ErrorNotificationProcessor errorNotificationProcessor;

	@Autowired
	private SummaryInfoProcessor summaryInfoProcessor;

	@Autowired
	private MonitorTimeProcessor monitorTimeProcessor;

	@Autowired
	private ProjectViewProcessor projectViewProcessor;

	@Autowired
	private GetExceptionDetailProcessor getExceptionDetailProcessor;


	@Override
	public Map<String, Object> postView(String tenantId, String sourceId, String queryStartDate, String queryEndDate,
			String condition, String ruleCode, String createdTime, String processSerialNumber) throws Exception {
		return executionViewProcessor.execute(tenantId, sourceId, queryStartDate, queryEndDate, condition, ruleCode,
				createdTime, processSerialNumber);
	}

	@Override
	public Map<String, Object> postDelete(String tenantId) throws Exception {
		return logCleanProcessor.execute(tenantId);
	}

	@Override
	public Map<String, Object> postSetUserSend(String tenantId, String userSend, String toggle) throws Exception {
		return errorNotificationProcessor.setUserSend(tenantId, userSend, toggle);
	}

	@Override
	public Map<String, Object> getBlockedSummary(Integer pageSize, Integer pageNum) throws Exception {
		return summaryInfoProcessor.execute(pageSize, pageNum);
	}

	@Override
	public Map<String, Object> getExceptionDetailById(Long errorLogId) throws Exception {
		return getExceptionDetailProcessor.execute(errorLogId, null);
	}

	@Override
	public Map<String, Object> getExceptionDetailByProcessSerialNumber(String processSerialNumber) throws Exception {
		return getExceptionDetailProcessor.execute(null, processSerialNumber);
	}

	@Override
	public Map<String, Object> postMonitorTime(String tenantId, String ruleCode, String eocId) throws Exception {
		return monitorTimeProcessor.execute(tenantId, ruleCode, eocId);
	}

	@Override
	public Map<String, Object> postCheckUserSend(String tenantId, String userId) throws Exception {
		return errorNotificationProcessor.checkUserSendInfo(tenantId, userId);
	}

	@Override
	public Map<String, Object> postProjectView(String appCode, String tmProjectCode, String tenantId,
			String queryStartDate, String queryEndDate, String condition) throws Exception {
		return projectViewProcessor.execute(appCode, tmProjectCode, tenantId, queryStartDate, queryEndDate, condition);
	}

}
