package com.digiwin.athena.itsys.api.service.processor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.constant.ItsysConstant;
import com.digiwin.athena.itsys.dao.ErrorMessageDao;
import com.digiwin.athena.itsys.dao.ErrorNotificationUserDao;
import com.digiwin.athena.itsys.dao.ErrorSummaryDao;
import com.digiwin.athena.itsys.enums.AppTypeEnum;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.model.ErrorMessage;
import com.digiwin.athena.itsys.model.ErrorNotificationUser;
import com.digiwin.athena.itsys.model.ErrorSummary;
import com.digiwin.athena.itsys.util.ResourceBundleUtil;
import com.digiwin.athena.itsys.util.StringUtil;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections.MapUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.net.URI;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class ErrorMessageConsumeProcessor extends AbstractConsumeProcessor {

    @Autowired
    private ErrorMessageDao errorMessageDao;
    @Autowired
    private ErrorSummaryDao errorSummaryDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    @Autowired
    ErrorNotificationUserDao errorNotificationUserDao;

    private String GET_LICENSEKEY_BY_TENANTID_PATH = "/restful/service/knowledgegraph/app/licenseKey";
    private String IAM_IDENTITY_LOGIN_PATH = "/api/iam/v2/identity/login";
    private String IAM_USERINROLE_PATH = "/api/iam/v2/association/userinrole";
    private String EMC_SEND_MAIL_PATH = "/api/emc/v1/message/sendEmail";
    private String IAM_USERINFO_PATH = "/api/iam/v2/tenant/user/info";
    private String USERMETADATA_USER_GET = "/api/iam/v2/usermetadata/user/get";
    private String GET_METADATA_PATH = "/restful/service/knowledgegraph/action/metadata";
    private String GET_MDC_METADATA_PATH = "/restful/standard/mdc/ApiMetadata/Get";
    private static String UNDEFINED_ERROR_CODE = "P.Itsys.500.9999";
    private ObjectMapper mapper = new ObjectMapper();

    // 配置任务引擎推送来的告警-忽略的任务code
    private static String TASKENGINE_IGNORE_TASKCODE = DWApplicationConfigUtils.getProperty("taskengine.ignore.taskCode");

    // 配置任务引擎推送来的告警-忽略的项目code
    private static String TASKENGINE_IGNORE_PROJECTCODE = DWApplicationConfigUtils.getProperty("taskengine.ignore.projectCode");

    @Autowired
    @Qualifier("itSysrabbitTemplate")
    private RabbitTemplate template;

    public ErrorMessageConsumeProcessor () {
        super();
        queueType = MessageQueueTypeEnum.ERROR_MESSAGE_QUEUE;
    }

    @Override
    public void handleQueueMessage (String pMessage) throws Exception {
        JsonNode tMessageNode = mapper.readTree(pMessage);
        if (tMessageNode.get("isError").asBoolean()) {
            saveData(tMessageNode);

            // 同步推送alarm_plt_receive_it_sys  只有新增时在推送
            template.convertAndSend("alarm.platform.exchange", "alarm.platform.error.route", pMessage);
        } else {
            updateErrorStatus(tMessageNode);
        }
    }

    /**
     * 是否过滤忽略发送
     * #29864 重新處理的流程的code不要發
     *
     * @param tMessageNode
     * @return
     */
    protected boolean isIgnoreSend (JsonNode tMessageNode) {
        try {
            // 只针对任务引擎的过滤
            String appId = tMessageNode.get("appId").asText();
            if ("taskengine".equals(appId)) {
                // 获取项目编号、任务编号、租户
                String taskCode = tMessageNode.get("custom").get("taskCode").asText();
                String projectCode = tMessageNode.get("custom").get("projectCode").asText();
                String tenantId = tMessageNode.get("tenantId").asText();

                // 获取配置的过滤任务、项目信息
                JSONArray taskCodeNode = JSONArray.parseArray(TASKENGINE_IGNORE_TASKCODE);
                // 场景1：如果满足任务编号直接过滤
                Iterator<Object> terator = taskCodeNode.iterator();
                while (terator.hasNext()) {
                    JSONObject obj = (JSONObject) terator.next();
                    if (checkIgnoreTenantId(taskCode,
                                            obj.getString("taskCodeName"),
                                            tenantId, obj.getString("tenantId"))) {
                        log.info("命中任务编号忽略发送告警");
                        return true;
                    }
                }

                // 场景2：如果满足项目编号直接过滤
                JSONArray projectCodeNode = JSONArray.parseArray(TASKENGINE_IGNORE_PROJECTCODE);
                terator = projectCodeNode.iterator();
                while (terator.hasNext()) {
                    JSONObject obj = (JSONObject) terator.next();
                    if (checkIgnoreTenantId(projectCode,
                                            obj.getString("projectCodeName"),
                                            tenantId, obj.getString("tenantId"))) {
                        log.info("命中项目编号忽略发送告警");
                        return true;
                    }
                }
            }
        } catch (Exception e) {
            log.error("get isIgnoreSend flag is error", e);
        }
        return false;
    }

    /**
     * 检查是否需要过滤对应租户
     *
     * @param codeName    编号名称
     * @param comCodeName 比对编号名称
     * @param tId         配置租户
     * @param tenantId    传入租户
     * @return
     */
    protected boolean checkIgnoreTenantId (String codeName, String comCodeName, String tId, String tenantId) {
        if (StringUtil.isNotEmpty(comCodeName) && comCodeName.equals(codeName)) {
            if (StringUtil.isEmpty(tenantId) || tId.equals(tenantId)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 保存数据
     *
     * @param pMessageNode
     * @throws Exception
     */
    protected void saveData (JsonNode pMessageNode) throws Exception {

        ErrorMessage errorMessage = new ErrorMessage();
        if (pMessageNode.get("traceId") != null) {
            errorMessage.setTraceId(pMessageNode.get("traceId").asText());
        }
        errorMessage.setAppId(pMessageNode.get("appId").asText());
        if (pMessageNode.get("processSerialNumber") != null) {
            errorMessage.setProcessSerialNumber(pMessageNode.get("processSerialNumber").asText());
        }
        if (pMessageNode.get("processActivityId") != null) {
            errorMessage.setProcessActivityId(pMessageNode.get("processActivityId").asText());
        }
        if (pMessageNode.get("processActivityOID") != null) {
            errorMessage.setProcessActivityOid(pMessageNode.get("processActivityOID").asText());
        }

        try {
            // 此異常為数据异常，有apiErrorInfo的就是數據異常
            if (pMessageNode.get("apiErrorInfo") != null) {
                errorMessage.setApiErrorInfo(pMessageNode.get("apiErrorInfo").toString());

                // 如果是數據異常則要取得對應API的元數據

                // 先根據apiErrorInfo中的name得知API名稱
                // String json = "{ \"name\": \"purchae.info.get\", \"data\": [ {
                // \"overdue_days\": \"0\", \"project_name\": \"演示项目1.0（勿动）\", \"contract_no\":
                // \"\", \"project_leader_code\": \"wfgp-02\", \"project_leader_name\":
                // \"erp财务主管\" }, { \"overdue_days\": \"0\", \"project_name\": \"演示项目1.0（勿动）\",
                // \"contract_no\": \"\", \"project_leader_code\": \"wfgp-02\",
                // \"project_leader_name\": \"erp财务主管\" }, { \"overdue_days\": \"0\",
                // \"project_name\": \"演示项目1.0（勿动）\", \"contract_no\": \"\",
                // \"project_leader_code\": \"wfgp-02\", \"project_leader_name\": \"erp财务主管\" }
                // ] }";
                JsonNode jsonNode = mapper.readTree(pMessageNode.get("apiErrorInfo").toString());

                if (jsonNode.get("name") != null) {
                    String apiName = jsonNode.get("name").asText();
                    // 取得API元數據
                    String tMetadata = getMdcMetadata(apiName);
                    JsonNode tMetadataJsonNode = mapper.readTree(tMetadata);
                    if (tMetadataJsonNode.get("execution").get("code") != null
                            && tMetadataJsonNode.get("execution").get("code").asText().matches("000")) {
                        ArrayNode stdDataFieldNode = (ArrayNode) tMetadataJsonNode.get("data").get("data_metadata")
                                .get("response_success").get("body").get("field");

                        for (JsonNode node : stdDataFieldNode) {
                            if (node.get("data_name").asText().equals("parameter")) {
                                ArrayNode parameterAryNode = (ArrayNode) node.get("field");
                                for (JsonNode paramNode : parameterAryNode) {
                                    if (paramNode.get("data_name").asText().equals("error_info")) {
                                        errorMessage.setApiErrorInfoMetadata(paramNode.get("field").toString());
                                    }
                                }
                            }
                        }
                    }

                }

            }
        } catch (DWHttpFailedException e) {
            String exceptionEntity = e.getEntity(String.class);
            log.error("exceptionEntity = " + exceptionEntity, e);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }

        if (pMessageNode.get("token") != null) {
            errorMessage.setToken(pMessageNode.get("token").asText());
        }

        if (pMessageNode.get("retryUrl") != null) {
            errorMessage.setRetryUrl(pMessageNode.get("retryUrl").toString());
        }

        if (pMessageNode.get("actionId") != null) {
            errorMessage.setActionId(pMessageNode.get("actionId").asText());
            // 如果actionId有值則要去查其冪等性
            if (pMessageNode.get("actionId").asText().length() != 0) {
                try {
                    String token = getToken(pMessageNode.get("tenantId").asText());
                    String idempotency = getIdempotency(token, pMessageNode.get("actionId").asText());
                    errorMessage.setIdempotency(Boolean.valueOf(idempotency));
                } catch (DWHttpFailedException e) {
                    String exceptionEntity = e.getEntity(String.class);
                    log.error("exceptionEntity = " + exceptionEntity, e);
                }
            }
        }

        if (pMessageNode.get("taskUid") != null) {
            errorMessage.setTaskUid(pMessageNode.get("taskUid").asText());
        }

        errorMessage.setBuildTime(Calendar.getInstance());
        errorMessage.setLastUpdateTime(Calendar.getInstance());
        errorMessage.setCreatedTime(
                new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get("createdTime").asText()));
        errorMessage.setTenantId(pMessageNode.get("tenantId").asText());
        errorMessage.setException(pMessageNode.get("exception").asText());
        if (pMessageNode.get("exceptionType") != null) {
            errorMessage.setExceptionType(pMessageNode.get("exceptionType").asText());
        }
        if (pMessageNode.get("errorCode") != null) {
            errorMessage.setErrorCode(pMessageNode.get("errorCode").asText());
        }

        errorMessage.setIsError(pMessageNode.get("isError").asBoolean());
        errorMessageDao.save(errorMessage);

        try {
            // 如果異常類型為阻塞才發送異常通知信件
            if (!StringUtil.isEmptyOrSpace(pMessageNode.get("appId"))
                    && (pMessageNode.get("appId").asText().equals(AppTypeEnum.BPMCLOUD.getType())
                    || pMessageNode.get("appId").asText().equals(AppTypeEnum.TASKENGINE.getType())
                    || pMessageNode.get("appId").asText().equals(AppTypeEnum.ATMC.getType()))) {
                // 寄異常通知信
                if (isErrorNotify(pMessageNode) && !isIgnoreSend(pMessageNode)) {
                    sendErrorNotificationEmail(pMessageNode);
                }
            }

        } catch (DWHttpFailedException e) {
            String exceptionEntity = e.getEntity(String.class);
            log.error("exceptionEntity = " + exceptionEntity, e);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    protected void updateErrorStatus (JsonNode pMessageNode) {

        List<ErrorMessage> tErrorMessageList = errorMessageDao.getByBusinessLogicKey(pMessageNode);

        if (tErrorMessageList.size() != 0 && tErrorMessageList.get(0).isError()) {
            for (ErrorMessage message : tErrorMessageList) {
                ErrorMessage tTargetError = message;
                tTargetError.setIsError(false);
                tTargetError.setLastUpdateTime(Calendar.getInstance());
                errorMessageDao.saveOrupdate(tTargetError);
            }
        }

    }

    private void sendErrorNotificationEmail (JsonNode pMessageNode) throws Exception {

//		取得該租戶要通知的使用者
        List<ErrorNotificationUser> notificationUsers = errorNotificationUserDao
                .getErrorNotificationUsersBytenantId(pMessageNode.get("tenantId").asText());

        if (notificationUsers.size() != 0) {

//			 取得token
            String token = getToken(pMessageNode.get("tenantId").asText());

            List<String> userIdList = new ArrayList<String>();

            for (ErrorNotificationUser user : notificationUsers) {
                userIdList.add(user.getUserId());
            }

//			取得使用者的郵件信箱位址
            Map<String, String> pUserIdEmailAddressMap = getUserIdEmailAddressMap(token, userIdList);

            ArrayNode emailArrayNode = mapper.createArrayNode();
            // 邮箱对应的用户id
            Map<String, String> emailToUserId = new HashMap<>();
            // 將信箱位址放入emailArrayNode
            for (String userId : pUserIdEmailAddressMap.keySet()) {
                String emailAddress = pUserIdEmailAddressMap.get(userId);
                emailArrayNode.add(emailAddress);
                emailToUserId.put(emailAddress, userId);
            }

            if (emailArrayNode.size() != 0) {

                for (JsonNode tEmailAddress : emailArrayNode) {

                    ArrayNode sendOneEmailAtATime = mapper.createArrayNode();

                    sendOneEmailAtATime.add(tEmailAddress);

                    String tEmcUrl = DWApplicationConfigUtils.getProperty("emcUrl");
                    URI tEmcTargetUri = DWURIBuilder.create(tEmcUrl + EMC_SEND_MAIL_PATH).build();
                    HttpPost tPost = new HttpPost(tEmcTargetUri);

                    // 取得租戶名稱
                    String tenantName = getTenantName(pMessageNode.get("tenantId").asText());
                    // 获取用户语言别
                    String userLang = getUserLangMetadataAllTenant(token, emailToUserId.get(tEmailAddress.asText()));

                    StringBuilder stringBuilder1 = new StringBuilder();
                    log.info("测试多语言，userLang:{}=" + userLang);
                    log.info("测试多语言，error.email.message1:{}=" + ResourceBundleUtil.getString("error.email.message1", userLang));
                    log.info("测试多语言，error.email.message3:{}=" + ResourceBundleUtil.getString("error.email.message3", userLang));
                    stringBuilder1.append(ResourceBundleUtil.getString("error.email.message1", userLang)
                                                  + pMessageNode.get("tenantId").asText() + "-" + tenantName
                                                  + ResourceBundleUtil.getString("error.email.message2", userLang)
                                                  + pMessageNode.get("createdTime").asText()
                                                  + ResourceBundleUtil.getString("error.email.message3", userLang));
                    StringBuilder stringBuilder2 = new StringBuilder();
                    // stringBuilder2.append("异常说明 : " + pMessageNode.get("exception").asText());
                    stringBuilder2.append(ResourceBundleUtil.getString("error.email.message4", userLang) + getErrorDescription(pMessageNode, userLang));

                    ObjectNode objectNode = mapper.createObjectNode();
                    objectNode.put("content", stringBuilder1.toString() + "\r" + "\r\n" + stringBuilder2.toString());
                    objectNode.put("msgType", "text");
                    objectNode.put("title", ResourceBundleUtil.getString("error.email.message5", userLang));
                    // objectNode.put("userIds", emailArrayNode);
                    objectNode.set("userIds", sendOneEmailAtATime);

                    StringEntity entity = new StringEntity(objectNode.toString(), "UTF-8");
                    entity.setContentEncoding("UTF-8");
                    tPost.setEntity(entity);
                    tPost.addHeader("Content-Type", "application/json;charset=UTF-8");
                    tPost.setHeader("digi-middleware-auth-app", ItsysConstant.IAM_APTOKEN);
                    String result = dwHttpClient.execute(tPost, String.class, new DWRequestOption(false));
                    // log.info("異常通知郵件，發送信箱 = " + emailArrayNode.toString());
                    log.info("異常通知郵件，發送信箱 = " + sendOneEmailAtATime.toString());
                    log.info("異常通知郵件，結果 = " + result);

                }

            } else {
                log.info("異常通知郵件，未找到通知人信箱資訊");
            }
        } else {
            log.info("異常通知郵件，沒有通知人故不發送");
        }

    }

    private Map<String, String> getUserInRole (String pToken) throws Exception {

        String tIamUrl = DWApplicationConfigUtils.getProperty("iamUrl");
        Map<String, String> tReturnedMap = new HashMap<String, String>();

        // DAP呼叫法
        URI tIamTargetUri = DWURIBuilder.create(tIamUrl + IAM_USERINROLE_PATH).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        Map<String, Object> tGetIamRequest = new HashMap<String, Object>();
        tGetIamRequest.put("roleId", "superadmin");
        tPost.setHeader("digi-middleware-auth-user", pToken);
        tPost.setEntity(new DWJsonEntity(tGetIamRequest));
        List<Map<String, String>> tGetIamResponse = dwHttpClient.execute(tPost, ArrayList.class, new DWRequestOption(false));

        for (Map<String, String> map : tGetIamResponse) {
            if (map.get("email") != null) {
                tReturnedMap.put(map.get("id"), map.get("email"));
            }
        }

        log.info("異常通知郵件 取得角色下的所有用户清单 = " + tReturnedMap.toString());
        return tReturnedMap;
    }

    private Map<String, String> getUserIdEmailAddressMap (String pToken, List<String> pUserIdList) throws Exception {

        String tIamUrl = DWApplicationConfigUtils.getProperty("iamUrl");
        Map<String, String> tUserIdEmailAddressMapping = new HashMap<String, String>();

        // DAP呼叫法
        URI tIamTargetUri = DWURIBuilder.create(tIamUrl + IAM_USERINFO_PATH).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        Map<String, List<String>> userIdMap = new HashMap<>();
        userIdMap.put("userIds", pUserIdList);
        tPost.setHeader("digi-middleware-auth-user", pToken);
        tPost.setHeader("digi-middleware-auth-app", ItsysConstant.IAM_APTOKEN);
        tPost.setEntity(new DWJsonEntity(userIdMap));
        Map<String, Object> tGetIamResponse = dwHttpClient.execute(tPost, HashMap.class, new DWRequestOption(false));

        List<Map<String, String>> iamReturnedUserInfo = (List<Map<String, String>>) tGetIamResponse.get("data");

        for (String userId : pUserIdList) {
            for (Map<String, String> userInfoMap : iamReturnedUserInfo) {
                if (userId.equals(userInfoMap.get("userId"))) {
                    tUserIdEmailAddressMapping.put(userId, userInfoMap.get("email"));
                }
            }
        }
        log.info("異常通知郵件，取得通知人的信箱 = " + tUserIdEmailAddressMapping.toString());
        return tUserIdEmailAddressMapping;
    }

    private String getToken (String pTenant) throws Exception {

        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty("knowledgeGraphUrl");
        URI tKnowledgemapsTargetUri = DWURIBuilder
                .create(tKnowledgemapsUrl + GET_LICENSEKEY_BY_TENANTID_PATH + "?tenantId=" + pTenant).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        Map<String, String> tGetLicenseKeyResponse = dwHttpClient.execute(tHttpGet, Map.class);

        String tSecretKey = decodeAES(tGetLicenseKeyResponse.get("response"));
        String tIamUrl = DWApplicationConfigUtils.getProperty("iamUrl");
        URI tIamTargetUri = DWURIBuilder.create(tIamUrl + IAM_IDENTITY_LOGIN_PATH).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);

        Map<String, Object> tGetIamRequest = new HashMap<String, Object>();
        tGetIamRequest.put("secretKey", tSecretKey);
        tGetIamRequest.put("identityType", "secretKey");
        tPost.setHeader("digi-middleware-auth-app", ItsysConstant.IAM_APTOKEN);
        tPost.setEntity(new DWJsonEntity(tGetIamRequest));
        Map<String, String> tGetIamResponse = dwHttpClient.execute(tPost, Map.class, new DWRequestOption(false));
        log.info("取得租戶" + pTenant + " token = " + tGetIamResponse.get("token"));
        return tGetIamResponse.get("token");

    }

    private String getTenantName (String pTenant) throws Exception {

        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty("knowledgeGraphUrl");
        URI tKnowledgemapsTargetUri = DWURIBuilder
                .create(tKnowledgemapsUrl + GET_LICENSEKEY_BY_TENANTID_PATH + "?tenantId=" + pTenant).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        Map<String, String> tGetLicenseKeyResponse = dwHttpClient.execute(tHttpGet, Map.class);

        String tSecretKey = decodeAES(tGetLicenseKeyResponse.get("response"));
        String tIamUrl = DWApplicationConfigUtils.getProperty("iamUrl");
        URI tIamTargetUri = DWURIBuilder.create(tIamUrl + IAM_IDENTITY_LOGIN_PATH).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);

        Map<String, Object> tGetIamRequest = new HashMap<String, Object>();
        tGetIamRequest.put("secretKey", tSecretKey);
        tGetIamRequest.put("identityType", "secretKey");
        tPost.setEntity(new DWJsonEntity(tGetIamRequest));
        tPost.setHeader("digi-middleware-auth-app", ItsysConstant.IAM_APTOKEN);
        Map<String, String> tGetIamResponse = dwHttpClient.execute(tPost, Map.class, new DWRequestOption(false));
        log.info("取得租戶名稱(tenantName)" + pTenant + " tenantName = " + tGetIamResponse.get("tenantName"));
        return tGetIamResponse.get("tenantName");

    }

    private String getMdcMetadata (String pApiName) throws Exception {

        String tMdcUrl = DWApplicationConfigUtils.getProperty("mdcUrl");

        // DAP呼叫法
        URI tTargetUri = DWURIBuilder.create(tMdcUrl + GET_MDC_METADATA_PATH).build();
        HttpPost tPost = new HttpPost(tTargetUri);
        tPost.setHeader("Content-Type", "application/json");

        Map<String, Object> tGetIamRequest = new HashMap<String, Object>();
        tGetIamRequest.put("api_name", pApiName);
        tPost.setEntity(new DWJsonEntity(tGetIamRequest));
        String tMdcResponse = dwHttpClient.execute(tPost, String.class);
        log.info("取得" + pApiName + "元數據：" + tMdcResponse);
        return tMdcResponse;

    }

    private String getIdempotency (String pToken, String pActionId) throws Exception {

        String tKnowledgemapsUrl = DWApplicationConfigUtils.getProperty("knowledgeGraphUrl");
        URI tKnowledgemapsTargetUri = DWURIBuilder
                .create(tKnowledgemapsUrl + GET_METADATA_PATH + "?actionId=" + "esp_" + pActionId).build();
        HttpGet tHttpGet = new HttpGet(tKnowledgemapsTargetUri);
        tHttpGet.setHeader("token", pToken);
        Map<String, Object> tGetMetaDataResponse = dwHttpClient.execute(tHttpGet, Map.class);
        Map<String, String> responseData = (Map<String, String>) tGetMetaDataResponse.get("response");

        log.info("取得冪等性，actionId = " + pActionId + " idempotency = " + responseData.get("idempotency"));
        return responseData.get("idempotency");

    }

    // AES解碼
    private static String decodeAES (String secretFile) throws Exception {
        byte[] result = new byte[0];
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        try {
            Key key1 = new SecretKeySpec(Hex.decodeHex(secretKey), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, key1);
            result = cipher.doFinal(Hex.decodeHex(secretFile));
        } catch (Exception e) {
            throw e;
        }
        return new String(result);
    }

    private String getErrorDescription (JsonNode pMessageNode, String pLocale) {

//		String pLocale = "zh_CN";

        String description = "";

        // 有error_code
        if (pMessageNode.get("errorCode") != null) {

            List<ErrorSummary> errorSummaries = errorSummaryDao
                    .getErrorSummaryByCode(pMessageNode.get("errorCode").asText());
            ErrorSummary tErrorSummary;

            // 有對應的異常分類
            if (errorSummaries != null && errorSummaries.size() != 0) {
                tErrorSummary = errorSummaries.get(0);
                switch (pLocale) {
                    case "zh_TW":
                        description = tErrorSummary.getCauseZhTw();
                        break;
                    case "zh_CN":
                        description = tErrorSummary.getCauseZhCn();
                        break;
                    case "en_US":
                        description = tErrorSummary.getCauseEnUs();
                        break;
                    default:
                        description = tErrorSummary.getCauseZhCn();
                        break;
                }
            }
            // 無對應的異常分類
            else {
                errorSummaries = errorSummaryDao.getErrorSummaryByCode(UNDEFINED_ERROR_CODE);
                tErrorSummary = errorSummaries.get(0);

                // 根據前端語系選擇回傳對應語系的異常原因
                switch (pLocale) {
                    case "zh_TW":
                        description = tErrorSummary.getCauseZhTw();
                        break;
                    case "zh_CN":
                        description = tErrorSummary.getCauseZhCn();
                        break;
                    case "en_US":
                        description = tErrorSummary.getCauseEnUs();
                        break;
                    default:
                        description = tErrorSummary.getCauseZhCn();
                        break;
                }
            }

            // 沒有error_code
        } else {

            description = pMessageNode.get("exception").asText();
        }

        return description;
    }

    /**
     * 是否需要推送邮件告警状态判断
     *
     * @param pMessageNode
     * @return
     */
    private boolean isErrorNotify (JsonNode pMessageNode) {
        // 是否需要推送消息表示 true：推送 false：不推送
        boolean flag = false;

        // 有error_code
        if (pMessageNode.get("errorCode") != null) {
            // 取得異常分類
            List<ErrorSummary> errorSummaries = errorSummaryDao
                    .getErrorSummaryByCode(pMessageNode.get("errorCode").asText());
            ErrorSummary tErrorSummary;

            // 有對應的異常分類
            if (errorSummaries != null && errorSummaries.size() != 0) {
                tErrorSummary = errorSummaries.get(0);
                // 異常分類不用寄送通知 没有关闭的进行推送消息
                if (!tErrorSummary.isShutNotification()) {
                    flag = true;
                }
            }
        }
        return flag;
    }


    private String getUserLangMetadataAllTenant (String pToken, String userId) throws Exception {

        String tIamUrl = DWApplicationConfigUtils.getProperty("iamUrl");
        Map<String, String> tUserIdEmailAddressMapping = new HashMap<String, String>();

        // DAP呼叫法
        URI tIamTargetUri = DWURIBuilder.create(tIamUrl + USERMETADATA_USER_GET).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        Map<String, Object> params = new HashMap<>();
        params.put("catalogId", "basic");
        params.put("key", "dapAcceptLanguage");
        params.put("userId", userId);
        params.put("tenantSid", 0);
        tPost.setHeader("digi-middleware-auth-user", pToken);
        tPost.setHeader("digi-middleware-auth-app", ItsysConstant.IAM_APTOKEN);
        tPost.setEntity(new DWJsonEntity(params));
        Map<String, Object> tGetIamResponse = dwHttpClient.execute(tPost, HashMap.class, new DWRequestOption(false));

        Map<String, String> iamReturnedUserInfo = (Map<String, String>) tGetIamResponse.get("data");

        String lang = "zh_CN";
        if (MapUtils.isNotEmpty(iamReturnedUserInfo) && StringUtil.isNotEmpty(iamReturnedUserInfo.get("value"))) {
            lang = iamReturnedUserInfo.get("value");
        }
        return lang;
    }

}
