package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.ExecutionLogDao;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.model.ExecutionLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

@Service
public class ExecutionLogConsumeProcessor extends AbstractConsumeProcessor {

	@Autowired
	private ExecutionLogDao executionLogDao;

	@Autowired
	protected DWHttpClient dwHttpClient;

	ObjectMapper mapper = new ObjectMapper();

	public ExecutionLogConsumeProcessor() {
		super();
		queueType = MessageQueueTypeEnum.EXECUTION_LOG_QUEUE;
	}

	@Override
	protected void handleQueueMessage(String pMessage) throws JsonParseException, JsonMappingException, IOException,
            DWHttpFailedException, URISyntaxException, ParseException {

		ObjectMapper mapper = new ObjectMapper();
		JsonNode tMessageNode = mapper.readTree(pMessage);

		saveData(tMessageNode);

	}

	protected ExecutionLog saveData(JsonNode pMessageNode)
			throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {

		ExecutionLog executionLog = new ExecutionLog();

		if (pMessageNode.get("traceId") != null) {
			executionLog.setTraceId(pMessageNode.get("traceId").asText());
		}

		if (pMessageNode.get("appId") != null) {
			executionLog.setAppId(pMessageNode.get("appId").asText());
		}

		if (pMessageNode.get("tenantId") != null) {
			executionLog.setTenantId(pMessageNode.get("tenantId").asText());
		}

		if (pMessageNode.get("actionType") != null) {
			executionLog.setActionType(pMessageNode.get("actionType").asText());
		}

		executionLog.setCreatedTime(
				new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get("createdTime").asText()));

		executionLog.setTenantId(pMessageNode.get("tenantId").asText());

		if (pMessageNode.get("processEntities") != null
				&& ((ArrayNode) pMessageNode.get("processEntities")).size() != 0) {
			executionLog.setProcessData(pMessageNode.get("processEntities").toString());
		}
		executionLog.setBuildTime(Calendar.getInstance());

		if (pMessageNode.get("state") != null) {
			executionLog.setState(pMessageNode.get("state").asBoolean());
		}

		return executionLogDao.save(executionLog);

	}

}
