package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.ProcessLogDao;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.model.ProcessLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

@Service
public class ProcessLogConsumeProcessor extends AbstractConsumeProcessor {

	@Autowired
	private ProcessLogDao processLogDao;

	@Autowired
	protected DWHttpClient dwHttpClient;

	ObjectMapper mapper = new ObjectMapper();

	public ProcessLogConsumeProcessor() {
		super();
		queueType = MessageQueueTypeEnum.PROCESS_LOG_QUEUE;
	}

	@Override
	protected void handleQueueMessage(String pMessage) throws JsonParseException, JsonMappingException, IOException,
            DWHttpFailedException, URISyntaxException, ParseException {

		ObjectMapper mapper = new ObjectMapper();
		JsonNode tMessageNode = mapper.readTree(pMessage);
		List<ProcessLog> tProcessLogList = processLogDao
				.getProcessLogsBySerialNumber(tMessageNode.get("processSerialNumber").asText());
		if (!tProcessLogList.isEmpty()) {
			updateProcessLog(tProcessLogList.get(0), tMessageNode.get("state").asInt());
		} else {
			saveProcessLog(tMessageNode);
		}
	}

	protected ProcessLog saveProcessLog(JsonNode pMessageNode)
			throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {

		ProcessLog processLog = new ProcessLog();
		if (pMessageNode.get("traceId") != null) {
			processLog.setTraceId(pMessageNode.get("traceId").asText());
		}
		if (pMessageNode.get("appId") != null) {
			processLog.setAppId(pMessageNode.get("appId").asText());
		}
		processLog.setProcessSerialNumber(pMessageNode.get("processSerialNumber").asText());
		if (pMessageNode.get("sourceIds") != null) {
			processLog.setSourceId(pMessageNode.get("sourceIds").asText());
		}

		try {

			processLog.setCreatedTime(
					new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get("createdTime").asText()));

		} catch (Exception e) {
			log.error(e.getMessage(), e);
			log.error("流程建立時間未提供/錯誤，原始訊息：" + pMessageNode.toString());
		}

		processLog.setTenantId(pMessageNode.get("tenantId").asText());

		processLog.setState(pMessageNode.get("state").asInt());

		if (pMessageNode.get("completedTime") != null) {
			processLog.setCompletedTime(
					new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get("completedTime").asText()));
		}

		processLog.setBuildTime(Calendar.getInstance());

		processLog.setLastUpdateTime(Calendar.getInstance());

		return processLogDao.save(processLog);

	}

	protected void updateProcessLog(ProcessLog pTargetProcessLog, int pState) {
		pTargetProcessLog.setState(pState);
		pTargetProcessLog.setLastUpdateTime(Calendar.getInstance());
		processLogDao.saveOrupdate(pTargetProcessLog);
	}
}
