package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.itsys.constant.ItsysConstant;
import com.digiwin.athena.itsys.dao.ErrorMessageDao;
import com.digiwin.athena.itsys.dao.ErrorSummaryDao;
import com.digiwin.athena.itsys.dao.ProcessLogDao;
import com.digiwin.athena.itsys.dao.ProjectLogDao;
import com.digiwin.athena.itsys.enums.LocaleEnum;
import com.digiwin.athena.itsys.model.ErrorMessage;
import com.digiwin.athena.itsys.model.ErrorSummary;
import com.digiwin.athena.itsys.service.LogManipulateService;
import com.digiwin.athena.itsys.util.StringUtil;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 
 * Path:[https://itsys-paas.apps.digiwincloud.com.cn/restful/service/itsys/processLog/blockedSummary]
 */
@Service
public class SummaryInfoProcessor {

	@Autowired
	private ErrorMessageDao errorMessageDao;
	@Autowired
	private ProcessLogDao processLogDao;
	@Autowired
	private ProjectLogDao projectLogDao;
	@Autowired
	private ErrorSummaryDao errorSummaryDao;
	@Autowired
	protected DWHttpClient dwHttpClient;
	@Autowired
	private LogManipulateService logManipulateService;

	private static String GET_TENANTID_FROM_TOKEN = "/api/iam/v2/identity/token/analyze";
	protected final Log log = LogFactory.getLog(getClass());
	private ObjectMapper mapper = new ObjectMapper();
	private SimpleDateFormat formatToSecond = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static String UNDEFINED_ERROR_CODE = "P.Itsys.500.9999";

	public Map<String, Object> execute(Integer pageSize, Integer pageNum)
			throws JsonParseException, JsonMappingException, IOException, DWHttpFailedException, URISyntaxException {

		// 建立summary node
		Map<String, Object> summaryrNode = new HashMap<>();
		// 建立list node
		List<Map<String, Object>> listArynode = new ArrayList();
		// 取得request header----->token
		String token = DWServiceContext.getContext().getRequestHeader().get("token").toString();
		// 取得token對應租戶ID
		String tenantId = getTenantIdByToken(token);
		// 取得該租戶所有未解決的阻塞[errorMessages]
		List<ErrorMessage> errorMessages = errorMessageDao.getErrorsByTenantId(tenantId, pageSize, pageNum);
		// 查询错误日志记录总数
		Long errorCnt = errorMessageDao.getErrorLogCnt(tenantId);
		// 取得該租戶所有的項目
		Long successProjectCnt = projectLogDao.getSuccessProjectCnt(tenantId);

		// 取得前端語系
		String tLocale;
		tLocale = (String) DWServiceContext.getContext().getRequestHeader().get(LocaleEnum.LOCALE.getType());
		if (StringUtil.isEmptyOrSpace(tLocale)) {
			tLocale = "";
		}

		// 拼接响应结果
		Set<Long> idSet = new HashSet<>();
		for (ErrorMessage errorMessage : errorMessages) {
			if (!idSet.add(errorMessage.getId())) {
				continue;
			}
			// 因为errorMessages可能存在重复的，需要去重
			Map<String, Object> blockedInfoNode = new HashMap<>();
			blockedInfoNode.put("id", errorMessage.getId());
			listArynode.add(blockedInfoNode);
			blockedInfoNode.put("type", "blocked");
			blockedInfoNode.put("startTime", formatToSecond.format(errorMessage.getCreatedTime().getTime()));
			// 沒有錯誤代號時的寫法
			// errorLogNode.put("exception", errorMessage.getException());

			// 有錯誤代號的寫法(errorMessage.getErrorCode())
			// 用錯誤代號取得對應的異常分類(tErrorSummary)
			List<ErrorSummary> errorSummaries = errorSummaryDao.getErrorSummaryByCode(errorMessage.getErrorCode());
			ErrorSummary tErrorSummary;

			// 有對應的異常分類
			if (errorSummaries != null && errorSummaries.size() != 0) {
				tErrorSummary = errorSummaries.get(0);
				// 根據前端語系選擇回傳對應語系的異常原因
				switch (tLocale) {
					case "zh_TW":
						blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhTw());
						break;
					case "zh_CN":
						blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
						break;
					case "en_US":
						blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseEnUs());
						break;
					default:
						blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
						break;
				}
			}
			// 無對應的異常分類
			else {
				errorSummaries = errorSummaryDao.getErrorSummaryByCode(UNDEFINED_ERROR_CODE);
				tErrorSummary = errorSummaries.get(0);

				// 根據前端語系選擇回傳對應語系的異常原因
				switch (tLocale) {
					case "zh_TW":
						blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhTw());
						break;
					case "zh_CN":
						blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
						break;
					case "en_US":
						blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseEnUs());
						break;
					default:
						blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
						break;
				}
			}
		}

		summaryrNode.put("success", successProjectCnt);
		summaryrNode.put("blocked", errorCnt);
		Map tReturn = new HashMap<String, String>();
		tReturn.put("summary", summaryrNode);
		tReturn.put("list", listArynode);
		return tReturn;
	}

	private String getTenantIdByToken(String pToken)
			throws URISyntaxException, DWHttpFailedException, ClientProtocolException, IOException {

		String tIamUrl = DWApplicationConfigUtils.getProperty("iamUrl");
		URI tIamTargetUri = DWURIBuilder.create(tIamUrl + GET_TENANTID_FROM_TOKEN).build();
		HttpPost tPost = new HttpPost(tIamTargetUri);
		tPost.setHeader("digi-middleware-auth-user", pToken);
		tPost.setHeader("digi-middleware-auth-app", ItsysConstant.IAM_APTOKEN);
		Map<String, String> tIamResponse = dwHttpClient.execute(tPost, Map.class, new DWRequestOption(false));
		return tIamResponse.get("tenantId");
	}

}
