package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.TaskLogDao;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.enums.TaskLogConditionEnum;
import com.digiwin.athena.itsys.enums.TaskLogJsonAttributeEnum;
import com.digiwin.athena.itsys.model.TaskLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class TaskLogTaskengineConsumeProcessor extends AbstractConsumeProcessor {

	@Autowired
	private TaskLogDao taskLogDao;

	@Autowired
	protected DWHttpClient dwHttpClient;

	ObjectMapper mapper = new ObjectMapper();

	public TaskLogTaskengineConsumeProcessor() {
		super();
		queueType = MessageQueueTypeEnum.TASK_LOG_TASKENGINE_QUEUE;
	}

	@Override
	protected void handleQueueMessage(String pMessage) throws Exception {

		JsonNode tMessageNode = mapper.readTree(pMessage);

		Map<String, String> tTaskLogCondition = new HashMap<String, String>();

		// taskengine更新taskengine的消息
		// ptm更新ptm的消息
		// 用appId判斷
		tTaskLogCondition.put(TaskLogConditionEnum.APP_ID.toString(),
				tMessageNode.get(TaskLogJsonAttributeEnum.appId.toString()).asText());

		tTaskLogCondition.put(TaskLogConditionEnum.TENANT_ID.toString(),
				tMessageNode.get(TaskLogJsonAttributeEnum.tenantId.toString()).asText());

		tTaskLogCondition.put(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString(),
				tMessageNode.get(TaskLogJsonAttributeEnum.processSerialNumber.toString()).asText());

		// taskUid不一定會有，所以要做null判斷
		if (tMessageNode.get(TaskLogJsonAttributeEnum.taskUid.toString()) != null) {
			tTaskLogCondition.put(TaskLogConditionEnum.TASK_UID.toString(),
					tMessageNode.get(TaskLogJsonAttributeEnum.taskUid.toString()).asText());
		}

		List<TaskLog> tTaskLogs = taskLogDao.fetch(tTaskLogCondition);

		if (!tTaskLogs.isEmpty()) {
			// 有對應紀錄則做更新
			updateTaskLog(tTaskLogs.get(0), tMessageNode);
		} else {
			// 無對應紀錄則做新增
			saveTaskLog(tMessageNode);
		}
	}

	protected TaskLog saveTaskLog(JsonNode pMessageNode)
			throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {

		TaskLog tTaskLog = new TaskLog();

		if (pMessageNode.get(TaskLogJsonAttributeEnum.traceId.toString()) != null) {
			tTaskLog.setTraceId(pMessageNode.get(TaskLogJsonAttributeEnum.traceId.toString()).asText());
		}

		if (pMessageNode.get(TaskLogJsonAttributeEnum.appId.toString()) != null) {
			tTaskLog.setAppId(pMessageNode.get(TaskLogJsonAttributeEnum.appId.toString()).asText());
		}

		if (pMessageNode.get(TaskLogJsonAttributeEnum.processSerialNumber.toString()) != null) {
			tTaskLog.setProcessSerialNumber(
					pMessageNode.get(TaskLogJsonAttributeEnum.processSerialNumber.toString()).asText());
		}

		if (pMessageNode.get(TaskLogJsonAttributeEnum.createdTime.toString()) != null) {
			tTaskLog.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
					.parse(pMessageNode.get(TaskLogJsonAttributeEnum.createdTime.toString()).asText()));
		}

		if (pMessageNode.get(TaskLogJsonAttributeEnum.completedTime.toString()) != null) {
			tTaskLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
					.parse(pMessageNode.get(TaskLogJsonAttributeEnum.completedTime.toString()).asText()));
		}

		if (pMessageNode.get(TaskLogJsonAttributeEnum.tenantId.toString()) != null) {
			tTaskLog.setTenantId(pMessageNode.get(TaskLogJsonAttributeEnum.tenantId.toString()).asText());
		}
		try {
			if (pMessageNode.get(TaskLogJsonAttributeEnum.taskName.toString()) != null) {
				// tTaskLog.setTaskName(pMessageNode.get(TaskLogJsonAttributeEnum.taskName.toString()).asText());

				JsonNode jsonNode = mapper
						.readTree(pMessageNode.get(TaskLogJsonAttributeEnum.taskName.toString()).asText());

				tTaskLog.setTaskNameZhTw(jsonNode.get("zh_TW").asText());
				tTaskLog.setTaskNameZhCn(jsonNode.get("zh_CN").asText());
				tTaskLog.setTaskNameEnUs(jsonNode.get("en_US").asText());
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		if (pMessageNode.get(TaskLogJsonAttributeEnum.taskId.toString()) != null) {
			tTaskLog.setTaskId(pMessageNode.get(TaskLogJsonAttributeEnum.taskId.toString()).asText());
		}

		// 任務沒有子狀態(subState)
		if (pMessageNode.get(TaskLogJsonAttributeEnum.state.toString()) != null) {
			tTaskLog.setState(pMessageNode.get(TaskLogJsonAttributeEnum.state.toString()).asInt());
		}

		if (pMessageNode.get(TaskLogJsonAttributeEnum.taskUid.toString()) != null) {
			tTaskLog.setTaskUid(pMessageNode.get(TaskLogJsonAttributeEnum.taskUid.toString()).asText());
		}

		tTaskLog.setBuildTime(Calendar.getInstance());

		return taskLogDao.save(tTaskLog);

	}

	protected void updateTaskLog(TaskLog pTaskLog, JsonNode pMessageNode) throws ParseException {

		// 狀態更新，任務沒有子狀態(subState)
		if (pMessageNode.get(TaskLogJsonAttributeEnum.state.toString()) != null) {
			pTaskLog.setState(pMessageNode.get(TaskLogJsonAttributeEnum.state.toString()).asInt());
		}

		// 項目結束時間更新
		try {
			if (pMessageNode.get(TaskLogJsonAttributeEnum.completedTime.toString()) != null) {
				pTaskLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")
						.parse(pMessageNode.get(TaskLogJsonAttributeEnum.completedTime.toString()).asText()));
			}
		} catch (Exception e) {
			log.error(e.getMessage(), e);
		}
		// 紀錄最後更新時間
		pTaskLog.setLastUpdateTime(Calendar.getInstance());

		taskLogDao.saveOrupdate(pTaskLog);
	}
}
