package com.digiwin.athena.itsys.config;

import com.digiwin.app.common.DWApplicationConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

/**
 * 后续使用springboot原生处理的话，此处的初始化操作可以都在AutoConfiguration中进行处理
 *
 * @author songwq@digiwin.com
 * @date 2023/9/4
 */
@Configuration
@EnableAspectJAutoProxy(proxyTargetClass = true)
@EnableRabbit
public class RabbitConfig {
	private static final Logger LOGGER = LoggerFactory.getLogger(RabbitConfig.class);

	@Bean
	@Qualifier("itsysconnectionFactory")
	public ConnectionFactory itsysconnectionFactory() {
		CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
		connectionFactory.setHost(DWApplicationConfigUtils.getProperty("mq.host"));
		connectionFactory.setPort(Integer.valueOf(DWApplicationConfigUtils.getProperty("mq.amqp.ssl.port")));
		connectionFactory.setUsername(DWApplicationConfigUtils.getProperty("mq.user"));
		connectionFactory.setPassword(DWApplicationConfigUtils.getProperty("mq.password"));
		connectionFactory.setVirtualHost(DWApplicationConfigUtils.getProperty("mq.vhost"));
		return connectionFactory;
	}

	@Bean("itSysrabbitTemplate")
	public RabbitTemplate itSysrabbitTemplate(@Qualifier("itsysconnectionFactory") ConnectionFactory rabbitConnectionFactory) {
		RabbitTemplate rabbitTemplate = new RabbitTemplate(rabbitConnectionFactory);
		rabbitTemplate.setMessageConverter(new Jackson2JsonMessageConverter());
		return rabbitTemplate;
	}
}
