package com.digiwin.athena.itsys.dao.impl;

import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.athena.itsys.dao.ErrorNotificationUserDao;
import com.digiwin.athena.itsys.model.ErrorNotificationUser;

@Service
@Transactional("itsysTransactionManager")
public class ErrorNotificationUserDaoImpl extends GenericDaoImpl<ErrorNotificationUser, Long>
		implements ErrorNotificationUserDao {

	public ErrorNotificationUserDaoImpl() {
		super(ErrorNotificationUser.class);
	}

	@Override
	public List<ErrorNotificationUser> getErrorNotificationUserByUserId(String pUserId) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ErrorNotificationUser>>() {
			@Override
			public List<ErrorNotificationUser> doInHibernate(Session pSession) throws HibernateException {

				StringBuilder tHqlSB = new StringBuilder();

				tHqlSB.append("from ErrorNotificationUser where userId=:user_id");

				Query<ErrorNotificationUser> tQuery = pSession.createQuery(tHqlSB.toString(),
                                                                           ErrorNotificationUser.class);

				tQuery.setParameter("user_id", pUserId);

				return tQuery.getResultList();
			}
		});

	}

	@Override
	public List<ErrorNotificationUser> getErrorNotificationUsersBytenantId(String pTenantId) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ErrorNotificationUser>>() {
			@Override
			public List<ErrorNotificationUser> doInHibernate(Session pSession) throws HibernateException {

				StringBuilder tHqlSB = new StringBuilder();

				tHqlSB.append("from ErrorNotificationUser where tenantId=:tenant_id");

				Query<ErrorNotificationUser> tQuery = pSession.createQuery(tHqlSB.toString(),
                                                                           ErrorNotificationUser.class);

				tQuery.setParameter("tenant_id", pTenantId);

				return tQuery.getResultList();
			}
		});

	}
	
	@Override
	public List<ErrorNotificationUser> getErrorNotificationUserByUserandTenantId(String pUserId, String pTenantId) {
		return getHibernateTemplate().execute(new HibernateCallback<List<ErrorNotificationUser>>() {
			@Override
			public List<ErrorNotificationUser> doInHibernate(Session pSession) throws HibernateException {

				StringBuilder tHqlSB = new StringBuilder();

				tHqlSB.append("from ErrorNotificationUser where userId=:user_id and tenantId=:tenant_id");

				Query<ErrorNotificationUser> tQuery = pSession.createQuery(tHqlSB.toString(),
                                                                           ErrorNotificationUser.class);

				tQuery.setParameter("user_id", pUserId);
				tQuery.setParameter("tenant_id", pTenantId);

				return tQuery.getResultList();
			}
		});

	}

}
