package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.TaskLogDao;
import com.digiwin.athena.itsys.enums.TaskLogConditionEnum;
import com.digiwin.athena.itsys.model.TaskLog;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;

@Service
@Transactional("itsysTransactionManager")
public class TaskLogDaoImpl extends GenericDaoImpl<TaskLog, Long> implements TaskLogDao {

	public TaskLogDaoImpl() {
		super(TaskLog.class);
	}

	SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd");

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<TaskLog> fetch(Map<String, String> pConditions) {
		List<TaskLog> tReturn = null;
		tReturn = (List<TaskLog>) doHibernateQuery(pConditions);
		return tReturn;
	}

	public Object doHibernateQuery(final Map<String, String> pConditions) {

		return getHibernateTemplate().execute(new HibernateCallback<List<TaskLog>>() {
			@Override
			public List<TaskLog> doInHibernate(Session pSession) throws HibernateException {

				Criteria criteria = pSession.createCriteria(TaskLog.class);

				if (pConditions.containsKey(TaskLogConditionEnum.TENANT_ID.toString())) {
					criteria.add(
                            Restrictions.eq("tenantId", pConditions.get(TaskLogConditionEnum.TENANT_ID.toString())));
				}

				if (pConditions.containsKey(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())) {
					criteria.add(Restrictions.eq("processSerialNumber",
                                                 pConditions.get(TaskLogConditionEnum.PROCESS_SERIAL_NUMBER.toString())));
				}

				if (pConditions.containsKey(TaskLogConditionEnum.APP_ID.toString())) {
					criteria.add(Restrictions.eq("appId", pConditions.get(TaskLogConditionEnum.APP_ID.toString())));
				}

				if (pConditions.containsKey(TaskLogConditionEnum.TASK_UID.toString())) {
					criteria.add(Restrictions.eq("taskUid", pConditions.get(TaskLogConditionEnum.TASK_UID.toString())));
				}

				return criteria.list();

			}
		});

	}

	@Override
	public List<TaskLog> getTaskLogsBySerialNumbers(List<String> pSerialNumbers) {
		return getHibernateTemplate().execute(new HibernateCallback<List<TaskLog>>() {
			@Override
			public List<TaskLog> doInHibernate(Session pSession) throws HibernateException {

				Criteria criteria = pSession.createCriteria(TaskLog.class);
				criteria.add(Restrictions.in("processSerialNumber", pSerialNumbers));
				// criteria.add(Restrictions.in("appId", "ptm"));

				return criteria.list();

			}
		});

	}
}
