package com.digiwin.athena.itsys.exception;

import com.digiwin.athena.itsys.enums.GenericStateEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseException extends Exception {

	private static final long serialVersionUID = 1L;

	private GenericStateEnum stateEnum;

	/**
	 * For exception logging
	 */
	final protected Log gLog;

	/**
	 * The Cause of this exception, could be null
	 */
	final protected Throwable gSourceException;

	/**
	 * Constructor for unchecked exception
	 * 
	 * @param pClazz
	 */
	public BaseException(Class<?> pClazz, GenericStateEnum pStateEnum) {
		super();

		setStateEnum(pStateEnum);

		this.gLog = LogFactory.getLog(pClazz);

		this.gSourceException = null;

		this.gLog.error(this.getMessage());
	}

	/**
	 * Constructor for checked exception
	 * 
	 * @param pExceptionMsg
	 * @param pClazz
	 */
	public BaseException(String pExceptionMsg, Class<?> pClazz, GenericStateEnum pStateEnum) {
		super(pExceptionMsg);

		setStateEnum(pStateEnum);

		this.gLog = LogFactory.getLog(pClazz);

		this.gSourceException = null;

		this.gLog.error(this.getMessage());
	}

	/**
	 * Constructor
	 * 
	 * @param pSrcException
	 * @param pClazz
	 */
	public BaseException(Throwable pSrcException, Class<?> pClazz, GenericStateEnum pStateEnum) {
		super(pSrcException);

		setStateEnum(pStateEnum);

		this.gLog = LogFactory.getLog(pClazz);

		this.gSourceException = pSrcException;

		this.gLog.error(this.getMessage());
	}

	/**
	 * Constructor for checked exception
	 * 
	 * @param pExceptionMsg
	 * @param pSrcException
	 * @param pClazz
	 */
	public BaseException(String pExceptionMsg, Throwable pSrcException, Class<?> pClazz, GenericStateEnum pStateEnum) {
		super(pExceptionMsg, pSrcException);

		setStateEnum(pStateEnum);

		this.gLog = LogFactory.getLog(pClazz);

		this.gSourceException = pSrcException;

		this.gLog.error(this.getMessage());
	}

	public GenericStateEnum getStateEnum() {
		return stateEnum;
	}

	public void setStateEnum(GenericStateEnum pStateEnum) {
		this.stateEnum = pStateEnum;
	}

}