package com.digiwin.athena.itsys.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * The persistent class for the standard_api database table.
 * 
 */
@Entity
@Table(name = "monitor_log")
public class MonitorLog implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "trace_id")
	@JsonProperty("trace_id")
	private String traceId;

	@Column(name = "app_name_zh_cn")
	@JsonProperty("app_name_zh_cn")
	private String appNameZhCn;

	@Column(name = "app_name_zh_tw")
	@JsonProperty("app_name_zh_tw")
	private String appNameZhTw;

	@Column(name = "app_name_en_us")
	@JsonProperty("app_name_en_us")
	private String appNameEnUs;

	@Column(name = "rule_code")
	@JsonProperty("rule_code")
	private String ruleCode;

	@Column(name = "app_code")
	@JsonProperty("app_code")
	private String appCode;

	@Column(name = "tenant_id")
	@JsonProperty("tenant_id")
	private String tenantId;

	@Column(name = "state")
	@JsonProperty("state")
	private boolean state;

	@Column(name = "detect_data")
	@JsonProperty("detect_data")
	private String detectData;

	@Column(name = "source_id_key")
	@JsonProperty("source_id_key")
	private String sourceIdKey;

	@Column(name = "source_id")
	@JsonProperty("source_id")
	private String sourceId;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "created_time")
	private Date createdTime;

	@Column(name = "detect_time")
	private Date detectTime;

	@Column(name = "exception")
	private String exception;

	@Column(name = "exception_type")
	private String exceptionType;

	@Column(name = "eoc_company_id")
	private String eocCompanyId;

	@Column(name = "eoc_site_id")
	private String eocSiteId;

	@Column(name = "eoc_region_id")
	private String eocRegionId;

	@Column(name = "initial")
	@JsonProperty("initial")
	private boolean initial;

	public MonitorLog() {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Calendar getBuildTime() {
		return this.buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getRuleCode() {
		return ruleCode;
	}

	public void setRuleCode(String ruleCode) {
		this.ruleCode = ruleCode;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public boolean isState() {
		return state;
	}

	public void setState(boolean state) {
		this.state = state;
	}

	public String getDetectData() {
		return detectData;
	}

	public void setDetectData(String detectData) {
		this.detectData = detectData;
	}

	public String getSourceId() {
		return sourceId;
	}

	public String getAppNameZhCn() {
		return appNameZhCn;
	}

	public void setAppNameZhCn(String appName) {
		this.appNameZhCn = appName;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public Date getDetectTime() {
		return detectTime;
	}

	public void setDetectTime(Date date) {
		this.detectTime = date;
	}

	public String getException() {
		return exception;
	}

	public void setException(String exception) {
		this.exception = exception;
	}

	public String getExceptionType() {
		return exceptionType;
	}

	public void setExceptionType(String exceptionType) {
		this.exceptionType = exceptionType;
	}

	public String getSourceIdKey() {
		return sourceIdKey;
	}

	public void setSourceIdKey(String sourceIdKey) {
		this.sourceIdKey = sourceIdKey;
	}

	public String getEocCompanyId() {
		return eocCompanyId;
	}

	public void setEocCompanyId(String eocCompanyId) {
		this.eocCompanyId = eocCompanyId;
	}

	public String getEocSiteId() {
		return eocSiteId;
	}

	public void setEocSiteId(String eocSiteId) {
		this.eocSiteId = eocSiteId;
	}

	public String getEocRegionId() {
		return eocRegionId;
	}

	public void setEocRegionId(String eocRegionId) {
		this.eocRegionId = eocRegionId;
	}

	public Date getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	public boolean isInitial() {
		return initial;
	}

	public void setInitial(boolean initial) {
		this.initial = initial;
	}

	public String getAppNameZhTw() {
		return appNameZhTw;
	}

	public void setAppNameZhTw(String appNameZhTw) {
		this.appNameZhTw = appNameZhTw;
	}

	public String getAppNameEnUs() {
		return appNameEnUs;
	}

	public void setAppNameEnUs(String appNameEnUs) {
		this.appNameEnUs = appNameEnUs;
	}

	public String getAppCode() {
		return appCode;
	}

	public void setAppCode(String appCode) {
		this.appCode = appCode;
	}

}