package com.digiwin.athena.itsys.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * The persistent class for the standard_api database table.
 * 
 */
@Entity
@Table(name = "process_log")
public class ProcessLog implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "trace_id")
	@JsonProperty("trace_id")
	private String traceId;

	@Column(name = "process_serial_number")
	@JsonProperty("process_serial_number")
	private String processSerialNumber;

	@Column(name = "app_id")
	@JsonProperty("app_id")
	private String appId;

	@Column(name = "tenant_id")
	@JsonProperty("tenant_id")
	private String tenantId;

	@Column(name = "state")
	@JsonProperty("state")
	private int state;

	@Column(name = "source_id")
	@JsonProperty("source_id")
	private String sourceId;

	@Column(name = "build_time")
	private Calendar buildTime;

	public Calendar getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(Calendar lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	@Column(name = "last_update_time")
	private Calendar lastUpdateTime;

	@Column(name = "created_time")
	private Date createdTime;

	@Column(name = "completed_time")
	private Date completedTime;

	public ProcessLog() {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Calendar getBuildTime() {
		return this.buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getProcessSerialNumber() {
		return processSerialNumber;
	}

	public void setProcessSerialNumber(String processSerialNumber) {
		this.processSerialNumber = processSerialNumber;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public int getState() {
		return state;
	}

	public void setState(int state) {
		this.state = state;
	}

	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	public Date getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	public Date getCompletedTime() {
		return completedTime;
	}

	public void setCompletedTime(Date completedTime) {
		this.completedTime = completedTime;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

}