package com.digiwin.athena.itsys.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

/**
 * 任務Task
 * 
 */
@Entity
@Table(name = "task_log")
public class TaskLog implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;

	@Column(name = "trace_id")
	@JsonProperty("trace_id")
	private String traceId;

	@Column(name = "process_serial_number")
	@JsonProperty("process_serial_number")
	private String processSerialNumber;

	@Column(name = "app_id")
	@JsonProperty("app_id")
	private String appId;

	@Column(name = "tenant_id")
	@JsonProperty("tenant_id")
	private String tenantId;

	@Column(name = "source_ids")
	@JsonProperty("source_ids")
	private String sourceIds;

	@Column(name = "state")
	@JsonProperty("state")
	private int state;

	@Column(name = "build_time")
	private Calendar buildTime;

	@Column(name = "last_update_time")
	private Calendar lastUpdateTime;

	@Column(name = "created_time")
	private Date createdTime;

	@Column(name = "completed_time")
	private Date completedTime;

	@Column(name = "task_name_zh_tw")
	@JsonProperty("task_name_zh_tw")
	private String taskNameZhTw;

	@Column(name = "task_name_zh_cn")
	@JsonProperty("task_name_zh_cn")
	private String taskNameZhCn;

	@Column(name = "task_name_en_us")
	@JsonProperty("task_name_en_us")
	private String taskNameEnUs;

	@Column(name = "task_uid")
	@JsonProperty("task_uid")
	private String taskUid;

	@Column(name = "task_id")
	@JsonProperty("task_id")
	private String taskId;

	@Column(name = "task_end_time")
	private Date taskEndTime;

	public TaskLog() {
	}

	public Long getId() {
		return this.id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Calendar getBuildTime() {
		return this.buildTime;
	}

	public void setBuildTime(Calendar buildTime) {
		this.buildTime = buildTime;
	}

	public String getTraceId() {
		return traceId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getProcessSerialNumber() {
		return processSerialNumber;
	}

	public void setProcessSerialNumber(String processSerialNumber) {
		this.processSerialNumber = processSerialNumber;
	}

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public int getState() {
		return state;
	}

	public void setState(int state) {
		this.state = state;
	}

	public Date getCreatedTime() {
		return createdTime;
	}

	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}

	public Date getCompletedTime() {
		return completedTime;
	}

	public void setCompletedTime(Date completedTime) {
		this.completedTime = completedTime;
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public Calendar getLastUpdateTime() {
		return lastUpdateTime;
	}

	public void setLastUpdateTime(Calendar lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	public Date getTaskEndTime() {
		return taskEndTime;
	}

	public void setTaskEndTime(Date taskEndTime) {
		this.taskEndTime = taskEndTime;
	}

	public String getTaskUid() {
		return taskUid;
	}

	public void setTaskUid(String taskUid) {
		this.taskUid = taskUid;
	}

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getTaskNameZhTw() {
		return taskNameZhTw;
	}

	public void setTaskNameZhTw(String taskNameZhTw) {
		this.taskNameZhTw = taskNameZhTw;
	}

	public String getTaskNameZhCn() {
		return taskNameZhCn;
	}

	public void setTaskNameZhCn(String taskNameZhCn) {
		this.taskNameZhCn = taskNameZhCn;
	}

	public String getTaskNameEnUs() {
		return taskNameEnUs;
	}

	public void setTaskNameEnUs(String taskNameEnUs) {
		this.taskNameEnUs = taskNameEnUs;
	}

	public String getSourceIds() {
		return sourceIds;
	}

	public void setSourceIds(String sourceIds) {
		this.sourceIds = sourceIds;
	}

}