package com.digiwin.athena.itsys.service;

import com.digiwin.athena.itsys.util.StringUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@org.springframework.stereotype.Service
public class JsonManipulateService {

	static ObjectMapper objectMapper = new ObjectMapper();
	SimpleDateFormat formatToSecond = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	static String EARLIEST_TIME = "1000-01-01 00:00:00";
	protected final Log log = LogFactory.getLog(getClass());

	/**
	 * sort json array by attribute
	 * 
	 * @throws ParseException
	 **/
	public List<Map<String, Object>> sortJsonArrayByAttribute(List<Map<String, Object>> pArrayNode, String pAttribute, boolean isReverse)
			throws ParseException {

		// 排序後的json array
		List<Map<String, Object>> sortedJsonArray = new ArrayList<>();

		List<Map<String, Object>> list = new ArrayList<>();

		// 把ObjectNode放進list
		for (int i = 0; i < pArrayNode.size(); i++) {
			list.add(pArrayNode.get(i));
		}

		Collections.sort(list, new Comparator() {

			@Override
			public int compare(Object o1, Object o2) {

				String detectTime1;
				String detectTime2;

				Date date1 = null;
				Date date2 = null;

				try {

					if (StringUtil.isEmptyOrSpace(((Map<String, Object>) o1).get(pAttribute))) {
						detectTime1 = EARLIEST_TIME;
					} else {
						detectTime1 = String.valueOf(((Map<String, Object>) o1).get(pAttribute));
					}
					if (StringUtil.isEmptyOrSpace(((Map<String, Object>) o2).get(pAttribute))) {
						detectTime2 = EARLIEST_TIME;
					} else {
						detectTime2 = String.valueOf(((Map<String, Object>) o2).get(pAttribute));
					}
					date1 = formatToSecond.parse(detectTime1);
					date2 = formatToSecond.parse(detectTime2);
					int resVal = date1.compareTo(date2);
					if (isReverse) {
						return -resVal;
					} else {
						return resVal;
					}
				} catch (ParseException e) {
					log.error(e.getMessage(), e);
				}
				return 0;
			}

		});

		for (int i = 0; i < pArrayNode.size(); i++) {
			sortedJsonArray.add(list.get(i));
		}

		return sortedJsonArray;

	}

}
