/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.impl;

import com.digiwin.athena.itsys.api.service.IDataCleanService;
import com.digiwin.athena.itsys.enums.AppTypeEnum;
import com.digiwin.athena.itsys.model.ProjectLog;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class DataCleanService
implements IDataCleanService {
    private static final Logger LOG = LoggerFactory.getLogger(DataCleanService.class);
    @Autowired
    private SessionFactory sessionFactory;
    private HibernateTemplate hibernateTemplate;

    @Override
    public String deleteErrorByAppId(final String appId, String endDate, final Integer limit) {
        try {
            final Date end = DateUtils.parseDate((String)endDate, (String[])new String[]{"yyyy-MM-dd"});
            for (int i = 0; i < 10000; ++i) {
                int deleteCount = (Integer)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            NativeQuery tQuery = pSession.createNativeQuery("delete FROM error_log where created_time < :endDate and app_id = :appId order by id limit :count");
                            tQuery.setParameter("endDate", (Object)end);
                            tQuery.setParameter("appId", (Object)appId);
                            tQuery.setParameter("count", (Object)limit);
                            Integer n = tQuery.executeUpdate();
                            return n;
                        }
                        finally {
                            tx.commit();
                        }
                    }
                });
                if (deleteCount >= limit) continue;
                return "delete success";
            }
            LOG.info("cleanErrorByAppId \u6267\u884c\u6210\u529f");
        }
        catch (ParseException e) {
            LOG.error("cleanErrorByAppId \u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        return "delete success";
    }

    @Override
    public String deleteCompleteProject(String endDate, final Integer limit) {
        try {
            final Date end = DateUtils.parseDate((String)endDate, (String[])new String[]{"yyyy-MM-dd"});
            int size = 0;
            for (int i = 0; i < 10000; ++i) {
                List projects = (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ProjectLog>>(){

                    public List<ProjectLog> doInHibernate(Session pSession) throws HibernateException {
                        StringBuilder tHqlSB = new StringBuilder();
                        tHqlSB.append("select processSerialNumber as processSerialNumber from ProjectLog where  appId = :appId and state = :state  and createdTime < :endDate order by id");
                        Query tQuery = pSession.createQuery(tHqlSB.toString());
                        tQuery.setResultTransformer(Transformers.aliasToBean(ProjectLog.class));
                        tQuery.setParameter("appId", (Object)AppTypeEnum.TASKENGINE.getType());
                        tQuery.setParameter("state", (Object)3);
                        tQuery.setParameter("endDate", (Object)end);
                        tQuery.setMaxResults(limit.intValue());
                        return tQuery.getResultList();
                    }
                });
                if (null == projects || projects.size() == 0) {
                    LOG.info("deleteCompleteProject success,deleted project size {}", (Object)size);
                    return "delete success";
                }
                final Set serialNumbers = projects.stream().map(one -> one.getProcessSerialNumber()).collect(Collectors.toSet());
                size += serialNumbers.size();
                this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            Query tQuery = pSession.createQuery("DELETE FROM ProjectLog where processSerialNumber in (:serialNumber)");
                            tQuery.setParameter("serialNumber", (Object)serialNumbers);
                            Integer n = tQuery.executeUpdate();
                            return n;
                        }
                        finally {
                            tx.commit();
                        }
                    }
                });
                this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            Query tQuery = pSession.createQuery("DELETE FROM ErrorMessage where processSerialNumber in (:serialNumber)");
                            tQuery.setParameter("serialNumber", (Object)serialNumbers);
                            Integer n = tQuery.executeUpdate();
                            return n;
                        }
                        finally {
                            tx.commit();
                        }
                    }
                });
                this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            Query tQuery = pSession.createQuery("DELETE FROM TaskLog where processSerialNumber in (:serialNumber)");
                            tQuery.setParameter("serialNumber", (Object)serialNumbers);
                            Integer n = tQuery.executeUpdate();
                            return n;
                        }
                        finally {
                            tx.commit();
                        }
                    }
                });
                this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Integer doInHibernate(Session pSession) throws HibernateException {
                        Transaction tx = pSession.beginTransaction();
                        try {
                            Query tQuery = pSession.createQuery("DELETE FROM ActivityLog where processSerialNumber in (:serialNumber)");
                            tQuery.setParameter("serialNumber", (Object)serialNumbers);
                            Integer n = tQuery.executeUpdate();
                            return n;
                        }
                        finally {
                            tx.commit();
                        }
                    }
                });
                if (serialNumbers.size() >= limit) continue;
                LOG.info("deleteCompleteProject success,deleted project size {}", (Object)size);
                return "delete success";
            }
        }
        catch (ParseException e) {
            LOG.error("deleteCompleteProject \u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        return "delete success";
    }

    public HibernateTemplate getHibernateTemplate() {
        if (null == this.hibernateTemplate) {
            this.hibernateTemplate = new HibernateTemplate(this.sessionFactory);
        }
        return this.hibernateTemplate;
    }
}

