/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.exception.BaseException;
import com.digiwin.athena.itsys.queue.rabbitmq.Consumer;
import com.digiwin.athena.itsys.validator.ValidatorResult;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConsumeProcessor {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected MessageQueueTypeEnum queueType;
    protected int consumerNumber = Integer.valueOf(DWApplicationConfigUtils.getProperty((String)"consumer.number"));

    @PostConstruct
    public Map<String, Object> execute() throws Exception {
        for (int i = 0; i < this.consumerNumber; ++i) {
            Consumer consumer = new Consumer(this.queueType);
            this.consumeQueue(this.queueType.getQueueName(), consumer);
        }
        return null;
    }

    private ValidatorResult validate(String pMsg) throws BaseException, Exception {
        return null;
    }

    protected Map<String, Object> consumeQueue(final String pQueueName, final Consumer consumer) {
        DeliverCallback deliverCallback = (consumerTag, delivery) -> {
            String message = new String(delivery.getBody(), StandardCharsets.UTF_8);
            System.out.println(" [x] Received '" + message + "'");
        };
        try {
            consumer.getChannel().basicConsume(pQueueName, false, (com.rabbitmq.client.Consumer)new DefaultConsumer(consumer.getChannel()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    String tMessage = new String(body, "UTF-8");
                    AbstractConsumeProcessor.this.log.info((Object)(pQueueName + " Message Queue Received A Message: " + tMessage));
                    try {
                        AbstractConsumeProcessor.this.handleQueueMessage(tMessage);
                    }
                    catch (Exception e) {
                        AbstractConsumeProcessor.this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        consumer.getChannel().basicAck(envelope.getDeliveryTag(), false);
                    }
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected abstract void handleQueueMessage(String var1) throws BaseException, Exception;
}

