/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.itsys.dao.ErrorSummaryDao;
import com.digiwin.athena.itsys.enums.ErrorSummaryEnum;
import com.digiwin.athena.itsys.enums.LocaleEnum;
import com.digiwin.athena.itsys.exception.ErrorSummaryFormatException;
import com.digiwin.athena.itsys.model.ErrorSummary;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErrorSummaryManagementProcessor {
    @Autowired
    private ErrorSummaryDao errorSummaryDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    protected final Log log = LogFactory.getLog(this.getClass());
    private ObjectMapper mapper = new ObjectMapper();
    private String DW_TRANSLATE_SERVICE_PATH = "/restful/service/translater/IDWTranslateService/translate";

    public Map<String, Object> execute(String data, String language, String appId) throws Exception {
        LocaleEnum tLocale;
        this.log.info((Object)("\u7570\u5e38\u5206\u985e\u63d0\u4ea4\uff0c\u63d0\u4ea4\u8a0a\u606f\uff1a" + DWServiceContext.getContext().getRequestBody()));
        JsonNode languageObject = this.mapper.readTree(language);
        ArrayList<String> convertTypesList = new ArrayList<String>();
        if (languageObject.get(LocaleEnum.LOCALE.getType()) != null && languageObject.get(LocaleEnum.LOCALE.getType()).asText().length() != 0) {
            switch (languageObject.get(LocaleEnum.LOCALE.getType()).asText()) {
                case "zh_TW": {
                    tLocale = LocaleEnum.ZH_TW;
                    break;
                }
                case "zh_CN": {
                    tLocale = LocaleEnum.ZH_CN;
                    break;
                }
                case "en_US": {
                    tLocale = LocaleEnum.EN_US;
                    break;
                }
                default: {
                    throw new ErrorSummaryFormatException("\u8acb\u586b\u5165\u6b63\u78ba\u7684\u8a9e\u7cfb", this.getClass());
                }
            }
        } else {
            throw new ErrorSummaryFormatException("\u8acb\u586b\u5165\u6b63\u78ba\u7684\u8a9e\u7cfb", this.getClass());
        }
        if (languageObject.get(ErrorSummaryEnum.CONVERT_TYPES.getCode()) != null) {
            ArrayNode convertTypesArrayNode = this.mapper.createArrayNode();
            convertTypesArrayNode = (ArrayNode)this.mapper.readTree(languageObject.get(ErrorSummaryEnum.CONVERT_TYPES.getCode()).toString());
            for (JsonNode convertType : convertTypesArrayNode) {
                convertTypesList.add(convertType.asText());
            }
        }
        ArrayNode dataArrayNode = this.mapper.createArrayNode();
        dataArrayNode = (ArrayNode)this.mapper.readTree(data);
        for (JsonNode dataNode : dataArrayNode) {
            ErrorSummary tErrorSummary = new ErrorSummary();
            List<ErrorSummary> errorSummaries = this.errorSummaryDao.getErrorSummaryByCode(dataNode.get(ErrorSummaryEnum.CODE.getCode()).asText());
            if (errorSummaries != null && errorSummaries.size() != 0) {
                tErrorSummary = errorSummaries.get(0);
            } else {
                tErrorSummary.setCode(dataNode.get(ErrorSummaryEnum.CODE.getCode()).asText());
                tErrorSummary.setAppId(appId);
            }
            switch (tLocale.getType()) {
                case "zh_TW": {
                    tErrorSummary.setCauseZhTw(dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText());
                    break;
                }
                case "zh_CN": {
                    tErrorSummary.setCauseZhCn(dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText());
                    break;
                }
                case "en_US": {
                    tErrorSummary.setCauseEnUs(dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText());
                    break;
                }
            }
            Object object = convertTypesList.iterator();
            block30: while (object.hasNext()) {
                String convertType;
                switch (convertType = (String)object.next()) {
                    case "zh2Hant": {
                        if (tLocale != LocaleEnum.ZH_CN) {
                            throw new ErrorSummaryFormatException("\u8acb\u586b\u5165\u6b63\u78ba\u7684\u8a9e\u7cfb\u8f49\u63db\u985e\u578b\uff0cconvertTypes\uff1a\uff08\u4e2d\u8f6c\u7e41 \uff1azh2Hant\uff0c\u4e2d\u8f6c\u82f1 \uff1azh2En \uff09", this.getClass());
                        }
                        String translateResult = this.localeTranslate(dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText(), tLocale, convertType);
                        tErrorSummary.setCauseZhTw(translateResult);
                        continue block30;
                    }
                    case "zh2En": {
                        if (tLocale != LocaleEnum.ZH_CN) {
                            throw new ErrorSummaryFormatException("\u8acb\u586b\u5165\u6b63\u78ba\u7684\u8a9e\u7cfb\u8f49\u63db\u985e\u578b\uff0cconvertTypes\uff1a\uff08\u4e2d\u8f6c\u7e41 \uff1azh2Hant\uff0c\u4e2d\u8f6c\u82f1 \uff1azh2En \uff09", this.getClass());
                        }
                        String translateResult = this.localeTranslate(dataNode.get(ErrorSummaryEnum.ERROR_CAUSE.getCode()).asText(), tLocale, convertType);
                        tErrorSummary.setCauseEnUs(translateResult);
                        continue block30;
                    }
                }
                throw new ErrorSummaryFormatException("\u8acb\u586b\u5165\u6b63\u78ba\u7684\u8a9e\u7cfb\u8f49\u63db\u985e\u578b\uff0cconvertTypes\uff1a\uff08\u4e2d\u8f6c\u7e41 \uff1azh2Hant\uff0c\u4e2d\u8f6c\u82f1 \uff1azh2En \uff09", this.getClass());
            }
            this.errorSummaryDao.save(tErrorSummary);
            this.log.info((Object)("Save error summary, error code\uff1a" + tErrorSummary.getCode()));
        }
        this.log.info((Object)(appId + "\u7570\u5e38\u5206\u985e\u63d0\u4ea4\u6210\u529f"));
        HashMap<String, Object> tReturn = new HashMap<String, Object>();
        tReturn.put("result", appId + "\u7570\u5e38\u5206\u985e\u63d0\u4ea4\u6210\u529f");
        return tReturn;
    }

    private String localeTranslate(String content, LocaleEnum locale, String convertType) throws Exception {
        String tTranslateCenterUrl = DWApplicationConfigUtils.getProperty((String)"translaterUrl");
        URI tTranslateCenterUri = DWURIBuilder.create((String)(tTranslateCenterUrl + this.DW_TRANSLATE_SERVICE_PATH)).build();
        HttpPost tPost = new HttpPost(tTranslateCenterUri);
        ArrayNode convertTypesArrayNode = this.mapper.createArrayNode();
        convertTypesArrayNode.add(convertType);
        ObjectNode objectNode = this.mapper.createObjectNode();
        objectNode.put("content", content);
        objectNode.set("convertTypes", (JsonNode)convertTypesArrayNode);
        StringEntity entity = new StringEntity(objectNode.toString(), "UTF-8");
        entity.setContentEncoding("UTF-8");
        tPost.setEntity((HttpEntity)entity);
        tPost.addHeader("Content-Type", "application/json;charset=UTF-8");
        String result = (String)this.dwHttpClient.execute((HttpUriRequest)tPost, String.class, new DWRequestOption(false));
        JsonNode responseObject = this.mapper.readTree(result);
        return responseObject.get("response").get("data").get(convertType).asText();
    }
}

