/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.dao.MonitorLogDao;
import com.digiwin.athena.itsys.dao.ProcessLogDao;
import com.digiwin.athena.itsys.enums.EocLevelEnum;
import com.digiwin.athena.itsys.model.MonitorLog;
import com.digiwin.athena.itsys.model.ProcessLog;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitorTimeProcessor {
    @Autowired
    private ProcessLogDao processLogDao;
    @Autowired
    private MonitorLogDao monitorLogDao;
    protected final Log log = LogFactory.getLog(this.getClass());
    ObjectMapper mapper = new ObjectMapper();
    private SimpleDateFormat formatToSecond = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Map<String, Object> execute(String tenantId, String ruleCode, String eocId) throws JsonParseException, JsonMappingException, IOException, ParseException, DWHttpFailedException, URISyntaxException {
        MonitorLog tRecentFinishedLog;
        List<MonitorLog> recentFinishedInitialLogs;
        List<MonitorLog> recentFinishedLogs;
        List<MonitorLog> recentInitialLogs;
        ObjectNode outerNode = this.mapper.createObjectNode();
        ArrayNode detectDataNode = this.mapper.createArrayNode();
        JsonNode eocIdObject = this.mapper.readTree(eocId);
        HashMap<String, String> eocConditionMap = new HashMap<String, String>();
        if (eocIdObject.get("eocCompanyId") != null && eocIdObject.get("eocCompanyId").asText().length() != 0) {
            eocConditionMap.put(EocLevelEnum.COMPANY.getLevel(), eocIdObject.get("eocCompanyId").asText());
        }
        if (eocIdObject.get("eocSiteId") != null && eocIdObject.get("eocSiteId").asText().length() != 0) {
            eocConditionMap.put(EocLevelEnum.SITE.getLevel(), eocIdObject.get("eocSiteId").asText());
        }
        if (eocIdObject.get("eocRegionId") != null && eocIdObject.get("eocRegionId").asText().length() != 0) {
            eocConditionMap.put(EocLevelEnum.REGION.getLevel(), eocIdObject.get("eocRegionId").asText());
        }
        if (!(recentInitialLogs = this.monitorLogDao.getRecentInitialLog(tenantId, ruleCode, eocConditionMap)).isEmpty()) {
            MonitorLog tRecentInitialLog = recentInitialLogs.get(0);
            outerNode.put("executingMonitorStartTime", this.formatToSecond.format(tRecentInitialLog.getDetectTime().getTime()));
        }
        if (!(recentFinishedLogs = this.monitorLogDao.getRecentFinishedLog(tenantId, ruleCode, eocConditionMap)).isEmpty() && !(recentFinishedInitialLogs = this.monitorLogDao.getInitialLogByTraceId((tRecentFinishedLog = recentFinishedLogs.get(0)).getTraceId())).isEmpty()) {
            MonitorLog tRecentFinishedInitialLog = recentFinishedInitialLogs.get(0);
            List<ProcessLog> processLogs = this.processLogDao.getProcessLogsByTraceId(tRecentFinishedLog.getTraceId());
            if (!processLogs.isEmpty()) {
                Collections.sort(processLogs, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((ProcessLog)o1).getCreatedTime().compareTo(((ProcessLog)o2).getCreatedTime());
                    }
                });
                Date d1 = tRecentFinishedInitialLog.getDetectTime();
                Date d2 = processLogs.get(processLogs.size() - 1).getCreatedTime();
                long seconds = (d2.getTime() - d1.getTime()) / 1000L;
                outerNode.put("lastMonitorExecutionTimeInSecond", seconds);
            } else {
                Date d1 = tRecentFinishedInitialLog.getDetectTime();
                Date d2 = tRecentFinishedLog.getCreatedTime();
                long seconds = (d2.getTime() - d1.getTime()) / 1000L;
                outerNode.put("lastMonitorExecutionTimeInSecond", seconds);
            }
            if (tRecentFinishedLog.getDetectData() != null) {
                detectDataNode = (ArrayNode)this.mapper.readTree(tRecentFinishedLog.getDetectData());
            }
        }
        outerNode.set("detectData", (JsonNode)detectDataNode);
        HashMap<String, Object> tReturn = new HashMap<String, Object>();
        tReturn.put("result", outerNode.toString());
        return tReturn;
    }
}

