/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.athena.itsys.api.service.processor.AbstractConsumeProcessor;
import com.digiwin.athena.itsys.dao.ProcessLogDao;
import com.digiwin.athena.itsys.enums.MessageQueueTypeEnum;
import com.digiwin.athena.itsys.model.ProcessLog;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessLogConsumeProcessor
extends AbstractConsumeProcessor {
    @Autowired
    private ProcessLogDao processLogDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    ObjectMapper mapper = new ObjectMapper();

    public ProcessLogConsumeProcessor() {
        this.queueType = MessageQueueTypeEnum.PROCESS_LOG_QUEUE;
    }

    @Override
    protected void handleQueueMessage(String pMessage) throws JsonParseException, JsonMappingException, IOException, DWHttpFailedException, URISyntaxException, ParseException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode tMessageNode = mapper.readTree(pMessage);
        List<ProcessLog> tProcessLogList = this.processLogDao.getProcessLogsBySerialNumber(tMessageNode.get("processSerialNumber").asText());
        if (!tProcessLogList.isEmpty()) {
            this.updateProcessLog(tProcessLogList.get(0), tMessageNode.get("state").asInt());
        } else {
            this.saveProcessLog(tMessageNode);
        }
    }

    protected ProcessLog saveProcessLog(JsonNode pMessageNode) throws DWHttpFailedException, ClientProtocolException, URISyntaxException, IOException, ParseException {
        ProcessLog processLog = new ProcessLog();
        if (pMessageNode.get("traceId") != null) {
            processLog.setTraceId(pMessageNode.get("traceId").asText());
        }
        if (pMessageNode.get("appId") != null) {
            processLog.setAppId(pMessageNode.get("appId").asText());
        }
        processLog.setProcessSerialNumber(pMessageNode.get("processSerialNumber").asText());
        if (pMessageNode.get("sourceIds") != null) {
            processLog.setSourceId(pMessageNode.get("sourceIds").asText());
        }
        try {
            processLog.setCreatedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get("createdTime").asText()));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            this.log.error((Object)("\u6d41\u7a0b\u5efa\u7acb\u6642\u9593\u672a\u63d0\u4f9b/\u932f\u8aa4\uff0c\u539f\u59cb\u8a0a\u606f\uff1a" + pMessageNode.toString()));
        }
        processLog.setTenantId(pMessageNode.get("tenantId").asText());
        processLog.setState(pMessageNode.get("state").asInt());
        if (pMessageNode.get("completedTime") != null) {
            processLog.setCompletedTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(pMessageNode.get("completedTime").asText()));
        }
        processLog.setBuildTime(Calendar.getInstance());
        processLog.setLastUpdateTime(Calendar.getInstance());
        return this.processLogDao.save(processLog);
    }

    protected void updateProcessLog(ProcessLog pTargetProcessLog, int pState) {
        pTargetProcessLog.setState(pState);
        pTargetProcessLog.setLastUpdateTime(Calendar.getInstance());
        this.processLogDao.saveOrupdate(pTargetProcessLog);
    }
}

