/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.api.service.processor;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.itsys.dao.ErrorMessageDao;
import com.digiwin.athena.itsys.dao.ErrorSummaryDao;
import com.digiwin.athena.itsys.dao.ProcessLogDao;
import com.digiwin.athena.itsys.dao.ProjectLogDao;
import com.digiwin.athena.itsys.enums.LocaleEnum;
import com.digiwin.athena.itsys.model.ErrorMessage;
import com.digiwin.athena.itsys.model.ErrorSummary;
import com.digiwin.athena.itsys.service.LogManipulateService;
import com.digiwin.athena.itsys.util.StringUtil;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SummaryInfoProcessor {
    @Autowired
    private ErrorMessageDao errorMessageDao;
    @Autowired
    private ProcessLogDao processLogDao;
    @Autowired
    private ProjectLogDao projectLogDao;
    @Autowired
    private ErrorSummaryDao errorSummaryDao;
    @Autowired
    protected DWHttpClient dwHttpClient;
    @Autowired
    private LogManipulateService logManipulateService;
    private static String GET_TENANTID_FROM_TOKEN = "/api/iam/v2/identity/token/analyze";
    protected final Log log = LogFactory.getLog(this.getClass());
    private ObjectMapper mapper = new ObjectMapper();
    private SimpleDateFormat formatToSecond = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String UNDEFINED_ERROR_CODE = "P.Itsys.500.9999";

    public Map<String, Object> execute(Integer pageSize, Integer pageNum) throws JsonParseException, JsonMappingException, IOException, DWHttpFailedException, URISyntaxException {
        HashMap<String, Long> summaryrNode = new HashMap<String, Long>();
        ArrayList listArynode = new ArrayList();
        String token = DWServiceContext.getContext().getRequestHeader().get("token").toString();
        String tenantId = this.getTenantIdByToken(token);
        List<ErrorMessage> errorMessages = this.errorMessageDao.getErrorsByTenantId(tenantId, pageSize, pageNum);
        Long errorCnt = this.errorMessageDao.getErrorLogCnt(tenantId);
        Long successProjectCnt = this.projectLogDao.getSuccessProjectCnt(tenantId);
        String tLocale = (String)DWServiceContext.getContext().getRequestHeader().get(LocaleEnum.LOCALE.getType());
        if (StringUtil.isEmptyOrSpace(tLocale)) {
            tLocale = "";
        }
        HashSet<Long> idSet = new HashSet<Long>();
        block20: for (ErrorMessage errorMessage : errorMessages) {
            ErrorSummary tErrorSummary;
            if (!idSet.add(errorMessage.getId())) continue;
            HashMap<String, Object> blockedInfoNode = new HashMap<String, Object>();
            blockedInfoNode.put("id", errorMessage.getId());
            listArynode.add(blockedInfoNode);
            blockedInfoNode.put("type", "blocked");
            blockedInfoNode.put("startTime", this.formatToSecond.format(errorMessage.getCreatedTime().getTime()));
            List<ErrorSummary> errorSummaries = this.errorSummaryDao.getErrorSummaryByCode(errorMessage.getErrorCode());
            if (errorSummaries != null && errorSummaries.size() != 0) {
                tErrorSummary = errorSummaries.get(0);
                switch (tLocale) {
                    case "zh_TW": {
                        blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhTw());
                        break;
                    }
                    case "zh_CN": {
                        blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
                        break;
                    }
                    case "en_US": {
                        blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseEnUs());
                        break;
                    }
                    default: {
                        blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
                        break;
                    }
                }
                continue;
            }
            errorSummaries = this.errorSummaryDao.getErrorSummaryByCode(UNDEFINED_ERROR_CODE);
            tErrorSummary = errorSummaries.get(0);
            switch (tLocale) {
                case "zh_TW": {
                    blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhTw());
                    continue block20;
                }
                case "zh_CN": {
                    blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
                    continue block20;
                }
                case "en_US": {
                    blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseEnUs());
                    continue block20;
                }
            }
            blockedInfoNode.put("exceptionSummary", tErrorSummary.getCauseZhCn());
        }
        summaryrNode.put("success", successProjectCnt);
        summaryrNode.put("blocked", errorCnt);
        HashMap<String, Object> tReturn = new HashMap<String, Object>();
        tReturn.put("summary", summaryrNode);
        tReturn.put("list", listArynode);
        return tReturn;
    }

    private String getTenantIdByToken(String pToken) throws URISyntaxException, DWHttpFailedException, ClientProtocolException, IOException {
        String tIamUrl = DWApplicationConfigUtils.getProperty((String)"iamUrl");
        URI tIamTargetUri = DWURIBuilder.create((String)(tIamUrl + GET_TENANTID_FROM_TOKEN)).build();
        HttpPost tPost = new HttpPost(tIamTargetUri);
        tPost.setHeader("digi-middleware-auth-user", pToken);
        tPost.setHeader("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        Map tIamResponse = (Map)this.dwHttpClient.execute((HttpUriRequest)tPost, Map.class, new DWRequestOption(false));
        return (String)tIamResponse.get("tenantId");
    }
}

