/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.ErrorMessageDao;
import com.digiwin.athena.itsys.dao.impl.GenericDaoImpl;
import com.digiwin.athena.itsys.enums.AppTypeEnum;
import com.digiwin.athena.itsys.model.ErrorMessage;
import com.digiwin.athena.itsys.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="itsysTransactionManager")
public class ErrorMessageDaoImpl
extends GenericDaoImpl<ErrorMessage, Long>
implements ErrorMessageDao {
    SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public ErrorMessageDaoImpl() {
        super(ErrorMessage.class);
    }

    @Override
    public List<ErrorMessage> fetch(Map<String, String> pConditions) {
        List tReturn = null;
        tReturn = (List)this.doHibernateQuery(pConditions);
        return tReturn;
    }

    public Object doHibernateQuery(final Map<String, String> pConditions) {
        Object tReturn = null;
        tReturn = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                ArrayList<String> conditionList = new ArrayList<String>();
                tHqlSB.append("select id as id,traceId as traceId,appId as appId,processSerialNumber as processSerialNumber,processActivityId as processActivityId,retryUrl as retryUrl,token as token,processActivityOid as processActivityOid,tenantId as tenantId,exceptionType as exceptionType,errorCode as errorCode,isError as isError,buildTime as buildTime,lastUpdateTime as lastUpdateTime,createdTime as createdTime,idempotency as idempotency,taskUid as taskUid,actionId as actionId,apiErrorInfo as apiErrorInfo,apiErrorInfoMetadata as apiErrorInfoMetadata from ErrorMessage where createdTime >= :query_start_date AND createdTime <= :query_end_date and tenantId=:tenant_id and isError = :is_error and appId in (:app_id)");
                Query tQuery = pSession.createQuery(tHqlSB.toString());
                tQuery.setResultTransformer(Transformers.aliasToBean(ErrorMessage.class));
                if (pConditions.containsKey("tenant_id")) {
                    tQuery.setParameter("tenant_id", pConditions.get("tenant_id"));
                }
                if (pConditions.containsKey("query_start_date")) {
                    try {
                        tQuery.setParameter("query_start_date", (Object)ErrorMessageDaoImpl.this.formatToDate.parse((String)pConditions.get("query_start_date") + " 00:00:00.000"));
                        tQuery.setParameter("query_end_date", (Object)ErrorMessageDaoImpl.this.formatToDate.parse((String)pConditions.get("query_end_date") + " 23:59:59.999"));
                    }
                    catch (ParseException e) {
                        ErrorMessageDaoImpl.this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (pConditions.containsKey("condition")) {
                    switch ((String)pConditions.get("condition")) {
                        case "stuck": {
                            conditionList.add(AppTypeEnum.TASKENGINE.getType());
                            conditionList.add(AppTypeEnum.ATMC.getType());
                            tQuery.setParameterList("app_id", conditionList);
                            break;
                        }
                        case "solving": {
                            conditionList.add(AppTypeEnum.ATMC.getType());
                            tQuery.setParameterList("app_id", conditionList);
                            break;
                        }
                        case "total": {
                            conditionList.add(AppTypeEnum.TASKENGINE.getType());
                            conditionList.add(AppTypeEnum.ATMC.getType());
                            tQuery.setParameterList("app_id", conditionList);
                            break;
                        }
                    }
                }
                if (pConditions.containsKey("is_error")) {
                    tQuery.setParameter("is_error", (Object)Boolean.valueOf(((String)pConditions.get("is_error")).toString()));
                }
                return tQuery.getResultList();
            }
        });
        return tReturn;
    }

    @Override
    public List<ErrorMessage> getByBusinessLogicKey(final JsonNode tErrorMessage) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ErrorMessage>>(){

            public List<ErrorMessage> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from ErrorMessage where (traceId=:traceId and processSerialNumber=:processSerialNumber and processActivityOid=:processActivityOID)");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), ErrorMessage.class);
                tQuery.setParameter("traceId", (Object)tErrorMessage.get("traceId").asText()).setParameter("processSerialNumber", (Object)tErrorMessage.get("processSerialNumber").asText()).setParameter("processActivityOID", (Object)tErrorMessage.get("processActivityOID").asText());
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public List<ErrorMessage> getErrorsBySerialNumber(final String pProcessSerialNumber) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ErrorMessage>>(){

            public List<ErrorMessage> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from ErrorMessage where processSerialNumber=:processSerialNumber and isError = :is_error");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), ErrorMessage.class);
                tQuery.setParameter("processSerialNumber", (Object)pProcessSerialNumber).setParameter("is_error", (Object)true);
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public List<ErrorMessage> getErrorsBySerialNumbers(final List<String> pProcessSerialNumbers, final String pTenantId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ErrorMessage>>(){

            public List<ErrorMessage> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(ErrorMessage.class);
                criteria.add((Criterion)Restrictions.eq((String)"tenantId", (Object)pTenantId));
                criteria.add(Restrictions.in((String)"isError", (Object[])new Object[]{true}));
                criteria.add(Restrictions.in((String)"processSerialNumber", (Collection)pProcessSerialNumbers));
                return criteria.list();
            }
        });
    }

    @Override
    public void deleteErrorsByTenantId(final String pTenantId) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session pSession) throws HibernateException {
                Query tQuery = pSession.createQuery("delete ErrorMessage where tenantId =:tenantId");
                tQuery.setParameter("tenantId", (Object)pTenantId);
                return tQuery.executeUpdate();
            }
        });
    }

    @Override
    public List<ErrorMessage> getErrorsByTenantId(final String pTenantId, final Integer pageSize, final Integer pageNum) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ErrorMessage>>(){

            public List<ErrorMessage> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("select id as id,traceId as traceId,appId as appId,processSerialNumber as processSerialNumber,processActivityId as processActivityId,retryUrl as retryUrl,token as token,processActivityOid as processActivityOid,tenantId as tenantId,exceptionType as exceptionType,errorCode as errorCode,isError as isError,buildTime as buildTime,lastUpdateTime as lastUpdateTime,createdTime as createdTime,idempotency as idempotency,taskUid as taskUid,actionId as actionId,apiErrorInfo as apiErrorInfo,apiErrorInfoMetadata as apiErrorInfoMetadata from ErrorMessage where tenantId=:tenant_id and isError = :is_error and (appId = :app_id2 or appId = :app_id3) order by id desc");
                Query tQuery = pSession.createQuery(tHqlSB.toString());
                tQuery.setResultTransformer(Transformers.aliasToBean(ErrorMessage.class));
                tQuery.setParameter("tenant_id", (Object)pTenantId);
                tQuery.setParameter("app_id2", (Object)AppTypeEnum.TASKENGINE.getType());
                tQuery.setParameter("app_id3", (Object)AppTypeEnum.ATMC.getType());
                tQuery.setParameter("is_error", (Object)true);
                if (null != pageNum && null != pageSize) {
                    tQuery.setFirstResult((pageNum - 1) * pageSize);
                    tQuery.setMaxResults(pageSize.intValue());
                }
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public List<ErrorMessage> getErrorBySerialNumberAndActivityOid(final String pSerailNumber, final String pActivityOid) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ErrorMessage>>(){

            public List<ErrorMessage> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from ErrorMessage where isError = :is_error and (processSerialNumber=:processSerialNumber and processActivityOid=:processActivityOID)");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), ErrorMessage.class);
                tQuery.setParameter("processSerialNumber", (Object)pSerailNumber).setParameter("processActivityOID", (Object)pActivityOid).setParameter("is_error", (Object)true);
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public ErrorMessage getExceptionDetail(final Long errorLogId, final String processSerialNumber) {
        return (ErrorMessage)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<ErrorMessage>(){

            public ErrorMessage doInHibernate(Session pSession) throws HibernateException {
                List errorMessageList;
                StringBuffer appendSql = new StringBuffer();
                appendSql.append("from ErrorMessage as em where isError = 1 ");
                if (null != errorLogId) {
                    appendSql.append("and em.id =:id ");
                }
                if (!StringUtil.isEmpty(processSerialNumber)) {
                    appendSql.append("and em.processSerialNumber =:processSerialNumber ");
                }
                Query tQuery = pSession.createQuery(appendSql.toString());
                if (null != errorLogId) {
                    tQuery.setParameter("id", (Object)errorLogId);
                }
                if (!StringUtil.isEmpty(processSerialNumber)) {
                    tQuery.setParameter("processSerialNumber", (Object)processSerialNumber);
                }
                if (null != (errorMessageList = tQuery.list()) && errorMessageList.size() > 0) {
                    return (ErrorMessage)errorMessageList.get(0);
                }
                return null;
            }
        });
    }

    @Override
    public Long getErrorLogCnt(final String pTenantId) {
        return (Long)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Long>(){

            public Long doInHibernate(Session pSession) throws HibernateException {
                StringBuffer appendSql = new StringBuffer();
                appendSql.append("select ");
                appendSql.append("count(distinct el.id) cnt ");
                appendSql.append("from ");
                appendSql.append("error_log el ");
                appendSql.append("left join project_log pl on ");
                appendSql.append("el.process_serial_number = pl.process_serial_number ");
                appendSql.append("and el.tenant_id = pl.tenant_id ");
                appendSql.append("where ");
                appendSql.append("el.tenant_id = :tenantId ");
                appendSql.append("and is_error = true ");
                appendSql.append("and (el.app_id = :appId1 ");
                appendSql.append("or el.app_id = :appId2)");
                NativeQuery tQuery = pSession.createSQLQuery(appendSql.toString());
                tQuery.setParameter("tenantId", (Object)pTenantId);
                tQuery.setParameter("appId1", (Object)AppTypeEnum.TASKENGINE.getType());
                tQuery.setParameter("appId2", (Object)AppTypeEnum.ATMC.getType());
                return ((BigInteger)tQuery.uniqueResult()).longValue();
            }
        });
    }
}

