/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.MonitorLogDao;
import com.digiwin.athena.itsys.dao.impl.GenericDaoImpl;
import com.digiwin.athena.itsys.enums.EocLevelEnum;
import com.digiwin.athena.itsys.model.MonitorLog;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="itsysTransactionManager")
public class MonitorLogDaoImpl
extends GenericDaoImpl<MonitorLog, Long>
implements MonitorLogDao {
    public MonitorLogDaoImpl() {
        super(MonitorLog.class);
    }

    @Override
    public List<MonitorLog> getMonitorLogsByTraceIds(final List<String> pTraceIds, final String pTenantId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<MonitorLog>>(){

            public List<MonitorLog> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(MonitorLog.class);
                criteria.add((Criterion)Restrictions.eq((String)"tenantId", (Object)pTenantId));
                criteria.add(Restrictions.in((String)"traceId", (Collection)pTraceIds));
                criteria.add((Criterion)Restrictions.eq((String)"initial", (Object)false));
                return criteria.list();
            }
        });
    }

    @Override
    public List<MonitorLog> getMonitorLogsByTraceIdsAndRuleCode(final Collection<String> pTraceIds, final String pTenantId, final String ruleCode) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<MonitorLog>>(){

            public List<MonitorLog> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(MonitorLog.class);
                criteria.add((Criterion)Restrictions.eq((String)"tenantId", (Object)pTenantId));
                criteria.add(Restrictions.in((String)"traceId", (Collection)pTraceIds));
                criteria.add((Criterion)Restrictions.eq((String)"initial", (Object)false));
                criteria.add((Criterion)Restrictions.eq((String)"ruleCode", (Object)ruleCode));
                criteria.add((Criterion)Restrictions.eq((String)"state", (Object)true));
                return criteria.list();
            }
        });
    }

    @Override
    public List<MonitorLog> getMonitorLogsBySourceIdAndTenantId(final String pSourceId, final String pTenantId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<MonitorLog>>(){

            public List<MonitorLog> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from MonitorLog where tenantId=:tenant_id and sourceId=:source_id and initial=:initial");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), MonitorLog.class);
                tQuery.setParameter("tenant_id", (Object)pTenantId).setParameter("source_id", (Object)("%" + pSourceId + "%"));
                tQuery.setParameter("initial", (Object)false);
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public List<MonitorLog> getRecentInitialLog(final String pTenantId, final String pRuleCode, final Map<String, String> pEocConditionMap) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<MonitorLog>>(){

            public List<MonitorLog> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from MonitorLog where tenantId=:tenant_id and ruleCode=:rule_code and initial=:initial ");
                for (String eocLevel : pEocConditionMap.keySet()) {
                    if (eocLevel.equals(EocLevelEnum.COMPANY.getLevel())) {
                        tHqlSB.append("and eocCompanyId=:eoc_company_id ");
                    }
                    if (eocLevel.equals(EocLevelEnum.SITE.getLevel())) {
                        tHqlSB.append("and eocSiteId=:eoc_site_id ");
                    }
                    if (!eocLevel.equals(EocLevelEnum.REGION.getLevel())) continue;
                    tHqlSB.append("and eocRegionId=:eoc_region_id ");
                }
                tHqlSB.append("order by id desc");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), MonitorLog.class);
                tQuery.setMaxResults(1);
                tQuery.setParameter("tenant_id", (Object)pTenantId);
                tQuery.setParameter("rule_code", (Object)pRuleCode);
                tQuery.setParameter("initial", (Object)true);
                for (String eocLevel : pEocConditionMap.keySet()) {
                    if (eocLevel.equals(EocLevelEnum.COMPANY.getLevel())) {
                        tQuery.setParameter("eoc_company_id", pEocConditionMap.get(EocLevelEnum.COMPANY.getLevel()));
                    }
                    if (eocLevel.equals(EocLevelEnum.SITE.getLevel())) {
                        tQuery.setParameter("eoc_site_id", pEocConditionMap.get(EocLevelEnum.SITE.getLevel()));
                    }
                    if (!eocLevel.equals(EocLevelEnum.REGION.getLevel())) continue;
                    tQuery.setParameter("eoc_region_id", pEocConditionMap.get(EocLevelEnum.REGION.getLevel()));
                }
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public List<MonitorLog> getRecentFinishedLog(final String pTenantId, final String pRuleCode, final Map<String, String> pEocConditionMap) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<MonitorLog>>(){

            public List<MonitorLog> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from MonitorLog where tenantId=:tenant_id and ruleCode=:rule_code and initial=:initial ");
                for (String eocLevel : pEocConditionMap.keySet()) {
                    if (eocLevel.equals(EocLevelEnum.COMPANY.getLevel())) {
                        tHqlSB.append("and eocCompanyId=:eoc_company_id ");
                    }
                    if (eocLevel.equals(EocLevelEnum.SITE.getLevel())) {
                        tHqlSB.append("and eocSiteId=:eoc_site_id ");
                    }
                    if (!eocLevel.equals(EocLevelEnum.REGION.getLevel())) continue;
                    tHqlSB.append("and eocRegionId=:eoc_region_id ");
                }
                tHqlSB.append("order by id desc");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), MonitorLog.class);
                tQuery.setMaxResults(1);
                tQuery.setParameter("tenant_id", (Object)pTenantId);
                tQuery.setParameter("rule_code", (Object)pRuleCode);
                tQuery.setParameter("initial", (Object)false);
                for (String eocLevel : pEocConditionMap.keySet()) {
                    if (eocLevel.equals(EocLevelEnum.COMPANY.getLevel())) {
                        tQuery.setParameter("eoc_company_id", pEocConditionMap.get(EocLevelEnum.COMPANY.getLevel()));
                    }
                    if (eocLevel.equals(EocLevelEnum.SITE.getLevel())) {
                        tQuery.setParameter("eoc_site_id", pEocConditionMap.get(EocLevelEnum.SITE.getLevel()));
                    }
                    if (!eocLevel.equals(EocLevelEnum.REGION.getLevel())) continue;
                    tQuery.setParameter("eoc_region_id", pEocConditionMap.get(EocLevelEnum.REGION.getLevel()));
                }
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public List<MonitorLog> getInitialLogByTraceId(final String pTraceId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<MonitorLog>>(){

            public List<MonitorLog> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from MonitorLog where traceId=:trace_id and initial=:initial");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), MonitorLog.class);
                tQuery.setMaxResults(1);
                tQuery.setParameter("trace_id", (Object)pTraceId);
                tQuery.setParameter("initial", (Object)true);
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public void deleteMonitorLogsByTenantId(final String pTenantId) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session pSession) throws HibernateException {
                Query tQuery = pSession.createQuery("delete MonitorLog where tenantId =:tenantId");
                tQuery.setParameter("tenantId", (Object)pTenantId);
                return tQuery.executeUpdate();
            }
        });
    }
}

