/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.dao.impl;

import com.digiwin.athena.itsys.dao.ProcessLogDao;
import com.digiwin.athena.itsys.dao.impl.GenericDaoImpl;
import com.digiwin.athena.itsys.model.ProcessLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="itsysTransactionManager")
public class ProcessLogDaoImpl
extends GenericDaoImpl<ProcessLog, Long>
implements ProcessLogDao {
    SimpleDateFormat formatToDate = new SimpleDateFormat("yyyy-MM-dd");

    public ProcessLogDaoImpl() {
        super(ProcessLog.class);
    }

    @Override
    public List<ProcessLog> fetch(Map<String, String> pConditions) {
        List tReturn = null;
        tReturn = (List)this.doHibernateQuery(pConditions);
        return tReturn;
    }

    public Object doHibernateQuery(final Map<String, String> pConditions) {
        Object tReturn = null;
        tReturn = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                ArrayList<Integer> states = new ArrayList<Integer>();
                tHqlSB.append("from ProcessLog where tenantId=:tenant_id and state in (:state)");
                if (pConditions.containsKey("query_start_date")) {
                    tHqlSB.append(" and DATE(createdTime)>=:query_start_date and DATE(createdTime)<=:query_end_date");
                }
                Query tQuery = pSession.createQuery(tHqlSB.toString(), ProcessLog.class);
                if (pConditions.containsKey("tenant_id")) {
                    tQuery.setParameter("tenant_id", pConditions.get("tenant_id"));
                }
                if (pConditions.containsKey("query_start_date")) {
                    try {
                        tQuery.setParameter("query_start_date", (Object)ProcessLogDaoImpl.this.formatToDate.parse((String)pConditions.get("query_start_date")));
                        tQuery.setParameter("query_end_date", (Object)ProcessLogDaoImpl.this.formatToDate.parse((String)pConditions.get("query_end_date")));
                    }
                    catch (ParseException e) {
                        ProcessLogDaoImpl.this.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                states.add(1);
                states.add(2);
                tQuery.setParameterList("state", states);
                return tQuery.getResultList();
            }
        });
        return tReturn;
    }

    @Override
    public List<ProcessLog> getProcessLogsByTraceId(final String pTraceId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ProcessLog>>(){

            public List<ProcessLog> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from ProcessLog where traceId=:trace_id");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), ProcessLog.class);
                tQuery.setParameter("trace_id", (Object)pTraceId);
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public List<ProcessLog> getProcessLogsBySerialNumber(final String pSerialNumber) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ProcessLog>>(){

            public List<ProcessLog> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from ProcessLog where processSerialNumber=:processSerialNumber");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), ProcessLog.class);
                tQuery.setParameter("processSerialNumber", (Object)pSerialNumber);
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public List<ProcessLog> getRunningProcessesBySerialNumbers(final List<String> pSerialNumbers) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ProcessLog>>(){

            public List<ProcessLog> doInHibernate(Session pSession) throws HibernateException {
                Criteria criteria = pSession.createCriteria(ProcessLog.class);
                criteria.add(Restrictions.in((String)"processSerialNumber", (Collection)pSerialNumbers));
                criteria.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"state", (Object)1)).add((Criterion)Restrictions.eq((String)"state", (Object)2)));
                return criteria.list();
            }
        });
    }

    @Override
    public void deleteProcessLogsByTenantId(final String pTenantId) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session pSession) throws HibernateException {
                Query tQuery = pSession.createQuery("delete ProcessLog where tenantId =:tenantId");
                tQuery.setParameter("tenantId", (Object)pTenantId);
                return tQuery.executeUpdate();
            }
        });
    }
}

