/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.service;

import com.digiwin.athena.itsys.util.StringUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class JsonManipulateService {
    static ObjectMapper objectMapper = new ObjectMapper();
    SimpleDateFormat formatToSecond = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    static String EARLIEST_TIME = "1000-01-01 00:00:00";
    protected final Log log = LogFactory.getLog(this.getClass());

    public List<Map<String, Object>> sortJsonArrayByAttribute(List<Map<String, Object>> pArrayNode, final String pAttribute, final boolean isReverse) throws ParseException {
        int i;
        ArrayList<Map<String, Object>> sortedJsonArray = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (i = 0; i < pArrayNode.size(); ++i) {
            list.add(pArrayNode.get(i));
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                Date date1 = null;
                Date date2 = null;
                try {
                    String detectTime1 = StringUtil.isEmptyOrSpace(((Map)o1).get(pAttribute)) ? EARLIEST_TIME : String.valueOf(((Map)o1).get(pAttribute));
                    String detectTime2 = StringUtil.isEmptyOrSpace(((Map)o2).get(pAttribute)) ? EARLIEST_TIME : String.valueOf(((Map)o2).get(pAttribute));
                    date1 = JsonManipulateService.this.formatToSecond.parse(detectTime1);
                    date2 = JsonManipulateService.this.formatToSecond.parse(detectTime2);
                    int resVal = date1.compareTo(date2);
                    if (isReverse) {
                        return -resVal;
                    }
                    return resVal;
                }
                catch (ParseException e) {
                    JsonManipulateService.this.log.error((Object)e.getMessage(), (Throwable)e);
                    return 0;
                }
            }
        });
        for (i = 0; i < pArrayNode.size(); ++i) {
            sortedJsonArray.add((Map<String, Object>)list.get(i));
        }
        return sortedJsonArray;
    }
}

