/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.service;

import com.digiwin.athena.itsys.enums.ActivityLogConditionEnum;
import com.digiwin.athena.itsys.enums.MappingTypeEnum;
import com.digiwin.athena.itsys.model.ActivityLog;
import com.digiwin.athena.itsys.model.ErrorMessage;
import com.digiwin.athena.itsys.model.MonitorLog;
import com.digiwin.athena.itsys.model.ProcessLog;
import com.digiwin.athena.itsys.model.ProjectLog;
import com.digiwin.athena.itsys.model.TaskLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class LogManipulateService {
    public Map<String, List<ErrorMessage>> mapErrorMessageByType(List<ErrorMessage> errorMessages, String pType) {
        HashMap<String, List<ErrorMessage>> returnMap;
        block5: {
            block4: {
                returnMap = new HashMap<String, List<ErrorMessage>>();
                if (!pType.equals(MappingTypeEnum.SERIAL_NUMBER.getType())) break block4;
                for (ErrorMessage errorMessage : errorMessages) {
                    if (returnMap.get(errorMessage.getProcessSerialNumber()) != null) {
                        ((List)returnMap.get(errorMessage.getProcessSerialNumber())).add(errorMessage);
                        continue;
                    }
                    ArrayList<ErrorMessage> errorList = new ArrayList<ErrorMessage>();
                    errorList.add(errorMessage);
                    returnMap.put(errorMessage.getProcessSerialNumber(), errorList);
                }
                break block5;
            }
            if (!pType.equals(MappingTypeEnum.TRACE_ID.getType())) break block5;
            for (ErrorMessage errorMessage : errorMessages) {
                if (returnMap.get(errorMessage.getTraceId()) != null) {
                    ((List)returnMap.get(errorMessage.getTraceId())).add(errorMessage);
                    continue;
                }
                ArrayList<ErrorMessage> errorList = new ArrayList<ErrorMessage>();
                errorList.add(errorMessage);
                returnMap.put(errorMessage.getTraceId(), errorList);
            }
        }
        return returnMap;
    }

    public Map<String, List<ProcessLog>> mapProcessLogByType(List<ProcessLog> processLogs, String pType) {
        HashMap<String, List<ProcessLog>> returnMap;
        block5: {
            block4: {
                returnMap = new HashMap<String, List<ProcessLog>>();
                if (!pType.equals(MappingTypeEnum.SERIAL_NUMBER.getType())) break block4;
                for (ProcessLog processLog : processLogs) {
                    if (returnMap.get(processLog.getProcessSerialNumber()) != null) {
                        ((List)returnMap.get(processLog.getProcessSerialNumber())).add(processLog);
                        continue;
                    }
                    ArrayList<ProcessLog> processLogList = new ArrayList<ProcessLog>();
                    processLogList.add(processLog);
                    returnMap.put(processLog.getProcessSerialNumber(), processLogList);
                }
                break block5;
            }
            if (!pType.equals(MappingTypeEnum.TRACE_ID.getType())) break block5;
            for (ProcessLog processLog : processLogs) {
                if (returnMap.get(processLog.getTraceId()) != null) {
                    ((List)returnMap.get(processLog.getTraceId())).add(processLog);
                    continue;
                }
                ArrayList<ProcessLog> processLogList = new ArrayList<ProcessLog>();
                processLogList.add(processLog);
                returnMap.put(processLog.getTraceId(), processLogList);
            }
        }
        return returnMap;
    }

    public Map<String, List<MonitorLog>> mapMonitorLogByType(List<MonitorLog> MonitorLogs, String pType) {
        HashMap<String, List<MonitorLog>> returnMap = new HashMap<String, List<MonitorLog>>();
        if (pType.equals(MappingTypeEnum.TRACE_ID.getType())) {
            for (MonitorLog MonitorLog2 : MonitorLogs) {
                if (returnMap.get(MonitorLog2.getTraceId()) != null) {
                    ((List)returnMap.get(MonitorLog2.getTraceId())).add(MonitorLog2);
                    continue;
                }
                ArrayList<MonitorLog> MonitorLogList = new ArrayList<MonitorLog>();
                MonitorLogList.add(MonitorLog2);
                returnMap.put(MonitorLog2.getTraceId(), MonitorLogList);
            }
        }
        return returnMap;
    }

    public Map<String, List<ProjectLog>> mapProjectLogByType(List<ProjectLog> projectLogs, String pType) {
        HashMap<String, List<ProjectLog>> returnMap;
        block7: {
            block8: {
                block6: {
                    returnMap = new HashMap<String, List<ProjectLog>>();
                    if (!pType.equals(MappingTypeEnum.SERIAL_NUMBER.getType())) break block6;
                    for (ProjectLog projectLog : projectLogs) {
                        if (returnMap.get(projectLog.getProcessSerialNumber()) != null) {
                            ((List)returnMap.get(projectLog.getProcessSerialNumber())).add(projectLog);
                            continue;
                        }
                        ArrayList<ProjectLog> projectLogList = new ArrayList<ProjectLog>();
                        projectLogList.add(projectLog);
                        returnMap.put(projectLog.getProcessSerialNumber(), projectLogList);
                    }
                    break block7;
                }
                if (!pType.equals(MappingTypeEnum.TRACE_ID.getType())) break block8;
                for (ProjectLog projectLog : projectLogs) {
                    if (returnMap.get(projectLog.getTraceId()) != null) {
                        ((List)returnMap.get(projectLog.getTraceId())).add(projectLog);
                        continue;
                    }
                    ArrayList<ProjectLog> projectLogList = new ArrayList<ProjectLog>();
                    projectLogList.add(projectLog);
                    returnMap.put(projectLog.getTraceId(), projectLogList);
                }
                break block7;
            }
            if (!pType.equals(MappingTypeEnum.APP_ID.getType())) break block7;
            for (ProjectLog projectLog : projectLogs) {
                if (returnMap.get(projectLog.getAppId()) != null) {
                    ((List)returnMap.get(projectLog.getAppId())).add(projectLog);
                    continue;
                }
                ArrayList<ProjectLog> projectLogList = new ArrayList<ProjectLog>();
                projectLogList.add(projectLog);
                returnMap.put(projectLog.getAppId(), projectLogList);
            }
        }
        return returnMap;
    }

    public Map<String, List<TaskLog>> mapTaskLogByType(List<TaskLog> taskLogs, String pType) {
        HashMap<String, List<TaskLog>> returnMap;
        block5: {
            block4: {
                returnMap = new HashMap<String, List<TaskLog>>();
                if (!pType.equals(MappingTypeEnum.TASK_UID.getType())) break block4;
                for (TaskLog taskLog : taskLogs) {
                    if (returnMap.get(taskLog.getTaskUid()) != null) {
                        ((List)returnMap.get(taskLog.getTaskUid())).add(taskLog);
                        continue;
                    }
                    ArrayList<TaskLog> taskLogList = new ArrayList<TaskLog>();
                    taskLogList.add(taskLog);
                    returnMap.put(taskLog.getTaskUid(), taskLogList);
                }
                break block5;
            }
            if (!pType.equals(MappingTypeEnum.APP_ID.getType())) break block5;
            for (TaskLog taskLog : taskLogs) {
                if (returnMap.get(taskLog.getAppId()) != null) {
                    ((List)returnMap.get(taskLog.getAppId())).add(taskLog);
                    continue;
                }
                ArrayList<TaskLog> taskLogList = new ArrayList<TaskLog>();
                taskLogList.add(taskLog);
                returnMap.put(taskLog.getAppId(), taskLogList);
            }
        }
        return returnMap;
    }

    public void sortLatestProjectLog(Map<String, List<ProjectLog>> pProjectLogMaps) {
        for (String tSerialNmber : pProjectLogMaps.keySet()) {
            ArrayList<ProjectLog> latestLog;
            Map<String, List<ProjectLog>> tProjectLogMapByAppId = this.mapProjectLogByType(pProjectLogMaps.get(tSerialNmber), MappingTypeEnum.APP_ID.getType());
            if (tProjectLogMapByAppId.get("ptm") != null) {
                Collections.sort(tProjectLogMapByAppId.get("ptm"), new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((ProjectLog)o1).getBuildTime().getTime().compareTo(((ProjectLog)o2).getBuildTime().getTime());
                    }
                });
                latestLog = new ArrayList<ProjectLog>();
                latestLog.add(tProjectLogMapByAppId.get("ptm").get(tProjectLogMapByAppId.get("ptm").size() - 1));
                pProjectLogMaps.put(tSerialNmber, latestLog);
                continue;
            }
            if (tProjectLogMapByAppId.get("taskengine") == null) continue;
            Collections.sort(tProjectLogMapByAppId.get("taskengine"), new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ProjectLog)o1).getBuildTime().getTime().compareTo(((ProjectLog)o2).getBuildTime().getTime());
                }
            });
            latestLog = new ArrayList();
            latestLog.add(tProjectLogMapByAppId.get("taskengine").get(tProjectLogMapByAppId.get("taskengine").size() - 1));
            pProjectLogMaps.put(tSerialNmber, latestLog);
        }
    }

    public TaskLog getLatestTaskLog(List<TaskLog> pTaskLogs) {
        TaskLog tReturnTaskLog = null;
        Map<String, List<TaskLog>> tTaskLogMapByAppId = this.mapTaskLogByType(pTaskLogs, MappingTypeEnum.APP_ID.getType());
        if (tTaskLogMapByAppId.get("ptm") != null) {
            Collections.sort(tTaskLogMapByAppId.get("ptm"), new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((TaskLog)o1).getBuildTime().getTime().compareTo(((TaskLog)o2).getBuildTime().getTime());
                }
            });
            tReturnTaskLog = tTaskLogMapByAppId.get("ptm").get(tTaskLogMapByAppId.get("ptm").size() - 1);
        } else if (tTaskLogMapByAppId.get("taskengine") != null) {
            Collections.sort(tTaskLogMapByAppId.get("taskengine"), new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((TaskLog)o1).getBuildTime().getTime().compareTo(((TaskLog)o2).getBuildTime().getTime());
                }
            });
            tReturnTaskLog = tTaskLogMapByAppId.get("taskengine").get(tTaskLogMapByAppId.get("taskengine").size() - 1);
        }
        return tReturnTaskLog;
    }

    public void sortLatestMonitorLog(Map<String, List<MonitorLog>> pMonitorLogMaps) {
        for (String tTraceId : pMonitorLogMaps.keySet()) {
            if (pMonitorLogMaps.get(tTraceId).isEmpty()) continue;
            Collections.sort(pMonitorLogMaps.get(tTraceId), new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((MonitorLog)o1).getBuildTime().getTime().compareTo(((MonitorLog)o2).getBuildTime().getTime());
                }
            });
            ArrayList<MonitorLog> latestLog = new ArrayList<MonitorLog>();
            latestLog.add(pMonitorLogMaps.get(tTraceId).get(pMonitorLogMaps.get(tTraceId).size() - 1));
            pMonitorLogMaps.put(tTraceId, latestLog);
        }
    }

    public List<TaskLog> getTargetTaskLogs(List<TaskLog> pAllTaskLogs, Map<String, String> pCondition) {
        ArrayList<TaskLog> tFilterResult = new ArrayList<TaskLog>();
        ArrayList<TaskLog> result = new ArrayList<TaskLog>();
        tFilterResult.addAll(pAllTaskLogs);
        result.addAll(pAllTaskLogs);
        Iterator<String> iterator = pCondition.keySet().iterator();
        while (iterator.hasNext()) {
            String conditionKey;
            switch (conditionKey = iterator.next()) {
                case "TENANT_ID": {
                    for (TaskLog taskLog : tFilterResult) {
                        if (pCondition.get(conditionKey) == null) {
                            result.remove(taskLog);
                            continue;
                        }
                        if (pCondition.get(conditionKey).equals(taskLog.getTenantId())) continue;
                        result.remove(taskLog);
                    }
                    break;
                }
                case "PROCESS_SERIAL_NUMBER": {
                    for (TaskLog taskLog : tFilterResult) {
                        if (pCondition.get(conditionKey) == null) {
                            result.remove(taskLog);
                            continue;
                        }
                        if (pCondition.get(conditionKey).equals(taskLog.getProcessSerialNumber())) continue;
                        result.remove(taskLog);
                    }
                    break;
                }
                case "TASK_UID": {
                    for (TaskLog taskLog : tFilterResult) {
                        if (pCondition.get(conditionKey) == null) {
                            result.remove(taskLog);
                            continue;
                        }
                        if (pCondition.get(conditionKey).equals(taskLog.getTaskUid())) continue;
                        result.remove(taskLog);
                    }
                    break;
                }
            }
            tFilterResult.clear();
            tFilterResult.addAll(result);
        }
        return result;
    }

    public List<ActivityLog> getTargetActivityLogs(List<ActivityLog> pAllActivityLogs, Map<String, String> pCondition) {
        ArrayList<ActivityLog> tFilterResult = new ArrayList<ActivityLog>();
        ArrayList<ActivityLog> result = new ArrayList<ActivityLog>();
        tFilterResult.addAll(pAllActivityLogs);
        result.addAll(pAllActivityLogs);
        Iterator<String> iterator = pCondition.keySet().iterator();
        while (iterator.hasNext()) {
            String conditionKey;
            switch (conditionKey = iterator.next()) {
                case "TENANT_ID": {
                    for (ActivityLog activityLog : tFilterResult) {
                        if (pCondition.get(conditionKey) == null) {
                            result.remove(activityLog);
                            continue;
                        }
                        if (pCondition.get(conditionKey).equals(activityLog.getTenantId())) continue;
                        result.remove(activityLog);
                    }
                    break;
                }
                case "APP_ID": {
                    for (ActivityLog activityLog : tFilterResult) {
                        if (pCondition.get(conditionKey) == null) {
                            result.remove(activityLog);
                            continue;
                        }
                        if (pCondition.get(conditionKey).equals(activityLog.getAppId())) continue;
                        result.remove(activityLog);
                    }
                    break;
                }
                case "TASK_UID": {
                    for (ActivityLog activityLog : tFilterResult) {
                        if (pCondition.get(conditionKey) == null) {
                            result.remove(activityLog);
                            continue;
                        }
                        if (pCondition.get(conditionKey).equals(activityLog.getTaskUid())) continue;
                        result.remove(activityLog);
                    }
                    break;
                }
                case "ACTIVITY_UID": {
                    for (ActivityLog activityLog : tFilterResult) {
                        if (pCondition.get(conditionKey) == null) {
                            result.remove(activityLog);
                            continue;
                        }
                        if (pCondition.get(conditionKey).equals(activityLog.getActivityUid())) continue;
                        result.remove(activityLog);
                    }
                    break;
                }
                case "TASK_CARD_ID": {
                    for (ActivityLog activityLog : tFilterResult) {
                        if (pCondition.get(conditionKey) == null) {
                            result.remove(activityLog);
                            continue;
                        }
                        if (pCondition.get(conditionKey).equals(activityLog.getTaskCardId())) continue;
                        result.remove(activityLog);
                    }
                    break;
                }
            }
            tFilterResult.clear();
            tFilterResult.addAll(result);
        }
        if (!result.isEmpty() && pCondition.containsKey(ActivityLogConditionEnum.TOP_ONE_RECORD.toString())) {
            Collections.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ActivityLog)o1).getBuildTime().getTime().compareTo(((ActivityLog)o2).getBuildTime().getTime());
                }
            });
            ArrayList latestLog = new ArrayList();
            latestLog.add(result.get(result.size() - 1));
            result = latestLog;
        }
        return result;
    }
}

