/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataConvertUtil {
    private static ObjectMapper mapper = new ObjectMapper();

    public static <T> T convert(String pJson, Class<T> pClass) throws JsonParseException, JsonMappingException, IOException {
        Object tInstance = mapper.readValue(pJson, pClass);
        return (T)tInstance;
    }

    public static <T> T convert(JsonNode pJson, Class<T> pClass) throws JsonParseException, JsonMappingException, IOException {
        Object tInstance = mapper.convertValue((Object)pJson, pClass);
        return (T)tInstance;
    }

    public static <T> T convert(Map<String, Object> pData, Class<T> pClass) {
        Object tInstance = mapper.convertValue(pData, pClass);
        return (T)tInstance;
    }

    public static <T> List<T> convertList(String pJson, Class<T> pClass) throws JsonParseException, JsonMappingException, IOException {
        CollectionType tType = mapper.getTypeFactory().constructCollectionType(List.class, pClass);
        List tInstanceList = (List)mapper.readValue(pJson, (JavaType)tType);
        return tInstanceList;
    }

    public static <T> List<T> convertList(JsonNode pJson, Class<T> pClass) throws JsonParseException, JsonMappingException, IOException {
        CollectionType tType = mapper.getTypeFactory().constructCollectionType(List.class, pClass);
        List tInstanceList = (List)mapper.convertValue((Object)pJson, (JavaType)tType);
        return tInstanceList;
    }

    public static <T> List<T> convertList(List<Map<String, Object>> pDataList, Class<T> pClass) {
        ArrayList<T> tInstanceList = new ArrayList<T>();
        for (Map<String, Object> tData : pDataList) {
            tInstanceList.add(DataConvertUtil.convert(tData, pClass));
        }
        return tInstanceList;
    }
}

