/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.itsys.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtil.class);
    private static String POUND = "#";
    private static String EQUAL = "=";
    private List<String> keyList = new ArrayList<String>();
    private Map<String, String> valueMap = new HashMap<String, String>();

    public Map<String, String> getPropertyMap() {
        return this.valueMap;
    }

    public String getProperty(String key) {
        return this.valueMap.get(key);
    }

    public void setProperty(String key, String value) {
        if (!this.valueMap.containsKey(key)) {
            this.keyList.add(key);
        }
        this.valueMap.put(key, value);
    }

    public void delProperty(String key, String value) {
        if (this.valueMap.containsKey(key)) {
            Iterator<String> ikl = this.keyList.iterator();
            while (ikl.hasNext()) {
                if (!ikl.next().equals(key)) continue;
                ikl.remove();
            }
            this.valueMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream stream) throws IOException {
        InputStreamReader isr = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(isr);
        this.keyList.clear();
        this.valueMap.clear();
        try {
            while (reader.ready()) {
                this.saveLine(reader.readLine());
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (isr != null) {
                    ((Reader)isr).close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Writer writer) {
        BufferedWriter bw = new BufferedWriter(writer);
        try {
            for (String key : this.keyList) {
                bw.write(key);
                if (this.valueMap.containsKey(key)) {
                    bw.write(EQUAL);
                    bw.write(this.valueMap.get(key));
                }
                bw.newLine();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void saveLine(String line) {
        if (line.trim().startsWith(POUND)) {
            this.keyList.add(line);
        } else if (line.indexOf(EQUAL) > -1) {
            String k = line.substring(0, line.indexOf(EQUAL)).trim();
            String v = line.substring(line.indexOf(EQUAL) + 1).trim();
            this.keyList.add(k);
            this.valueMap.put(k, v);
        } else {
            this.keyList.add(line);
        }
    }

    public String toString() {
        return this.valueMap.toString();
    }
}

