package com.digiwin.athena.itsys.api.service;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;

import java.util.Map;

public interface IProcessLogService extends DWService {

	// IT運維模組執行視角取得資料
	@AllowAnonymous
	public Map<String, Object> postView (String tenantId, String sourceId, String queryStartDate, String queryEndDate,
                                         String condition, String ruleCode, String createdTime, String processSerialNumber) throws Exception;

	// 取得阻塞資訊
	@AllowAnonymous
	Map<String, Object> getBlockedSummary (Integer pageSize, Integer pageNum) throws Exception;

	@AllowAnonymous
	Map<String, Object> getExceptionDetailById (Long errorLogId) throws Exception;

	@AllowAnonymous
	Map<String, Object> getExceptionDetailByProcessSerialNumber (String processSerialNumber) throws Exception;

	// 根據租戶ID刪除資料
	@AllowAnonymous
	public Map<String, Object> postDelete (String tenantId) throws Exception;

	// 設定接收異常通知信件帳號
	@AllowAnonymous
	Map<String, Object> postSetUserSend (String tenantId, String userSend, String toggle) throws Exception;

	@AllowAnonymous
	Map<String, Object> postCheckUserSend (String tenantId, String userId) throws Exception;

	// 偵測立即執行交互優化
	@AllowAnonymous
	Map<String, Object> postMonitorTime (String tenantId, String ruleCode, String eocId) throws Exception;

	// IT運維模組項目查詢取得資料
	@AllowAnonymous
	public Map<String, Object> postProjectView (String appCode, String tmProjectCode, String tenantId,
                                                String queryStartDate, String queryEndDate, String condition) throws Exception;

}
