package com.digiwin.athena.itsys.api.service.impl;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.itsys.api.service.IProjectLogQueryService;
import com.digiwin.athena.itsys.api.service.processor.ProjectViewProcessor;
import com.digiwin.athena.itsys.api.service.request.ErrorProjectRequest;
import com.digiwin.athena.itsys.api.service.response.ErrorProjectResonse;
import com.digiwin.athena.itsys.util.DateUtil;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2023/4/18 14:01
 */
@Service("ProjectLogQueryService")
public class ProjectLogQueryService implements IProjectLogQueryService {

    @Autowired
    private ProjectViewProcessor projectViewProcessor;

    /**
     * 应用使用需求编号62744
     * @param request
     * @return
     */
    @Override
    public ErrorProjectResonse queryErrorProject(ErrorProjectRequest request) {
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String tenantId = String.valueOf(profile.get("tenantId"));
        if (DateUtils.addDays(request.getStartDate(), 30).before(request.getEndDate())) {
            throw new IllegalArgumentException("date range more than 31 days");
        }
        request.setStartDate(DateUtil.getStartTimeOfDay(request.getStartDate()));
        request.setEndDate(DateUtil.getEndTimeOfDay(request.getEndDate()));
        return projectViewProcessor.queryErrorPoject(request, tenantId);
    }
}
